# coding: utf-8

"""
    BitBadges API

    # Introduction The BitBadges API is a RESTful API that enables developers to interact with the BitBadges blockchain and indexer. This API provides comprehensive access to the BitBadges ecosystem, allowing you to query and interact with digital badges, collections, accounts, blockchain data, and more. For complete documentation, see the [BitBadges Documentation](https://docs.bitbadges.io/for-developers/bitbadges-api/api) and use along with this reference.  Note: The API + documentation is new and may contain bugs. If you find any issues, please let us know via Discord or another contact method (https://bitbadges.io/contact).  # Getting Started  ## Authentication All API requests require an API key for authentication. You can obtain your API key from the [BitBadges Developer Portal](https://bitbadges.io/developer).  ### API Key Authentication Include your API key in the `x-api-key` header: ``` x-api-key: your-api-key-here ```  <br />  ## User Authentication Most read-only applications can function with just an API key. However, if you need to access private user data or perform actions on behalf of users, you have two options:  ### OAuth 2.0 (Sign In with BitBadges) For performing actions on behalf of other users, use the standard OAuth 2.0 flow via Sign In with BitBadges. See the [Sign In with BitBadges documentation](https://docs.bitbadges.io/for-developers/authenticating-with-bitbadges) for details.  You will pass the access token in the Authorization header: ``` Authorization: Bearer your-access-token-here ```  ### Password Self-Approve Method For automating actions for your own account: 1. Set up an approved password sign in in your account settings tab on https://bitbadges.io with desired scopes (e.g. `completeClaims`) 2. Sign in using: ```typescript const { message } = await BitBadgesApi.getSignInChallenge(...); const verificationRes = await BitBadgesApi.verifySignIn({     message,     signature: '', //Empty string     password: '...' }) ```  Note: This method uses HTTP session cookies. Ensure your requests support credentials (e.g. axios: { withCredentials: true }).  ### Scopes Note that for proper authentication, you must have the proper scopes set.  See [https://bitbadges.io/auth/linkgen](https://bitbadges.io/auth/linkgen) for a helper URL generation tool. The scopes will be included in the `scope` parameter of the SIWBB URL or set in your approved sign in settings.  Note that stuff marked as Full Access is typically reserved for the official site. If you think you may need this, contact us.  ### Available Scopes  - **Report** (`report`)   Report users or collections.  - **Read Profile** (`readProfile`)   Read your private profile information. This includes your email, approved sign-in methods, connections, and other private information.  - **Read Address Lists** (`readAddressLists`)   Read private address lists on behalf of the user.  - **Manage Address Lists** (`manageAddressLists`)   Create, update, and delete address lists on behalf of the user (private or public).  - **Manage Applications** (`manageApplications`)   Create, update, and delete applications on behalf of the user.  - **Manage Claims** (`manageClaims`)   Create, update, and delete claims on behalf of the user.  - **Manage Developer Apps** (`manageDeveloperApps`)   Create, update, and delete developer apps on behalf of the user.  - **Manage Dynamic Stores** (`manageDynamicStores`)   Create, update, and delete dynamic stores on behalf of the user.  - **Manage Utility Listings** (`manageUtilityListings`)   Create, update, and delete utility listings on behalf of the user.  - **Approve Sign In With BitBadges Requests** (`approveSignInWithBitBadgesRequests`)   Sign In with BitBadges on behalf of the user.  - **Read Authentication Codes** (`readAuthenticationCodes`)   Read Authentication Codes on behalf of the user.  - **Delete Authentication Codes** (`deleteAuthenticationCodes`)   Delete Authentication Codes on behalf of the user.  - **Send Claim Alerts** (`sendClaimAlerts`)   Send claim alerts on behalf of the user.  - **Read Claim Alerts** (`readClaimAlerts`)   Read claim alerts on behalf of the user. Note that claim alerts may contain sensitive information like claim codes, attestation IDs, etc.  - **Manage Attestations** (`manageAttestations`)   Manage attestations on behalf of the user. This includes creating, updating, and deleting attestations.  - **Read Attestations** (`readAttestations`)   Read attestations on behalf of the user.  - **Read Private Claim Data** (`readPrivateClaimData`)   Read private claim data on behalf of the user (e.g. codes, passwords, private user lists, etc.).  - **Complete Claims** (`completeClaims`)   Complete claims on behalf of the user.  - **Manage Off-Chain Balances** (`manageOffChainBalances`)   Manage off-chain balances on behalf of the user.  - **Embedded Wallet** (`embeddedWallet`)   Sign transactions on behalf of the user with their embedded wallet.  <br />  ## SDK Integration The recommended way to interact with the API is through our TypeScript/JavaScript SDK:  ```typescript import { BigIntify, BitBadgesAPI } from \"bitbadgesjs-sdk\";  // Initialize the API client const api = new BitBadgesAPI({   convertFunction: BigIntify,   apiKey: 'your-api-key-here' });  // Example: Fetch collections const collections = await api.getCollections({   collectionsToFetch: [{     collectionId: 1n,     metadataToFetch: {       badgeIds: [{ start: 1n, end: 10n }]     }   }] }); ```  <br />  # Tiers There are 3 tiers of API keys, each with different rate limits and permissions. See the pricing page for more details: https://bitbadges.io/pricing - Free tier - Premium tier - Enterprise tier  Rate limit headers included in responses: - `X-RateLimit-Limit`: Total requests allowed per window - `X-RateLimit-Remaining`: Remaining requests in current window - `X-RateLimit-Reset`: Time until rate limit resets (UTC timestamp)  # Response Formats  ## Error Response  All API errors follow a consistent format:  ```typescript {   // Serialized error object for debugging purposes   // Advanced users can use this to debug issues   error?: any;    // UX-friendly error message that can be displayed to the user   // Always present if error occurs   errorMessage: string;    // Authentication error flag   // Present if the user is not authenticated   unauthorized?: boolean; } ```  <br />  ## Pagination Cursor-based pagination is used for list endpoints: ```typescript {   items: T[],   bookmark: string, // Use this for the next page   hasMore: boolean } ```  <br />  # Best Practices 1. **Rate Limiting**: Implement proper rate limit handling 2. **Caching**: Cache responses when appropriate 3. **Error Handling**: Handle API errors gracefully 4. **Batch Operations**: Use batch endpoints when possible  # Additional Resources - [Official Documentation](https://docs.bitbadges.io/for-developers/bitbadges-api/api) - [SDK Documentation](https://docs.bitbadges.io/for-developers/bitbadges-sdk/overview) - [Developer Portal](https://bitbadges.io/developer) - [GitHub SDK Repository](https://github.com/bitbadges/bitbadgesjs) - [Quickstarter Repository](https://github.com/bitbadges/bitbadges-quickstart)  # Support - [Contact Page](https://bitbadges.io/contact)

    The version of the OpenAPI document: 0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from bitbadgespy_sdk.models.i_badge_metadata_timeline import IBadgeMetadataTimeline
from bitbadgespy_sdk.models.i_collection_approval import ICollectionApproval
from bitbadgespy_sdk.models.i_collection_metadata_timeline import ICollectionMetadataTimeline
from bitbadgespy_sdk.models.i_collection_permissions import ICollectionPermissions
from bitbadgespy_sdk.models.i_cosmos_coin import ICosmosCoin
from bitbadgespy_sdk.models.i_cosmos_coin_wrapper_path_add_object import ICosmosCoinWrapperPathAddObject
from bitbadgespy_sdk.models.i_custom_data_timeline import ICustomDataTimeline
from bitbadgespy_sdk.models.i_manager_timeline import IManagerTimeline
from bitbadgespy_sdk.models.i_off_chain_balances_metadata_timeline import IOffChainBalancesMetadataTimeline
from bitbadgespy_sdk.models.i_standards_timeline import IStandardsTimeline
from bitbadgespy_sdk.models.i_uint_range import IUintRange
from bitbadgespy_sdk.models.i_user_balance_store import IUserBalanceStore
from bitbadgespy_sdk.models.iis_archived_timeline import IIsArchivedTimeline
from typing import Optional, Set
from typing_extensions import Self

class IMsgUniversalUpdateCollection(BaseModel):
    """
    IMsgUniversalUpdateCollection
    """ # noqa: E501
    creator: StrictStr = Field(description="All supported addresses map to a Bech32 BitBadges address which is used by the BitBadges blockchain behind the scenes. For conversion, see the BitBadges documentation. If this type is used, we must always convert to a BitBadges address before using it.")
    balances_type: Optional[StrictStr] = Field(default=None, description="The balances type. Either \"Standard\", \"Off-Chain - Indexed\", \"Off-Chain - Non-Indexed\" or \"Non-Public\"", alias="balancesType")
    default_balances: Optional[IUserBalanceStore] = Field(default=None, description="The default balances for users who have not interacted with the collection yet. Only can be set on initial creation. Only used if collection has \"Standard\" balance type.", alias="defaultBalances")
    valid_badge_ids: Optional[List[IUintRange]] = Field(default=None, description="The badges to create. Newly created badges will be sent to the \"Mint\" address. Must have necessary permissions in future transactions to update. However, no restrictions in this genesis Msg. Only used if collection has \"Standard\" balance type.", alias="validBadgeIds")
    collection_permissions: Optional[ICollectionPermissions] = Field(default=None, description="The new collection permissions. Must have the necessary permissions in future transactions to update. However, no restrictions in this genesis Msg.", alias="collectionPermissions")
    manager_timeline: Optional[List[IManagerTimeline]] = Field(default=None, description="The new manager timeline. Must have the necessary permissions in future transactions to update. However, no restrictions in this genesis Msg.", alias="managerTimeline")
    collection_metadata_timeline: Optional[List[ICollectionMetadataTimeline]] = Field(default=None, description="The new collection metadata timeline. Must have the necessary permissions in future transactions to update. However, no restrictions in this genesis Msg.", alias="collectionMetadataTimeline")
    badge_metadata_timeline: Optional[List[IBadgeMetadataTimeline]] = Field(default=None, description="The new badge metadata timeline. Must have the necessary permissions in future transactions to update. However, no restrictions in this genesis Msg. Note we take first-match only for badge IDs, so do not define duplicates.", alias="badgeMetadataTimeline")
    off_chain_balances_metadata_timeline: Optional[List[IOffChainBalancesMetadataTimeline]] = Field(default=None, description="The new off-chain balances metadata timeline. Must have the necessary permissions in future transactions to update. However, no restrictions in this genesis Msg. Only used if \"Off-Chain - Indexed\" or \"Off-Chain - Non-Indexed\" balance type.", alias="offChainBalancesMetadataTimeline")
    custom_data_timeline: Optional[List[ICustomDataTimeline]] = Field(default=None, description="The new custom data timeline. Must have the necessary permissions in future transactions to update. However, no restrictions in this genesis Msg.", alias="customDataTimeline")
    collection_approvals: Optional[List[ICollectionApproval]] = Field(default=None, description="The new collection approved transfers timeline. Must have the necessary permissions in future transactions to update. However, no restrictions in this genesis Msg.", alias="collectionApprovals")
    standards_timeline: Optional[List[IStandardsTimeline]] = Field(default=None, description="The new standards timeline. Must have the necessary permissions in future transactions to update. However, no restrictions in this genesis Msg.", alias="standardsTimeline")
    is_archived_timeline: Optional[List[IIsArchivedTimeline]] = Field(default=None, description="The new is archived timeline. Must have the necessary permissions in future transactions to update. However, no restrictions in this genesis Msg.", alias="isArchivedTimeline")
    mint_escrow_coins_to_transfer: Optional[List[ICosmosCoin]] = Field(default=None, description="The coins to mint to the transfer address. Only used if collection has \"Non-Public\" balance type.", alias="mintEscrowCoinsToTransfer")
    cosmos_coin_wrapper_paths_to_add: Optional[List[ICosmosCoinWrapperPathAddObject]] = Field(default=None, description="The IBC wrapper paths to add.", alias="cosmosCoinWrapperPathsToAdd")
    collection_id: StrictStr = Field(alias="collectionId")
    update_collection_permissions: Optional[StrictBool] = Field(default=None, description="Whether or not to update the collection permissions.", alias="updateCollectionPermissions")
    update_manager_timeline: Optional[StrictBool] = Field(default=None, description="Whether or not to update the manager timeline.", alias="updateManagerTimeline")
    update_collection_metadata_timeline: Optional[StrictBool] = Field(default=None, description="Whether or not to update the collection metadata timeline.", alias="updateCollectionMetadataTimeline")
    update_badge_metadata_timeline: Optional[StrictBool] = Field(default=None, description="Whether or not to update the badge metadata timeline.", alias="updateBadgeMetadataTimeline")
    update_off_chain_balances_metadata_timeline: Optional[StrictBool] = Field(default=None, description="Whether or not to update the off-chain balances metadata timeline.", alias="updateOffChainBalancesMetadataTimeline")
    update_custom_data_timeline: Optional[StrictBool] = Field(default=None, description="Whether or not to update the custom data timeline.", alias="updateCustomDataTimeline")
    update_collection_approvals: Optional[StrictBool] = Field(default=None, description="Whether or not to update the collection approved transfers timeline.", alias="updateCollectionApprovals")
    update_standards_timeline: Optional[StrictBool] = Field(default=None, description="Whether or not to update the standards timeline.", alias="updateStandardsTimeline")
    update_is_archived_timeline: Optional[StrictBool] = Field(default=None, description="Whether or not to update the is archived timeline.", alias="updateIsArchivedTimeline")
    update_valid_badge_ids: Optional[StrictBool] = Field(default=None, description="Whether or not to update the valid badge IDs.", alias="updateValidBadgeIds")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["creator", "balancesType", "defaultBalances", "validBadgeIds", "collectionPermissions", "managerTimeline", "collectionMetadataTimeline", "badgeMetadataTimeline", "offChainBalancesMetadataTimeline", "customDataTimeline", "collectionApprovals", "standardsTimeline", "isArchivedTimeline", "mintEscrowCoinsToTransfer", "cosmosCoinWrapperPathsToAdd", "collectionId", "updateCollectionPermissions", "updateManagerTimeline", "updateCollectionMetadataTimeline", "updateBadgeMetadataTimeline", "updateOffChainBalancesMetadataTimeline", "updateCustomDataTimeline", "updateCollectionApprovals", "updateStandardsTimeline", "updateIsArchivedTimeline", "updateValidBadgeIds"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of IMsgUniversalUpdateCollection from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of default_balances
        if self.default_balances:
            _dict['defaultBalances'] = self.default_balances.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in valid_badge_ids (list)
        _items = []
        if self.valid_badge_ids:
            for _item_valid_badge_ids in self.valid_badge_ids:
                if _item_valid_badge_ids:
                    _items.append(_item_valid_badge_ids.to_dict())
            _dict['validBadgeIds'] = _items
        # override the default output from pydantic by calling `to_dict()` of collection_permissions
        if self.collection_permissions:
            _dict['collectionPermissions'] = self.collection_permissions.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in manager_timeline (list)
        _items = []
        if self.manager_timeline:
            for _item_manager_timeline in self.manager_timeline:
                if _item_manager_timeline:
                    _items.append(_item_manager_timeline.to_dict())
            _dict['managerTimeline'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in collection_metadata_timeline (list)
        _items = []
        if self.collection_metadata_timeline:
            for _item_collection_metadata_timeline in self.collection_metadata_timeline:
                if _item_collection_metadata_timeline:
                    _items.append(_item_collection_metadata_timeline.to_dict())
            _dict['collectionMetadataTimeline'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in badge_metadata_timeline (list)
        _items = []
        if self.badge_metadata_timeline:
            for _item_badge_metadata_timeline in self.badge_metadata_timeline:
                if _item_badge_metadata_timeline:
                    _items.append(_item_badge_metadata_timeline.to_dict())
            _dict['badgeMetadataTimeline'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in off_chain_balances_metadata_timeline (list)
        _items = []
        if self.off_chain_balances_metadata_timeline:
            for _item_off_chain_balances_metadata_timeline in self.off_chain_balances_metadata_timeline:
                if _item_off_chain_balances_metadata_timeline:
                    _items.append(_item_off_chain_balances_metadata_timeline.to_dict())
            _dict['offChainBalancesMetadataTimeline'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in custom_data_timeline (list)
        _items = []
        if self.custom_data_timeline:
            for _item_custom_data_timeline in self.custom_data_timeline:
                if _item_custom_data_timeline:
                    _items.append(_item_custom_data_timeline.to_dict())
            _dict['customDataTimeline'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in collection_approvals (list)
        _items = []
        if self.collection_approvals:
            for _item_collection_approvals in self.collection_approvals:
                if _item_collection_approvals:
                    _items.append(_item_collection_approvals.to_dict())
            _dict['collectionApprovals'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in standards_timeline (list)
        _items = []
        if self.standards_timeline:
            for _item_standards_timeline in self.standards_timeline:
                if _item_standards_timeline:
                    _items.append(_item_standards_timeline.to_dict())
            _dict['standardsTimeline'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in is_archived_timeline (list)
        _items = []
        if self.is_archived_timeline:
            for _item_is_archived_timeline in self.is_archived_timeline:
                if _item_is_archived_timeline:
                    _items.append(_item_is_archived_timeline.to_dict())
            _dict['isArchivedTimeline'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in mint_escrow_coins_to_transfer (list)
        _items = []
        if self.mint_escrow_coins_to_transfer:
            for _item_mint_escrow_coins_to_transfer in self.mint_escrow_coins_to_transfer:
                if _item_mint_escrow_coins_to_transfer:
                    _items.append(_item_mint_escrow_coins_to_transfer.to_dict())
            _dict['mintEscrowCoinsToTransfer'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in cosmos_coin_wrapper_paths_to_add (list)
        _items = []
        if self.cosmos_coin_wrapper_paths_to_add:
            for _item_cosmos_coin_wrapper_paths_to_add in self.cosmos_coin_wrapper_paths_to_add:
                if _item_cosmos_coin_wrapper_paths_to_add:
                    _items.append(_item_cosmos_coin_wrapper_paths_to_add.to_dict())
            _dict['cosmosCoinWrapperPathsToAdd'] = _items
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of IMsgUniversalUpdateCollection from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "creator": obj.get("creator"),
            "balancesType": obj.get("balancesType"),
            "defaultBalances": IUserBalanceStore.from_dict(obj["defaultBalances"]) if obj.get("defaultBalances") is not None else None,
            "validBadgeIds": [IUintRange.from_dict(_item) for _item in obj["validBadgeIds"]] if obj.get("validBadgeIds") is not None else None,
            "collectionPermissions": ICollectionPermissions.from_dict(obj["collectionPermissions"]) if obj.get("collectionPermissions") is not None else None,
            "managerTimeline": [IManagerTimeline.from_dict(_item) for _item in obj["managerTimeline"]] if obj.get("managerTimeline") is not None else None,
            "collectionMetadataTimeline": [ICollectionMetadataTimeline.from_dict(_item) for _item in obj["collectionMetadataTimeline"]] if obj.get("collectionMetadataTimeline") is not None else None,
            "badgeMetadataTimeline": [IBadgeMetadataTimeline.from_dict(_item) for _item in obj["badgeMetadataTimeline"]] if obj.get("badgeMetadataTimeline") is not None else None,
            "offChainBalancesMetadataTimeline": [IOffChainBalancesMetadataTimeline.from_dict(_item) for _item in obj["offChainBalancesMetadataTimeline"]] if obj.get("offChainBalancesMetadataTimeline") is not None else None,
            "customDataTimeline": [ICustomDataTimeline.from_dict(_item) for _item in obj["customDataTimeline"]] if obj.get("customDataTimeline") is not None else None,
            "collectionApprovals": [ICollectionApproval.from_dict(_item) for _item in obj["collectionApprovals"]] if obj.get("collectionApprovals") is not None else None,
            "standardsTimeline": [IStandardsTimeline.from_dict(_item) for _item in obj["standardsTimeline"]] if obj.get("standardsTimeline") is not None else None,
            "isArchivedTimeline": [IIsArchivedTimeline.from_dict(_item) for _item in obj["isArchivedTimeline"]] if obj.get("isArchivedTimeline") is not None else None,
            "mintEscrowCoinsToTransfer": [ICosmosCoin.from_dict(_item) for _item in obj["mintEscrowCoinsToTransfer"]] if obj.get("mintEscrowCoinsToTransfer") is not None else None,
            "cosmosCoinWrapperPathsToAdd": [ICosmosCoinWrapperPathAddObject.from_dict(_item) for _item in obj["cosmosCoinWrapperPathsToAdd"]] if obj.get("cosmosCoinWrapperPathsToAdd") is not None else None,
            "collectionId": obj.get("collectionId"),
            "updateCollectionPermissions": obj.get("updateCollectionPermissions"),
            "updateManagerTimeline": obj.get("updateManagerTimeline"),
            "updateCollectionMetadataTimeline": obj.get("updateCollectionMetadataTimeline"),
            "updateBadgeMetadataTimeline": obj.get("updateBadgeMetadataTimeline"),
            "updateOffChainBalancesMetadataTimeline": obj.get("updateOffChainBalancesMetadataTimeline"),
            "updateCustomDataTimeline": obj.get("updateCustomDataTimeline"),
            "updateCollectionApprovals": obj.get("updateCollectionApprovals"),
            "updateStandardsTimeline": obj.get("updateStandardsTimeline"),
            "updateIsArchivedTimeline": obj.get("updateIsArchivedTimeline"),
            "updateValidBadgeIds": obj.get("updateValidBadgeIds")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


