class DtoErrorDescription:
    def __init__(self, fptr):
        self.fptr = fptr
        self.IFptr = fptr
        self.DTO_ERROR_DESCRIPTIONS = {
            self.IFptr.LIBFPTR_OK: "Ошибок нет",
            self.IFptr.LIBFPTR_ERROR_CONNECTION_DISABLED: "Соединение не установлено",
            self.IFptr.LIBFPTR_ERROR_NO_CONNECTION: "Нет связи",
            self.IFptr.LIBFPTR_ERROR_PORT_BUSY: "Порт занят",
            self.IFptr.LIBFPTR_ERROR_PORT_NOT_AVAILABLE: "Порт недоступен",
            self.IFptr.LIBFPTR_ERROR_INCORRECT_DATA: "Некорректные данные от устройства",
            self.IFptr.LIBFPTR_ERROR_INTERNAL: "Внутренняя ошибка библиотеки",
            self.IFptr.LIBFPTR_ERROR_UNSUPPORTED_CAST: "Неподдерживаемое преобразование типа параметра",
            self.IFptr.LIBFPTR_ERROR_NO_REQUIRED_PARAM: "Не найден обязательный параметр",
            self.IFptr.LIBFPTR_ERROR_INVALID_SETTINGS: "Некорректные настройки",
            self.IFptr.LIBFPTR_ERROR_NOT_CONFIGURED: "Драйвер не настроен",
            self.IFptr.LIBFPTR_ERROR_NOT_SUPPORTED: "Не поддерживается в данной версии",  # (драйвера или ККТ)
            self.IFptr.LIBFPTR_ERROR_INVALID_MODE: "Не поддерживается в данном режиме",
            self.IFptr.LIBFPTR_ERROR_INVALID_PARAM: "Нeкорректное значение параметра",
            self.IFptr.LIBFPTR_ERROR_NOT_LOADED: "Не удалось загрузить библиотеку",
            self.IFptr.LIBFPTR_ERROR_UNKNOWN: "Неизвестная ошибка",
            self.IFptr.LIBFPTR_ERROR_INVALID_SUM: "Неверная цена (сумма)",
            self.IFptr.LIBFPTR_ERROR_INVALID_QUANTITY: "Неверное количество",
            self.IFptr.LIBFPTR_ERROR_CASH_COUNTER_OVERFLOW: "Переполнение счетчика наличности",
            self.IFptr.LIBFPTR_ERROR_LAST_OPERATION_STORNO_DENIED: "Невозможно сторно последней операции",
            self.IFptr.LIBFPTR_ERROR_STORNO_BY_CODE_DENIED: "Сторно по коду невозможно",
            self.IFptr.LIBFPTR_ERROR_LAST_OPERATION_NOT_REPEATABLE: "Невозможен повтор последней операции",
            self.IFptr.LIBFPTR_ERROR_DISCOUNT_NOT_REPEATABLE: "Повторная скидка на операцию невозможна",
            self.IFptr.LIBFPTR_ERROR_DISCOUNT_DENIED: "Невозможно начислить скидку/надбавку",
            self.IFptr.LIBFPTR_ERROR_INVALID_COMMODITY_CODE: "Неверный код товара",
            self.IFptr.LIBFPTR_ERROR_INVALID_COMMODITY_BARCODE: "Неверный штрихкод товара",
            self.IFptr.LIBFPTR_ERROR_INVALID_COMMAND_FORMAT: "Неверный формат команды",
            self.IFptr.LIBFPTR_ERROR_INVALID_COMMAND_LENGTH: "Неверная длина",
            self.IFptr.LIBFPTR_ERROR_BLOCKED_IN_DATE_INPUT_MODE: "ККТ заблокирована в режиме ввода даты",
            self.IFptr.LIBFPTR_ERROR_NEED_DATE_ACCEPT: "Требуется подтверждение ввода даты",
            self.IFptr.LIBFPTR_ERROR_NO_MORE_DATA: "Нет больше данных",
            self.IFptr.LIBFPTR_ERROR_NO_ACCEPT_OR_CANCEL: "Нет подтверждения или отмены продажи",
            self.IFptr.LIBFPTR_ERROR_BLOCKED_BY_REPORT_INTERRUPTION: "Отчет о закрытии смены прерван",
            self.IFptr.LIBFPTR_ERROR_DISABLE_CASH_CONTROL_DENIED: "Отключение контроля наличности невозможно "
                                                             "(не настроены необходимые типы оплаты)",
            self.IFptr.LIBFPTR_ERROR_MODE_BLOCKED: "Вход в режим заблокирован",
            self.IFptr.LIBFPTR_ERROR_CHECK_DATE_TIME: "Проверьте дату и время",
            self.IFptr.LIBFPTR_ERROR_DATE_TIME_LESS_THAN_FS: "Переданные дата/время меньше "
                                                        "даты/времени последнего фискального документа",
            self.IFptr.LIBFPTR_ERROR_CLOSE_ARCHIVE_DENIED: "Невозможно закрыть архив",
            self.IFptr.LIBFPTR_ERROR_COMMODITY_NOT_FOUND: "Товар не найден",
            self.IFptr.LIBFPTR_ERROR_WEIGHT_BARCODE_WITH_INVALID_QUANTITY: "Весовой штрихкод с количеством <> 1.000",
            self.IFptr.LIBFPTR_ERROR_RECEIPT_BUFFER_OVERFLOW: "Переполнение буфера чека",
            self.IFptr.LIBFPTR_ERROR_QUANTITY_TOO_FEW: "Недостаточное количество товара",
            self.IFptr.LIBFPTR_ERROR_STORNO_TOO_MUCH: "Сторнируемое количество больше проданного",
            self.IFptr.LIBFPTR_ERROR_BLOCKED_COMMODITY_NOT_FOUND: "Товар не найден",
            self.IFptr.LIBFPTR_ERROR_NO_PAPER: "Нет бумаги",
            self.IFptr.LIBFPTR_ERROR_COVER_OPENED: "Открыта крышка",
            self.IFptr.LIBFPTR_ERROR_PRINTER_FAULT: "Нет связи с принтером чеков",
            self.IFptr.LIBFPTR_ERROR_MECHANICAL_FAULT: "Механическая ошибка печатающего устройства",
            self.IFptr.LIBFPTR_ERROR_INVALID_RECEIPT_TYPE: "Неверный тип чека",
            self.IFptr.LIBFPTR_ERROR_INVALID_UNIT_TYPE: "Недопустимое целевое устройство",
            self.IFptr.LIBFPTR_ERROR_NO_MEMORY: "Нет места в массиве картинок/штрихкодов",
            self.IFptr.LIBFPTR_ERROR_PICTURE_NOT_FOUND: "Неверный номер картинки/штрихкода (картинка/штрихкод отсутствует)",
            self.IFptr.LIBFPTR_ERROR_NONCACH_PAYMENTS_TOO_MUCH: "Сумма не наличных платежей превышает сумму чека",
            self.IFptr.LIBFPTR_ERROR_RETURN_DENIED: "Накопление меньше суммы возврата или аннулирования",
            self.IFptr.LIBFPTR_ERROR_PAYMENTS_OVERFLOW: "Переполнение суммы платежей",
            self.IFptr.LIBFPTR_ERROR_BUSY: "Предыдущая операция незавершена",
            self.IFptr.LIBFPTR_ERROR_GSM: "Ошибка GSM-модуля",
            self.IFptr.LIBFPTR_ERROR_INVALID_DISCOUNT: "Неверная величина скидки / надбавки",
            self.IFptr.LIBFPTR_ERROR_OPERATION_AFTER_DISCOUNT_DENIED: "Операция после скидки / надбавки невозможна",
            self.IFptr.LIBFPTR_ERROR_INVALID_DEPARTMENT: "Неверная секция",
            self.IFptr.LIBFPTR_ERROR_INVALID_PAYMENT_TYPE: "Неверный вид оплаты",
            self.IFptr.LIBFPTR_ERROR_MULTIPLICATION_OVERFLOW: "Переполнение при умножении",
            self.IFptr.LIBFPTR_ERROR_DENIED_BY_SETTINGS: "Операция запрещена в таблице настроек",
            self.IFptr.LIBFPTR_ERROR_TOTAL_OVERFLOW: "Переполнение итога чека",
            self.IFptr.LIBFPTR_ERROR_DENIED_IN_ANNULATION_RECEIPT: "Открыт чек аннулирования – операция невозможна",
            self.IFptr.LIBFPTR_ERROR_JOURNAL_OVERFLOW: "Переполнение буфера ЭЖ",
            self.IFptr.LIBFPTR_ERROR_NOT_FULLY_PAID: "Чек оплачен не полностью",
            self.IFptr.LIBFPTR_ERROR_DENIED_IN_RETURN_RECEIPT: "Открыт чек возврата – операция невозможна",
            self.IFptr.LIBFPTR_ERROR_SHIFT_EXPIRED: "Смена превысила 24 часа",
            self.IFptr.LIBFPTR_ERROR_DENIED_IN_SELL_RECEIPT: "Открыт чек продажи – операция невозможна",
            self.IFptr.LIBFPTR_ERROR_FISCAL_MEMORY_OVERFLOW: "Переполнение ФП",
            self.IFptr.LIBFPTR_ERROR_INVALID_PASSWORD: "Неверный пароль",
            self.IFptr.LIBFPTR_ERROR_JOURNAL_BUSY: "Идет обработка ЭЖ",
            self.IFptr.LIBFPTR_ERROR_DENIED_IN_CLOSED_SHIFT: "Смена закрыта - операция невозможна",
            self.IFptr.LIBFPTR_ERROR_INVALID_TABLE_NUMBER: "Неверный номер таблицы",
            self.IFptr.LIBFPTR_ERROR_INVALID_ROW_NUMBER: "Неверный номер ряда",
            self.IFptr.LIBFPTR_ERROR_INVALID_FIELD_NUMBER: "Неверный номер поля",
            self.IFptr.LIBFPTR_ERROR_INVALID_DATE_TIME: "Неверная дата и/или время",
            self.IFptr.LIBFPTR_ERROR_INVALID_STORNO_SUM: "Неверная сумма сторно",
            self.IFptr.LIBFPTR_ERROR_CHANGE_CALCULATION: "Подсчет суммы сдачи невозможен",
            self.IFptr.LIBFPTR_ERROR_NO_CASH: "В ККТ нет денег для выплаты",
            self.IFptr.LIBFPTR_ERROR_DENIED_IN_CLOSED_RECEIPT: "Чек закрыт – операция невозможна",
            self.IFptr.LIBFPTR_ERROR_DENIED_IN_OPENED_RECEIPT: "Чек открыт – операция невозможна",
            self.IFptr.LIBFPTR_ERROR_DENIED_IN_OPENED_SHIFT: "Смена открыта, операция невозможна",
            self.IFptr.LIBFPTR_ERROR_SERIAL_NUMBER_ALREADY_ENTERED: "Серийный номер / MAC-адрес уже задан",
            self.IFptr.LIBFPTR_ERROR_TOO_MUCH_REREGISTRATIONS: "Исчерпан лимит перерегистраций",
            self.IFptr.LIBFPTR_ERROR_INVALID_SHIFT_NUMBER: "Неверный номер смены",
            self.IFptr.LIBFPTR_ERROR_INVALID_SERIAL_NUMBER: "Недопустимый серийный номер ККТ",
            self.IFptr.LIBFPTR_ERROR_INVALID_RNM_VATIN: "Недопустимый РНМ и/или ИНН",
            self.IFptr.LIBFPTR_ERROR_FISCAL_PRINTER_NOT_ACTIVATED: "ККТ не зарегистрирована",
            self.IFptr.LIBFPTR_ERROR_SERIAL_NUMBER_NOT_ENTERED: "Не задан серийный номер",
            self.IFptr.LIBFPTR_ERROR_NO_MORE_REPORTS: "Нет отчетов",
            self.IFptr.LIBFPTR_ERROR_MODE_NOT_ACTIVATED: "Режим не активизирован",
            self.IFptr.LIBFPTR_ERROR_RECORD_NOT_FOUND_IN_JOURNAL: "Данные документа отсутствуют",
            self.IFptr.LIBFPTR_ERROR_INVALID_LICENSE: "Некорректный код защиты / лицензия или номер",
            self.IFptr.LIBFPTR_ERROR_NEED_FULL_RESET: "Требуется выполнение общего гашения",
            self.IFptr.LIBFPTR_ERROR_DENIED_BY_LICENSE: "Команда не разрешена введенными кодами защиты / лицензиями ККТ",
            self.IFptr.LIBFPTR_ERROR_DISCOUNT_CANCELLATION_DENIED: "Невозможна отмена скидки/надбавки",
            self.IFptr.LIBFPTR_ERROR_CLOSE_RECEIPT_DENIED: "Невозможно закрыть чек данным типом оплаты",
            self.IFptr.LIBFPTR_ERROR_INVALID_ROUTE_NUMBER: "Неверный номер маршрута",
            self.IFptr.LIBFPTR_ERROR_INVALID_START_ZONE_NUMBER: "Неверный номер начальной зоны",
            self.IFptr.LIBFPTR_ERROR_INVALID_END_ZONE_NUMBER: "Неверный номер конечной зоны",
            self.IFptr.LIBFPTR_ERROR_INVALID_RATE_TYPE: "Неверный тип тарифа",
            self.IFptr.LIBFPTR_ERROR_INVALID_RATE: "Неверный тариф",
            self.IFptr.LIBFPTR_ERROR_FISCAL_MODULE_EXCHANGE: "Ошибка обмена с фискальным модулем",
            self.IFptr.LIBFPTR_ERROR_NEED_TECHNICAL_SUPPORT: "Необходимо провести профилактические работы",
            self.IFptr.LIBFPTR_ERROR_SHIFT_NUMBERS_DID_NOT_MATCH: "Неверные номера смен в ККТ и ФН",
            self.IFptr.LIBFPTR_ERROR_DEVICE_NOT_FOUND: "Нет устройства, обрабатывающего данную команду",
            self.IFptr.LIBFPTR_ERROR_EXTERNAL_DEVICE_CONNECTION: "Нет связи с внешним устройством",
            self.IFptr.LIBFPTR_ERROR_DISPENSER_INVALID_STATE: "Ошибочное состояние ТРК",
            self.IFptr.LIBFPTR_ERROR_INVALID_POSITIONS_COUNT: "Недопустимое кол-во позиций в чеке",
            self.IFptr.LIBFPTR_ERROR_DISPENSER_INVALID_NUMBER: "Ошибочный номер ТРК",
            self.IFptr.LIBFPTR_ERROR_INVALID_DIVIDER: "Неверный делитель",
            self.IFptr.LIBFPTR_ERROR_FN_ACTIVATION_DENIED: "Активация данного ФН в составе данной ККТ невозможна",
            self.IFptr.LIBFPTR_ERROR_PRINTER_OVERHEAT: "Перегрев головки принтера",
            self.IFptr.LIBFPTR_ERROR_FN_EXCHANGE: "Ошибка обмена с ФН на уровне интерфейса I2C",
            self.IFptr.LIBFPTR_ERROR_FN_INVALID_FORMAT: "Ошибка формата передачи ФН",
            self.IFptr.LIBFPTR_ERROR_FN_INVALID_STATE: "Неверное состояние ФН",
            self.IFptr.LIBFPTR_ERROR_FN_FAULT: "Неисправимая ошибка ФН",
            self.IFptr.LIBFPTR_ERROR_FN_CRYPTO_FAULT: "Ошибка КС ФН",
            self.IFptr.LIBFPTR_ERROR_FN_EXPIRED: "Закончен срок эксплуатации ФН",
            self.IFptr.LIBFPTR_ERROR_FN_OVERFLOW: "Архив ФН переполнен",
            self.IFptr.LIBFPTR_ERROR_FN_INVALID_DATE_TIME: "В ФН переданы неверная дата или время",
            self.IFptr.LIBFPTR_ERROR_FN_NO_MORE_DATA: "В ФН нет запрошенных данных",
            self.IFptr.LIBFPTR_ERROR_FN_TOTAL_OVERFLOW: "Переполнение ФН (итог чека)",
            self.IFptr.LIBFPTR_ERROR_BUFFER_OVERFLOW: "Буфер переполнен",
            self.IFptr.LIBFPTR_ERROR_PRINT_SECOND_COPY_DENIED: "Невозможно напечатать вторую фискальную копию",
            self.IFptr.LIBFPTR_ERROR_NEED_RESET_JOURNAL: "Требуется гашение ЭЖ",
            self.IFptr.LIBFPTR_ERROR_TAX_SUM_TOO_MUCH: "Некорректная сумма налога",
            self.IFptr.LIBFPTR_ERROR_TAX_ON_LAST_OPERATION_DENIED: "Начисление налога на последнюю операцию невозможно",
            self.IFptr.LIBFPTR_ERROR_INVALID_FN_NUMBER: "Неверный номер ФН",
            self.IFptr.LIBFPTR_ERROR_TAX_CANCEL_DENIED: "Сумма сторно налога больше суммы зарегистрированного налога данного типа",
            self.IFptr.LIBFPTR_ERROR_LOW_BATTERY: "Операция невозможна, недостаточно питания",
            self.IFptr.LIBFPTR_ERROR_FN_INVALID_COMMAND: "Некорректное значение параметров команды ФН",
            self.IFptr.LIBFPTR_ERROR_FN_COMMAND_OVERFLOW: "Превышение размеров TLV данных ФН",
            self.IFptr.LIBFPTR_ERROR_FN_NO_TRANSPORT_CONNECTION: "Нет транспортного соединения ФН",
            self.IFptr.LIBFPTR_ERROR_FN_CRYPTO_HAS_EXPIRED: "Исчерпан ресурс КС ФН",
            self.IFptr.LIBFPTR_ERROR_FN_RESOURCE_HAS_EXPIRED: "Ресурс хранения ФД исчерпан",
            self.IFptr.LIBFPTR_ERROR_INVALID_MESSAGE_FROM_OFD: "Сообщение от ОФД не может быть принято ФН",
            self.IFptr.LIBFPTR_ERROR_FN_HAS_NOT_SEND_DOCUMENTS: "В ФН есть неотправленные ФД",
            self.IFptr.LIBFPTR_ERROR_FN_TIMEOUT: "Исчерпан ресурс ожидания передачи сообщения в ФН",
            self.IFptr.LIBFPTR_ERROR_FN_SHIFT_EXPIRED: "Продолжительность смены ФН более 24 часов",
            self.IFptr.LIBFPTR_ERROR_FN_INVALID_TIME_DIFFERENCE: "Неверная разница во времени между двумя операциями ФН",
            self.IFptr.LIBFPTR_ERROR_INVALID_TAXATION_TYPE: "Некорректная СНО",
            self.IFptr.LIBFPTR_ERROR_INVALID_TAX_TYPE: "Недопустимый номер ставки налога",
            self.IFptr.LIBFPTR_ERROR_INVALID_COMMODITY_PAYMENT_TYPE: "Недопустимый тип оплаты товара",
            self.IFptr.LIBFPTR_ERROR_INVALID_COMMODITY_CODE_TYPE: "Недопустимый тип кода товара",
            self.IFptr.LIBFPTR_ERROR_EXCISABLE_COMMODITY_DENIED: "Недопустима регистрация подакцизного товара",
            self.IFptr.LIBFPTR_ERROR_FISCAL_PROPERTY_WRITE: "Ошибка программирования реквизита",
            self.IFptr.LIBFPTR_ERROR_INVALID_COUNTER_TYPE: "Неверный тип счетчика",
            self.IFptr.LIBFPTR_ERROR_CUTTER_FAULT: "Ошибка отрезчика",
            self.IFptr.LIBFPTR_ERROR_REPORT_INTERRUPTED: "Снятие отчета прервалось",
            self.IFptr.LIBFPTR_ERROR_INVALID_LEFT_MARGIN: "Недопустимое значение отступа слева",
            self.IFptr.LIBFPTR_ERROR_INVALID_ALIGNMENT: "Недопустимое значение выравнивания",
            self.IFptr.LIBFPTR_ERROR_INVALID_TAX_MODE: "Недопустимое значение режима работы с налогом",
            self.IFptr.LIBFPTR_ERROR_FILE_NOT_FOUND: "Файл не найден или неверный формат",
            self.IFptr.LIBFPTR_ERROR_PICTURE_TOO_BIG: "Размер картинки слишком большой",
            self.IFptr.LIBFPTR_ERROR_INVALID_BARCODE_PARAMS: "Не удалось сформировать штрихкод",
            self.IFptr.LIBFPTR_ERROR_FISCAL_PROPERTY_DENIED: "Неразрешенные реквизиты",
            self.IFptr.LIBFPTR_ERROR_FN_INTERFACE: "Ошибка интерфейса ФН",
            self.IFptr.LIBFPTR_ERROR_DATA_DUPLICATE: "Дублирование данных",
            self.IFptr.LIBFPTR_ERROR_NO_REQUIRED_FISCAL_PROPERTY: "Не указаны обязательные реквизиты",
            self.IFptr.LIBFPTR_ERROR_FN_READ_DOCUMENT: "Ошибка чтения документа из ФН",
            self.IFptr.LIBFPTR_ERROR_FLOAT_OVERFLOW: "Переполнение чисел с плавающей точкой",
            self.IFptr.LIBFPTR_ERROR_INVALID_SETTING_VALUE: "Неверное значение параметра ККТ",
            self.IFptr.LIBFPTR_ERROR_HARD_FAULT: "Внутренняя ошибка ККТ",
            self.IFptr.LIBFPTR_ERROR_FN_NOT_FOUND: "ФН не найден",
            self.IFptr.LIBFPTR_ERROR_INVALID_AGENT_FISCAL_PROPERTY: "Невозможно записать реквизит агента",
            self.IFptr.LIBFPTR_ERROR_INVALID_FISCAL_PROPERTY_VALUE_1002_1056: "Недопустимое сочетание реквизитов 1002 и 1056",
            self.IFptr.LIBFPTR_ERROR_INVALID_FISCAL_PROPERTY_VALUE_1002_1017: "Недопустимое сочетание реквизитов 1002 и 1017",
            self.IFptr.LIBFPTR_ERROR_SCRIPT: "Ошибка скриптового движка ККТ",
            self.IFptr.LIBFPTR_ERROR_INVALID_USER_MEMORY_INDEX: "Неверный номер пользовательской ячейки памяти",
            self.IFptr.LIBFPTR_ERROR_NO_ACTIVE_OPERATOR: "Кассир не зарегистрирован",
            self.IFptr.LIBFPTR_ERROR_REGISTRATION_REPORT_INTERRUPTED: "Отчет о регистрации ККТ прерван",
            self.IFptr.LIBFPTR_ERROR_CLOSE_FN_REPORT_INTERRUPTED: "Отчет о закрытии ФН прерван",
            self.IFptr.LIBFPTR_ERROR_OPEN_SHIFT_REPORT_INTERRUPTED: "Отчет об открытии смены прерван",
            self.IFptr.LIBFPTR_ERROR_OFD_EXCHANGE_REPORT_INTERRUPTED: "Отчет о состоянии расчетов прерван",
            self.IFptr.LIBFPTR_ERROR_CLOSE_RECEIPT_INTERRUPTED: "Закрытие чека прервано",
            self.IFptr.LIBFPTR_ERROR_FN_QUERY_INTERRUPTED: "Получение документа из ФН прервано",
            self.IFptr.LIBFPTR_ERROR_RTC_FAULT: "Сбой часов",
            self.IFptr.LIBFPTR_ERROR_MEMORY_FAULT: "Сбой памяти",
            self.IFptr.LIBFPTR_ERROR_CHIP_FAULT: "Сбой микросхемы",
            self.IFptr.LIBFPTR_ERROR_TEMPLATES_CORRUPTED: "Ошибка шаблонов документов",
            self.IFptr.LIBFPTR_ERROR_INVALID_MAC_ADDRESS: "Недопустимое значение MAC-адреса",
            self.IFptr.LIBFPTR_ERROR_INVALID_SCRIPT_NUMBER: "Неверный тип (номер) шаблона",
            self.IFptr.LIBFPTR_ERROR_SCRIPTS_FAULT: "Загруженные шаблоны повреждены или отсутствуют",
            self.IFptr.LIBFPTR_ERROR_INVALID_SCRIPTS_VERSION: "Несовместимая версия загруженных шаблонов",
            self.IFptr.LIBFPTR_ERROR_INVALID_CLICHE_FORMAT: "Ошибка в формате клише",
            self.IFptr.LIBFPTR_ERROR_WAIT_FOR_REBOOT: "Требуется перезагрузка ККТ",
            self.IFptr.LIBFPTR_ERROR_NO_LICENSE: "Подходящие лицензии не найдены",
            self.IFptr.LIBFPTR_ERROR_INVALID_FFD_VERSION: "Неверная версия ФФД",
            self.IFptr.LIBFPTR_ERROR_CHANGE_SETTING_DENIED: "Параметр доступен только для чтения",
            self.IFptr.LIBFPTR_ERROR_INVALID_NOMENCLATURE_TYPE: "Неверный тип кода товара",
            self.IFptr.LIBFPTR_ERROR_INVALID_GTIN: "Неверное значение GTIN",
            self.IFptr.LIBFPTR_ERROR_NEGATIVE_MATH_RESULT: "Отрицательный результат математической операции",
            self.IFptr.LIBFPTR_ERROR_FISCAL_PROPERTIES_COMBINATION: "Недопустимое сочетание реквизитов",
            self.IFptr.LIBFPTR_ERROR_OPERATOR_LOGIN: "Не удалось зарегистрировать кассира",
            self.IFptr.LIBFPTR_ERROR_INVALID_INTERNET_CHANNEL: "Данный канал Интернет отсутствует в ККТ",
            self.IFptr.LIBFPTR_ERROR_DATETIME_NOT_SYNCRONIZED: "Дата и время не синхронизированы",
            self.IFptr.LIBFPTR_ERROR_JOURNAL: "Ошибка электронного журнала",
            self.IFptr.LIBFPTR_ERROR_DENIED_IN_OPENED_DOC: "Документ открыт - операция невозможна",
            self.IFptr.LIBFPTR_ERROR_DENIED_IN_CLOSED_DOC: "Документ закрыт - операция невозможна",
            self.IFptr.LIBFPTR_ERROR_LICENSE_MEMORY_OVERFLOW: "Нет места для сохранения лицензий",
            self.IFptr.LIBFPTR_ERROR_NEED_CANCEL_DOCUMENT: "Произошла критичная ошибка, документ необходимо отменить",
            self.IFptr.LIBFPTR_ERROR_REGISTERS_NOT_INITIALIZED: "Регистры ККТ еще не инициализированы",
            self.IFptr.LIBFPTR_ERROR_TOTAL_REQUIRED: "Требуется регистрация итога",
            self.IFptr.LIBFPTR_ERROR_SETTINGS_FAULT: "Сбой таблицы настроек",
            self.IFptr.LIBFPTR_ERROR_COUNTERS_FAULT: "Сбой счетчиков и регистров ККТ",
            self.IFptr.LIBFPTR_ERROR_USER_MEMORY_FAULT: "Сбой пользовательской памяти",
            self.IFptr.LIBFPTR_ERROR_SERVICE_COUNTERS_FAULT: "Сбой сервисных регистров",
            self.IFptr.LIBFPTR_ERROR_ATTRIBUTES_FAULT: "Сбой реквизитов ККТ",
            self.IFptr.LIBFPTR_ERROR_ALREADY_IN_UPDATE_MODE: "ККТ уже в режиме обновления конфигурации",
            self.IFptr.LIBFPTR_ERROR_INVALID_FIRMWARE: "Конфигурация не прошла проверку",
            self.IFptr.LIBFPTR_ERROR_INVALID_CHANNEL: "Аппаратный канал отсутствует, выключен или ещё не проинициализирован",
            self.IFptr.LIBFPTR_ERROR_INTERFACE_DOWN: "Сетевой интерфейс не подключен, или на нём не получен IP-адрес",
            self.IFptr.LIBFPTR_ERROR_INVALID_FISCAL_PROPERTY_VALUE_1212_1030: "Недопустимое сочетание реквизитов 1212 и 1030",
            self.IFptr.LIBFPTR_ERROR_INVALID_FISCAL_PROPERTY_VALUE_1214: "Некорректный признак способа расчета",
            self.IFptr.LIBFPTR_ERROR_INVALID_FISCAL_PROPERTY_VALUE_1212: "Некорректный признак предмета расчета",
            self.IFptr.LIBFPTR_ERROR_SYNC_TIME: "Ошибка синхронизации времени",
            self.IFptr.LIBFPTR_ERROR_VAT18_VAT20_IN_RECEIPT: "В одном чеке одновременно не может быть позиций с НДС 18% (18/118) и "
                                                        "НДС 20% (20/120)",
            self.IFptr.LIBFPTR_ERROR_PICTURE_NOT_CLOSED: "Картинка не закрыта",
            self.IFptr.LIBFPTR_ERROR_INTERFACE_BUSY: "Сетевой интерфейс занят",
            self.IFptr.LIBFPTR_ERROR_INVALID_PICTURE_NUMBER: "Неверный номер картинки",
            self.IFptr.LIBFPTR_ERROR_INVALID_CONTAINER: "Ошибка проверки контейнера",
            self.IFptr.LIBFPTR_ERROR_ARCHIVE_CLOSED: "Архив ФН закрыт",
            self.IFptr.LIBFPTR_ERROR_NEED_REGISTRATION: "Нужно выполнить регистрацию / перерегистрацию",
            self.IFptr.LIBFPTR_ERROR_DENIED_DURING_UPDATE: "Операция невозможна, идет обновление ПО ККТ",
            self.IFptr.LIBFPTR_ERROR_INVALID_TOTAL: "Неверный итог чека",
            self.IFptr.LIBFPTR_ERROR_MARKING_CODE_CONFLICT: "Запрещена одновременная передача КМ и реквизита 1162",
            self.IFptr.LIBFPTR_ERROR_INVALID_RECORDS_ID: "Набор записей по заданному идентификатору не найден",
            self.IFptr.LIBFPTR_ERROR_INVALID_SIGNATURE: "Ошибка цифровой подписи",
            self.IFptr.LIBFPTR_ERROR_INVALID_EXCISE_SUM: "Некорректная сумма акциза",
            self.IFptr.LIBFPTR_ERROR_NO_DOCUMENTS_FOUND_IN_JOURNAL: "Заданный диапазон документов не найден в БД документов",
            self.IFptr.LIBFPTR_ERROR_INVALID_SCRIPT_TYPE: "Неподдерживаемый тип скрипта",
            self.IFptr.LIBFPTR_ERROR_INVALID_SCRIPT_NAME: "Некорректный идентификатор скрипта",
            self.IFptr.LIBFPTR_ERROR_INVALID_POSITIONS_COUNT_WITH_1162: "Кол-во позиций с реквизитом 1162/1163 в автономном режиме "
                                                                   "превысило разрешенный лимит",
            self.IFptr.LIBFPTR_ERROR_INVALID_UC_COUNTER: "Универсальный счетчик с заданными параметрами недоступен",
            self.IFptr.LIBFPTR_ERROR_INVALID_UC_TAG: "Неподдерживаемый тег для универсальных счетчиков",
            self.IFptr.LIBFPTR_ERROR_INVALID_UC_IDX: "Некорректный индекс для универсальных счетчиков",
            self.IFptr.LIBFPTR_ERROR_INVALID_UC_SIZE: "Неверный размер универсального счетчика",
            self.IFptr.LIBFPTR_ERROR_INVALID_UC_CONFIG: "Неверная конфигурация универсальных счетчиков",
            self.IFptr.LIBFPTR_ERROR_CONNECTION_LOST: "Соединение с ККТ потеряно",
            self.IFptr.LIBFPTR_ERROR_UNIVERSAL_COUNTERS_FAULT: "Ошибка универсальных счетчиков",
            self.IFptr.LIBFPTR_ERROR_INVALID_TAX_SUM: "Некорректная сумма налога",
            self.IFptr.LIBFPTR_ERROR_INVALID_MARKING_CODE_TYPE: "Некорректное значение типа кода маркировки",
            self.IFptr.LIBFPTR_ERROR_LICENSE_HARD_FAULT: "Аппаратная ошибка при сохранении лицензии",
            self.IFptr.LIBFPTR_ERROR_LICENSE_INVALID_SIGN: "Подпись лицензии некорректна",
            self.IFptr.LIBFPTR_ERROR_LICENSE_INVALID_SERIAL: "Лицензия не подходит для данной ККТ",
            self.IFptr.LIBFPTR_ERROR_LICENSE_INVALID_TIME: "Срок действия лицензии истёк",
            self.IFptr.LIBFPTR_ERROR_DOCUMENT_CANCELED: "Документ был отменен",
            self.IFptr.LIBFPTR_ERROR_INVALID_SCRIPT_PARAMS: "Некорректные параметры скрипта",
            self.IFptr.LIBFPTR_ERROR_CLICHE_TOO_LONG: "Длина клише превышает максимальное значение",
            self.IFptr.LIBFPTR_ERROR_COMMODITIES_TABLE_FAULT: "Ошибка таблицы товаров",
            self.IFptr.LIBFPTR_ERROR_COMMODITIES_TABLE: "Общая ошибка таблицы товаров",
            self.IFptr.LIBFPTR_ERROR_COMMODITIES_TABLE_INVALID_TAG: "Некорректный тег для таблицы товаров",
            self.IFptr.LIBFPTR_ERROR_COMMODITIES_TABLE_INVALID_TAG_SIZE: "Некорректный размер тега для таблицы товаров",
            self.IFptr.LIBFPTR_ERROR_COMMODITIES_TABLE_NO_TAG_DATA: "Нет данных по тегу в таблице товаров",
            self.IFptr.LIBFPTR_ERROR_COMMODITIES_TABLE_NO_FREE_MEMORY: "Нет места в динамической области памяти таблицы товаров",
            self.IFptr.LIBFPTR_ERROR_INVALID_CACHE: "Ошибка чтения/записи данных кеша",
            self.IFptr.LIBFPTR_ERROR_SCHEDULER_NOT_READY: "Функции планировщика заданий не доступны",
            self.IFptr.LIBFPTR_ERROR_SCHEDULER_INVALID_TASK: "Неизвестный тип задания планировщика",
            self.IFptr.LIBFPTR_ERROR_MINIPOS_NO_POSITION_PAYMENT: "Отсутствует позиция оплаты",
            self.IFptr.LIBFPTR_ERROR_MINIPOS_COMMAND_TIME_OUT: "Таймаут выполнения команды истек",
            self.IFptr.LIBFPTR_ERROR_MINIPOS_MODE_FR_DISABLED: "Режим ФР выключен",
            self.IFptr.LIBFPTR_ERROR_ENTRY_NOT_FOUND_IN_OTP: "Не найдена запись в OTP",
            self.IFptr.LIBFPTR_ERROR_EXCISABLE_COMMODITY_WITHOUT_EXCISE: "Подакцизный товар без акциза зарегистрирован в чеке",
            self.IFptr.LIBFPTR_ERROR_BARCODE_TYPE_NOT_SUPPORTED: "Данный тип штрихкода не поддерживается",
            self.IFptr.LIBFPTR_ERROR_OVERLAY_DATA_OVERFLOW: "Размер данных штрихкода и текста превышает допустимый",
            self.IFptr.LIBFPTR_ERROR_INVALID_MODULE_ADDRESS: "Ошибка чтения адреса модуля и сегмента",
            self.IFptr.LIBFPTR_ERROR_ECR_MODEL_NOT_SUPPORTED: "Данная модель ККТ не поддерживается",
            self.IFptr.LIBFPTR_ERROR_MARKING_CODE_VALIDATION_IN_PROGRESS: "Процедура проверки КМ уже запущена",
            self.IFptr.LIBFPTR_ERROR_NO_CONNECTION_WITH_SERVER: "Ошибка соединения с сервером",
            self.IFptr.LIBFPTR_ERROR_MARKING_CODE_VALIDATION_CANCELED: "Процедура проверки КМ прервана",
            self.IFptr.LIBFPTR_ERROR_INVALID_MARKING_CODE_STATUS: "Некорректное значение статуса КМ",
            self.IFptr.LIBFPTR_ERROR_INVALID_GS1: "Неверный код GS1",
            self.IFptr.LIBFPTR_ERROR_MARKING_WORK_DENIED: "Запрещена работа с маркированным товарами",
            self.IFptr.LIBFPTR_ERROR_MARKING_WORK_TEMPORARY_BLOCKED: "Работа с маркированными товарами временно заблокирована",
            self.IFptr.LIBFPTR_ERROR_MARKS_OVERFLOW: "Переполнена таблица хранения КМ",
            self.IFptr.LIBFPTR_ERROR_INVALID_MARKING_CODE: "Некорректный код маркировки",
            self.IFptr.LIBFPTR_ERROR_INVALID_STATE: "Неверное состояние",
            self.IFptr.LIBFPTR_ERROR_OFD_EXCHANGE: "Ошибка обмена с сервером ОФД или ИСМ",
            self.IFptr.LIBFPTR_ERROR_INVALID_MEASUREMENT_UNIT: "Некорректное значение единиц измерения",
            self.IFptr.LIBFPTR_ERROR_OPERATION_DENIED_IN_CURRENT_FFD: "Операция не разрешена в данной версии ФФД",
            self.IFptr.LIBFPTR_ERROR_MARKING_OPERATION_DENIED: "Операция не разрешена, "
                                                          "при регистрации не был установлен признак ТМТ",
            self.IFptr.LIBFPTR_ERROR_NO_DATA_TO_SEND: "Нет данных для отправки",
            self.IFptr.LIBFPTR_ERROR_NO_MARKED_POSITION: "Нет маркированных позиций в чеке",
            self.IFptr.LIBFPTR_ERROR_HAS_NOT_SEND_NOTICES: "Имеются неотправленные уведомления",
            self.IFptr.LIBFPTR_ERROR_UPDATE_KEYS_REQUIRED: "Требуется повторное проведение процедуры обновления ключей",
            self.IFptr.LIBFPTR_ERROR_UPDATE_KEYS_SERVICE: "Ошибка сервиса обновления ключей проверки КМ",
            self.IFptr.LIBFPTR_ERROR_MARK_NOT_CHECKED: "КМ не проверен в ФН",
            self.IFptr.LIBFPTR_ERROR_MARK_CHECK_TIMEOUT_EXPIRED: "Истёк таймаут проверки КМ",
            self.IFptr.LIBFPTR_ERROR_NO_MARKING_CODE_IN_TABLE: "Данный КМ отсутствует в таблице",
            self.IFptr.LIBFPTR_ERROR_CHEKING_MARK_IN_PROGRESS: "Выполняется проверка КМ",
            self.IFptr.LIBFPTR_ERROR_INVALID_SERVER_ADDRESS: "Адрес сервера ИСМ не задан",
            self.IFptr.LIBFPTR_ERROR_UPDATE_KEYS_TIMEOUT: "Истёк таймаут обновления ключей проверки",
            self.IFptr.LIBFPTR_ERROR_PROPERTY_FOR_MARKING_POSITION_ONLY: "Данный реквизит разрешён только для маркированной позиции",
            self.IFptr.LIBFPTR_ERROR_RECEIPT_PARSE_ERROR: "Ошибка парсинга запроса",
            self.IFptr.LIBFPTR_ERROR_INTERRUPTED_BY_PREVIOUS_ERRORS: "Выполнение прервано из-за предыдущих ошибок",
            self.IFptr.LIBFPTR_ERROR_DRIVER_SCRIPT_ERROR: "Ошибка скрипта драйвера",
            self.IFptr.LIBFPTR_ERROR_VALIDATE_FUNC_NOT_FOUND: "Функция проверки задания не найдена",
            self.IFptr.LIBFPTR_ERROR_RCP_SERVER_BUSY: "Устройство на сервере удалённого подключения занято другим клиентом",
            self.IFptr.LIBFPTR_ERROR_RCP_SERVER_VERSION: "Некорректная версия протокола обмена с сервером удалённого подключения",
            self.IFptr.LIBFPTR_ERROR_RCP_SERVER_EXCHANGE: "Ошибка обмена с сервером удалённого подключения",
        }

    def get_dto_error_code_description(self, error_code):
        """Запрос описания ошибки ДТО"""
        if error_code in self.DTO_ERROR_DESCRIPTIONS:
            return self.DTO_ERROR_DESCRIPTIONS[error_code]
        else:
            return "НЕИЗВЕСТНАЯ ОШИБКА ДРАЙВЕРА! НЕОБХОДИМО АКТУАЛИЗИРОВАТЬ СЛОВАРЬ const/dto_error_descriptions.py"
