from __future__ import annotations

SSL_TEST_PRIVATE_CA_CRT = b"""-----BEGIN CERTIFICATE-----
MIIDKTCCAhGgAwIBAgIUeLxDdxR+RmiMMvvCxRfsQJAL7vUwDQYJKoZIhvcNAQEL
BQAwRDENMAsGA1UECgwEQ2hpYTEQMA4GA1UEAwwHQ2hpYSBDQTEhMB8GA1UECwwY
T3JnYW5pYyBGYXJtaW5nIERpdmlzaW9uMB4XDTIyMDMyMzE3MjkyM1oXDTMyMDMy
MDE3MjkyM1owRDENMAsGA1UECgwEQ2hpYTEQMA4GA1UEAwwHQ2hpYSBDQTEhMB8G
A1UECwwYT3JnYW5pYyBGYXJtaW5nIERpdmlzaW9uMIIBIjANBgkqhkiG9w0BAQEF
AAOCAQ8AMIIBCgKCAQEA0Bvshi5y4VEw+k32NOOMFZJaraLoJx5N1WOJDYGqSDPe
7ICPjz4IWDQN+yPrFv+ms+es3Ys8WOKEOMWR8U9mAxG21t+n8LH7NAMlCRNscBZ/
Si04bqfrBc3adznorQLtShOpYxEfRdu7kpHo6+D+4Av96qMpMLsPKiZWjjy9O3ai
oNzymj0mwlZ/1gaxpvfmvuqNNR9Kog8o7crLbp/x0ZPiU+Q0y6Kj4saZwu5Nq2cO
JqLn6ex8w576/UOAN4u28S3m2pVgoYkqGqJSXORUqZj38Ro0zAYywIHjiIfhLp5a
dhqDyf/IUCawltEzdXoOp3irYaV0SmAB8+e2ILZJawIDAQABoxMwETAPBgNVHRMB
Af8EBTADAQH/MA0GCSqGSIb3DQEBCwUAA4IBAQAchOBNfaAIoP97Lmyk/S4Hu94I
bGqj/BT6/q+UnWYcIt3UO6/d9a6WO7xtSPKiuObip8M6UQYVKQC8YecnAvXFwI6Q
r4z2TdGx2MjsxfQSNX0BYASlv5EWd3LYJs+Ayi2lxh+3XLSH+BK/7R1nL1MaN161
vAN2rGOo5J1niWyixyGK/jrKTtsRTxDcpFeIYdk1r/qGiY5uxwg6ny0JYHXYhSNm
AyADKnZoXw/kb6+mEHJHZaTR1JpNHkQ7azhNYyVMUseCi+5vYuzA2OoxSgBegSj+
1fRUZI+j46hkr5Qspw9P++dDLzEGgarbxruRf6VsosU3sSYxq6LC+a9UHXNG
-----END CERTIFICATE-----
"""

SSL_TEST_PRIVATE_CA_KEY = b"""-----BEGIN PRIVATE KEY-----
MIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQDQG+yGLnLhUTD6
TfY044wVklqtougnHk3VY4kNgapIM97sgI+PPghYNA37I+sW/6az56zdizxY4oQ4
xZHxT2YDEbbW36fwsfs0AyUJE2xwFn9KLThup+sFzdp3OeitAu1KE6ljER9F27uS
kejr4P7gC/3qoykwuw8qJlaOPL07dqKg3PKaPSbCVn/WBrGm9+a+6o01H0qiDyjt
ystun/HRk+JT5DTLoqPixpnC7k2rZw4moufp7HzDnvr9Q4A3i7bxLebalWChiSoa
olJc5FSpmPfxGjTMBjLAgeOIh+Eunlp2GoPJ/8hQJrCW0TN1eg6neKthpXRKYAHz
57YgtklrAgMBAAECggEBAINUe+kZuumyISR0uqEZ0Dd0ysC1A6hcGWZGkCDz6Q/z
nATIBNCypvVytDf+rMcwwnTaCV8uFQFKwYJKPBV6s7fQIABt2D+vMgXazi5yEYaS
y/V1oB1E3q4lAG8pHkrAhBqxWb3o+kFNr4uJhOIGdRHSv4SpPr8/7Qv+cbUFY633
xshNrE7kKfaZcY/VlnyID1EHHWnEwBQMbh3ljj5e3xgw/w58R5UgU792NFOHQ5JO
6BIbCOclF4X5yVfX350n9oFc5Qest00JXxz0aOocMTLqtchv03xRjqdVW/NsL/Kl
jqTZW0OGdZRhotym4d6Sas40lEpdzSUpHrDwUMAKm+ECgYEA6LvZz48fQWNPanJV
Atz8e3lQO3SO+wY8Rr4S9hgL5kURWJeP3z4obG0itzolpvdKL94IxL6o8A7cXzAL
Un6oerfiDoHa/ZIfd3ko5ZdnAwWQRwzemw7EFrBW0fmy6FMrzour+qLYQTnJPQ02
Uz40zzPKFi2b/DySOeXL/knncNMCgYEA5Onf6a9LJqHekFMMcuUtTD3Zto4BBExH
7sMc6a2zJXDNtlfMRLUhUy3TZkfkU03aeTvxdSV1M1SS+cc+sZWiAjd3wOVZy1+H
uuLRP1KDJ250g4/0ROZ2vfv256kAdBq8Typ/LGLmjVimnr2s9ZlaaJxNuI3KEChO
oWFq4DtcJgkCgYBrIOUu5IuXlrYcooo9KinSUFI9O/cA16rxSVcDDqiTk2FbrVBd
i4gh+M6NFuf0BkqQ5ByXK8gp0D1iV4QusfytmG0nDmEWbaesYAoSPPH+8xWpjuP8
7fwXEY61UsImrPoyNhqw4Tq4M3hNcQJ7qNu4MPep4860edE5c2zGHZC6XwKBgCrz
u0D01EwOaV15R8ezOtmobVZ0tLoiugiR8bXjEs8+qErDlJ97wSIDYjw51xzOaeT/
m2HYwnH8N4vIl/noUrrJv52hK0UeyrAFaS/Rgqx+bDxXYYUgHT2urnhvXJdsgNL1
7WDdudbhwHneqzp2KOGiGm87o6N+fKqJRe2HFdZJAoGAD//Jp7Hw8/9BA3NNhWAU
YubL5O4jututW1VGzW1TOmK3MvroJ3ip0vmop4zFuiG/pp5cNhDB56ablAW+s/re
zIjKmF79k/AXmrtXlm0XBRXBdhb3qHBF1WSUD63DttrpGdd0Mj6LY+gd+Z0/z1Yl
Z65yJ0/xVyaFjRGIBikb+90=
-----END PRIVATE KEY-----
"""

SSL_TEST_FULLNODE_PRIVATE_CRT = b"""-----BEGIN CERTIFICATE-----
MIIDLDCCAhSgAwIBAgIUFhEfo/xtdcjm/XhkbuouJaZUBEAwDQYJKoZIhvcNAQEL
BQAwRDENMAsGA1UECgwEQ2hpYTEQMA4GA1UEAwwHQ2hpYSBDQTEhMB8GA1UECwwY
T3JnYW5pYyBGYXJtaW5nIERpdmlzaW9uMCAXDTIyMDMyMjEwMjkyM1oYDzIxMDAw
ODAyMDAwMDAwWjBBMQ0wCwYDVQQDDARDaGlhMQ0wCwYDVQQKDARDaGlhMSEwHwYD
VQQLDBhPcmdhbmljIEZhcm1pbmcgRGl2aXNpb24wggEiMA0GCSqGSIb3DQEBAQUA
A4IBDwAwggEKAoIBAQDQEygAVJgviM/8f0wuEsmCJoiNJ3gvrX8EckcllVXeyg23
iXiIadXqtCdPOXQlJHw2fZ838o/WuJkI9TsrtUkG3e+VEJKku3GtDez7gDufVZd9
e7jmqbO1mMwvpbFwEUzR9IumsxiOqDVAzSJIJGnWKhiOLYkXdKI4D+dyniEMKVFk
Y1TcI1huQngH+dBYujHlJZ4USOB+xVv5LfgrKYiZyHdKmRchIdhcjft5b7gBp38z
helydqA+mEU8zFqL5iwpNOALmije5IQKDrVHThIVmlg+G96DakoVBcpEqttfHb0N
E/oX3v0yAeV6IJ94VwCsSzndHt/KEG5PjsqQ60KHAgMBAAGjFzAVMBMGA1UdEQQM
MAqCCGNoaWEubmV0MA0GCSqGSIb3DQEBCwUAA4IBAQB63tKOcuBjL8tjnIlDozpm
t+LRcNiubKRc/rhTBYIoO6cTMN61ITe2FvogzNAPR/wmsaDO/sqG1oEHrrnJ7hXi
zNVj3GC7XYlqXvoRsCTdqoZE4ATPVZkJqhDx+/5IruWo1Q7F3nPzjLcS3mpwu2xc
Tl2HBEwCX2gTuG6lB5DUztrgGLNh27pqRLoGW4fzmVtHD/z54SFsQvPw0flYMRtc
qA/4eoWLvQNGoqsfA2F+eFTlXiPr/jp3jFVJvqixlwEN1DJkTi7hfMTEty7xrlZq
dZUmYxygqt4sy0AMbwCbemYJmvONlW8lN5GYo5NjB0BaMYsGMrehY2XHZg2npy+U
-----END CERTIFICATE-----
"""

SSL_TEST_FULLNODE_PRIVATE_KEY = b"""-----BEGIN PRIVATE KEY-----
MIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQDQEygAVJgviM/8
f0wuEsmCJoiNJ3gvrX8EckcllVXeyg23iXiIadXqtCdPOXQlJHw2fZ838o/WuJkI
9TsrtUkG3e+VEJKku3GtDez7gDufVZd9e7jmqbO1mMwvpbFwEUzR9IumsxiOqDVA
zSJIJGnWKhiOLYkXdKI4D+dyniEMKVFkY1TcI1huQngH+dBYujHlJZ4USOB+xVv5
LfgrKYiZyHdKmRchIdhcjft5b7gBp38zhelydqA+mEU8zFqL5iwpNOALmije5IQK
DrVHThIVmlg+G96DakoVBcpEqttfHb0NE/oX3v0yAeV6IJ94VwCsSzndHt/KEG5P
jsqQ60KHAgMBAAECggEATp0+Osm7ahI9yr9pz+qHOeZHJ1WnQhRB7jMjEF8Yv4EF
p7eH07pw+SkxxOwHJtVfHNNfqaq6j7zVDR5iScRHoBGQKHjHfvfXHjQpumgbnrqe
7ukk1fl+DXl6g/INVTMkHBtR/BykhZml7SLT9f/UAPeMqYMozbTiaV4Q6yw1fjsb
vPkaUtjveFE33f4sAWaJXMhGw0CaSAQ5UpU0juSPgRrH7WLot9TkR5KLldupoSil
bLG5SD9a00UnNpO1VKdkypS8xLtHRveFaosp4kJ74fklef8ZRSIdRwpoVbjJNcsQ
Yw5JevF68RS3/4/AQoHJUhrdjeWNWHh4cyB5LKQYCQKBgQDpaIsPFI+ZJjNBEeQP
3rxvO2TTH9dIRsKgl1LyawaPACknt5lssHOFb7iT8eEg97PRq1TZMGbpdHdhq5bG
276n3cqO+qJ4weC51n3n7iEreORROmc3gvEw19mwSxSmJnfiS/yyMnGvnqBY8F0x
R3ICitGp5AZi5rcN2DqcsVdtlQKBgQDkNuQ97C8tktfuVs3tjuv65Isg6rYK5Asy
Ksu4MqihpAUt2OFvFmqlDVSUshvtXro9VNZMkJav0zdu1YzBRK9aq7IImLSmnAJE
Hck6I7rp5SpTCNPqC/yNfL0cMktFzyMeNsVe+v6DYjE+vu2lUKUEir40mc/S8CE8
3QMZUYzQqwKBgASj/nfLSduapdQ6XdVu8UIo5SVJccdPGNmGiLCnLhczwp22icde
br2NbhcK7RXxttKJXIOA8drcZO89MR89CTpfL4LOOuK5wBURzakJ1AEAQ1HWHm09
HjyBXiOiKoPvKd0G87w7QoViWv/Jr6CmMf8Y8Xg2P2ZB/gu5a9jnsbxNAoGBAIB9
k2Z1614qdl8gCpO9S4oYUWk4HUTmfpNBWzAbfax8r9nPaaXlJihF6CBMY8Ly+cL8
WCgFpIHcVzKVE8nhRSW00+lZKSVBY1k8uAZ/BYcZWwojR0VYeFqlJ8iPXKgyZuBl
EB1ZDiGlEHr2ftD8Jdz3zP3KuCNYxi4BdfQ0YSc/AoGAOkyeYVV/1iq0iuNvZ19Q
VeL/FEz/QLn98o7Et0wCp6VCsdQLOR+OermxF/5NTSBXreDS+YOSsc8N7Ds0Cvyb
9x6E+AQu+0G+i4RsY1A6680O6dXAtTq9oiE6q2aWA2731J9lQlSDykg4PagAkpJK
D6LDXVuc+4onE/JZ30e0xmU=
-----END PRIVATE KEY-----
"""

SSL_TEST_FULLNODE_PUBLIC_CRT = b"""-----BEGIN CERTIFICATE-----
MIIDLDCCAhSgAwIBAgIUO/5znSza9Dx7FlysyCyStw2FDwQwDQYJKoZIhvcNAQEL
BQAwRDENMAsGA1UECgwEQ2hpYTEQMA4GA1UEAwwHQ2hpYSBDQTEhMB8GA1UECwwY
T3JnYW5pYyBGYXJtaW5nIERpdmlzaW9uMCAXDTIyMDMyMjEwMjkyM1oYDzIxMDAw
ODAyMDAwMDAwWjBBMQ0wCwYDVQQDDARDaGlhMQ0wCwYDVQQKDARDaGlhMSEwHwYD
VQQLDBhPcmdhbmljIEZhcm1pbmcgRGl2aXNpb24wggEiMA0GCSqGSIb3DQEBAQUA
A4IBDwAwggEKAoIBAQDFUvDaklLh3JqASKA1I6H/cULbcPCiXDy5CTtXJUzSRc8Q
ckjI4pepWm2/qPKkmiW+6V3irdc1sGF5ICB0mh41UAu5338+0nuQ2n6LWChL4OG7
JNU4uBIbf5PXmlZhj8BHAfpAi0rvXIdlEUyVhDnjfnOnYK/2Eivh5gOvnmoHA9EA
BI1KCvhIdv9H4Vdrl+iFTL42hPe1X4TBRcg7HuFVZ14kzxWQ4x9Ep/tzzq8eaLSM
rlrRmBlrXMgN66ib65deEbuGPxVdHwY4OkR7hxal41ON6sduZ7d5ypHWGUwrT0eY
Pga4/b10/trBHGlk7cFmLmqTDVEtPMgrHFrtM4YJAgMBAAGjFzAVMBMGA1UdEQQM
MAqCCGNoaWEubmV0MA0GCSqGSIb3DQEBCwUAA4IBAQAk17NlkhSre6JbKzlUdYB4
GOddsueSKsnathkvevXLM5Q2zhY1GKdeT6chlflcgLs1q810LwyAvVD/A5k3jOZM
YxR9mQMAARuk1qZsxeYfu1ARZWEU77HJj2foWw0r5+1FmT5vCPZoqnINElXHMbuy
DtgYUjAS/31pqHtFKrqFAV3IruQyosYoVOFmKb419s+7ST6u+FQZpiouKKnSpqfc
0K9+O4pcCvPgcrj8rTK5cxLeIYd7LwL9grxE9DrIJhsaoKUkwM4+tiimr+7OSYov
byhFnXiLH9MEZgJXtV9jwQJideTpcI7rdVFVc4+tEP9A5Prru6asNC2UsXbg4kZy
-----END CERTIFICATE-----
"""

SSL_TEST_FULLNODE_PUBLIC_KEY = b"""-----BEGIN PRIVATE KEY-----
MIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQDFUvDaklLh3JqA
SKA1I6H/cULbcPCiXDy5CTtXJUzSRc8QckjI4pepWm2/qPKkmiW+6V3irdc1sGF5
ICB0mh41UAu5338+0nuQ2n6LWChL4OG7JNU4uBIbf5PXmlZhj8BHAfpAi0rvXIdl
EUyVhDnjfnOnYK/2Eivh5gOvnmoHA9EABI1KCvhIdv9H4Vdrl+iFTL42hPe1X4TB
Rcg7HuFVZ14kzxWQ4x9Ep/tzzq8eaLSMrlrRmBlrXMgN66ib65deEbuGPxVdHwY4
OkR7hxal41ON6sduZ7d5ypHWGUwrT0eYPga4/b10/trBHGlk7cFmLmqTDVEtPMgr
HFrtM4YJAgMBAAECggEAMn+bbBRuaacPUy1C8tZ/quPNfGNW8fYxBBm8ufytwFJl
P4w/3ElBDvI5jAcssbtRVZ5bjJt4rCDLkTgLlkuq13H4zkTIR8eOH/AK2pZhGaof
msk+WBmjaK4po8+3s5gaWRHEfagoMUG41MCsnMcOGY5PAtLXtV3JJTK8VsFv2QNJ
DBofTjJGGwagy7L6qYFzvl44KXoW04Ue0njsSN2elGnovqUpT+kx+VXHeTB6kCMa
6X7FleGRd1/It8awBWxlDB4+Krxoxn9L8aPKqsIxD4Sp5NvntJJdYr1dis4ixBlI
mO6qI45iCoqh+/seomWYLVwuGCgwbmjSM/ZtMq87EQKBgQD/TK2FjoDkrFPTqB1i
W2wyUhy5qZXDkSOgOl/yjIHAPpxtSbwxva1U609tsfHHg2oZKf+7FPxSCY4ZngLT
gLCaBaYyY4MJP9z0sEc1tY5OLLg4sgl1xS/TXHW1hm91t7UVgrGBr6FH5ScolPW3
SblSMqOFechgZH7B5embaFyjawKBgQDF3YqCBOb/E20Mc3GPKAqKTgV8SEZyBp+e
kKubp0IbIsB7n5P1g63qjAZNLYCImIbk8lEaYnHIlrjiN7+vX4stU3xKawtdNfvh
SLOOhU1oKjL1l7ddvhE2w9hd7TAiAKL6EE88SYVm9LGXFekc/SmmScLEjTzAFZcf
qChKRysNWwKBgDH/r2Aft4iRY11paE/R/c+hGzUVTFpfu21u4UmcUPD4kiQpM60+
K4sdBpJCLkrXptjEy+u0wXHDo0vLEVygsHWJs7HcoVYXZsuZFmkjZHpU8cNQwt+I
vcQUMI1bhcq1LsbGsMLoRZrR+yhMfA7oZl39wt6qKh8Or3CD+YtRFgt/AoGBAJzL
AsAnXFlTLn3IWXuksj2IuCYVK+WdxA0l/Sb6MpNIRZlxChFqyH1temzcGtejbnms
X4J18k6OyXFR1g8FukcvufVKwBWb+r46GzdcAMwDbKBbGk4pmIB6T1GW7CZ1tLBO
DkvqwtCkJLph/XkgUEnad4HDnhlkwn2uhkbeAIqzAoGAZGg9br+0lG5/859Uz2zO
Gu6E1rW1Qmt7ZGsqdfOng/bud8scpS4cWhwDQ1dIO7xvVYMUeLZ38YhCb+V2JKEa
rHwctjh+AEpMwtnqcldni6G/3zGM5jLiN0hfcfBiXW6RQsV+ExWVLioXp1BLYUXZ
nFuRXApgKMWu3IQk6Nhxx7k=
-----END PRIVATE KEY-----
"""

SSL_TEST_WALLET_PRIVATE_CRT = b"""-----BEGIN CERTIFICATE-----
MIIDLDCCAhSgAwIBAgIUBN4qin5jD3jO3rKq1yvO8YTCOM8wDQYJKoZIhvcNAQEL
BQAwRDENMAsGA1UECgwEQ2hpYTEQMA4GA1UEAwwHQ2hpYSBDQTEhMB8GA1UECwwY
T3JnYW5pYyBGYXJtaW5nIERpdmlzaW9uMCAXDTIyMDMyMjEwMjkyM1oYDzIxMDAw
ODAyMDAwMDAwWjBBMQ0wCwYDVQQDDARDaGlhMQ0wCwYDVQQKDARDaGlhMSEwHwYD
VQQLDBhPcmdhbmljIEZhcm1pbmcgRGl2aXNpb24wggEiMA0GCSqGSIb3DQEBAQUA
A4IBDwAwggEKAoIBAQCkLFKcf8jK2dB0dVNFO8ULxmS+4939oXH/TSF7JiNmUxGI
WkPyUSgHQOatbhAK7Z91ZnmWyVrnGzXjccvW64uLLrLFA5mL4q0iiwroxPnaP0qv
w5ZnZmDgH/SPrzt5yw8ndagkfpxLekG0Pwbh4Coffg1VgEw/gqjv//moUTSQB66i
daNHd4bN0KVDXmycUdqI2ER5iqnDnb6Fi4DTQXSkwd29t/mRaHcQLrwiV58YqsBF
YcpE70UWgV7j+e5qYUlzJ0P6Te8QU1pjqigWoAuJNptq7E9wenSJ+7RZB1c+R+48
bBuQpoX+UVQfTHIeJ2NSKiMN8deLUhPj+fQrCp+1AgMBAAGjFzAVMBMGA1UdEQQM
MAqCCGNoaWEubmV0MA0GCSqGSIb3DQEBCwUAA4IBAQAccb5ZaUOWhp4FAwQ4iTfo
5RHaPGD770BgpIvl5yKAmfAN04iF6GgcCvZP69m5lFlNuQNaz0kOTIY8cNvrksHF
OYNbm7aHHdCGKs8sjdXxrJrL07MwRsN+XdWIDECGQBIHmvcOeY3HLdxcGr1lSpuP
xdT79hYrYeMBaHF3RVItts6fNVBGFmA9hf6/cDEIRt6TDbfBy+PCIRQO3OxKa+ch
sIemO+3tJsyB6xJz+iG7lO8QCI3qtn02XoGM82WMjgJVorWMzTSoMIP9UWMECoDw
Q9zy6Fqy4cOWT2qduWD/7r+5e2jmI22wEU9LW3QlNt9XziVBGqnZEiKfOdnf3XdB
-----END CERTIFICATE-----
"""

SSL_TEST_WALLET_PRIVATE_KEY = b"""-----BEGIN PRIVATE KEY-----
MIIEvAIBADANBgkqhkiG9w0BAQEFAASCBKYwggSiAgEAAoIBAQCkLFKcf8jK2dB0
dVNFO8ULxmS+4939oXH/TSF7JiNmUxGIWkPyUSgHQOatbhAK7Z91ZnmWyVrnGzXj
ccvW64uLLrLFA5mL4q0iiwroxPnaP0qvw5ZnZmDgH/SPrzt5yw8ndagkfpxLekG0
Pwbh4Coffg1VgEw/gqjv//moUTSQB66idaNHd4bN0KVDXmycUdqI2ER5iqnDnb6F
i4DTQXSkwd29t/mRaHcQLrwiV58YqsBFYcpE70UWgV7j+e5qYUlzJ0P6Te8QU1pj
qigWoAuJNptq7E9wenSJ+7RZB1c+R+48bBuQpoX+UVQfTHIeJ2NSKiMN8deLUhPj
+fQrCp+1AgMBAAECggEAMt60/l8uBYT2bY+JLNO3W82um+OZfqSO4S+yJymLIIKu
1RQ7J5N0FsNKdwS6ndhBZ6xIEqvzqdapnP8+zSqRQ6BFrnxOEKU9Ro3U5Ilcbf7c
kpfFO+biL7BXJEqE4FlGKdDwN9avcUfBoitBY64E/1scoJivh6Jh3HPxlPEMm2/2
2sYJqNGdO//MQ2gAcLclv2DhI9n5sI0/nieAETBj1z20/0Mq0YMxLTB8s7ctr9UM
7gW3QoYwy6vmHI3OLrEDS/4cmZpBLeHmeQ4fcxsNAENu6+OkCTgiVgoTEWyJdtPe
/4zUWrcbXP/fYa5zH0CtoyeB047KjF7Y29kqC0PjBQKBgQDSXCRpdbrin40TaESi
uoFp0IPIqYediEqPMbn8+6g7GUGwDC3HsJ58njQLXK7g5MA259HtVdY6AfV5o7mU
IR75WFfU3JVvmi24mucDMpDx1reUQg4s9xt8OQZL0sp0RZIh4DuAhF2LRL4QUdsG
qCDaGxY7gtUBz/o306U82d+ZCwKBgQDHyt0ATDSaoT9Ra+h8jrRvelx4ORxa05l5
/ZaqRUthG9aOHvZLYpKaFsnEHtoBCtKC+Rr1oIdLrXrKjq1qLTt693tUJE2Y/OjN
GcbU2XAhlb94UvQlg5e64fQLoiqLqr9Uu1iIF/PvXXghgYDw2qP0YpF9lcUa4FnS
xtJ602GiPwKBgB/U25mtu/rhA9sE8yXgrQaTC+4IYUIgRpAGiUtT1XAj8UGvhhnq
iwD2e4+glcHoO4HTcHvGemVKuJeQg9t7a5F1oczPGDnMDdEad4yPUUmXIS5pFHYP
anRQuLgujH4trOA9ayOWZAVYAJ69lDQcquP2J1YYBR2CGC3sc9uSaHhjAoGAO/Ma
R2mWa0OxLSxU8XMcn0q3DngMkxBlQB6go+zxBm2E/tY5jzs/xC7MUiXzwlZN/nDi
7wtBLasbakZPsMlrzKUQA5p1Ek/pRwnSCLJKHDnD30X87njDAZelVAxP+eK9UJ56
nTOaxZtlXaBvYVYp1j3xbB6Rq1PggAeaxrJA3J8CgYBV60pCQ70fdW8zx2WhUX8G
Hm6Lq4qVg7/M2inTUKVQfcoFzdbB1VcJqyoESwnQeK4dNTk3dQ+Jy8t10J3GQAkp
NCTCo4Wpy4cC/odHpEUFZpY3+LPRrvxDUGGDAJgQeOI969Zvesu593bpJa0b+0iy
sgSPHcG20oNGqqeAspJS8Q==
-----END PRIVATE KEY-----
"""

SSL_TEST_WALLET_PUBLIC_CRT = b"""-----BEGIN CERTIFICATE-----
MIIDLDCCAhSgAwIBAgIUU/+7JgmNQiwRivfB+ypu3OtSTJEwDQYJKoZIhvcNAQEL
BQAwRDENMAsGA1UECgwEQ2hpYTEQMA4GA1UEAwwHQ2hpYSBDQTEhMB8GA1UECwwY
T3JnYW5pYyBGYXJtaW5nIERpdmlzaW9uMCAXDTIyMDMyMjEwMjkyM1oYDzIxMDAw
ODAyMDAwMDAwWjBBMQ0wCwYDVQQDDARDaGlhMQ0wCwYDVQQKDARDaGlhMSEwHwYD
VQQLDBhPcmdhbmljIEZhcm1pbmcgRGl2aXNpb24wggEiMA0GCSqGSIb3DQEBAQUA
A4IBDwAwggEKAoIBAQDT/HGxRGnq6IATEXgdHTrT88mmY+JRNzeBnD9Uh3uwBkai
kJam31eY3oxEsQWVZRJ+Qsynr+VBgxFquNBnHmQ27JOqAH800oM1CC0bq4Z8ac6X
O1SjCdUQdaqpjScUNfxWgk6gG3e9KiuHcvyOezdIvPb5Z8Lgz1Wk53IiUpjOBRrL
jvBYVebvpAog12q8Flbf3Myu27ZsL3lUhVWpfl91sEQ7rEz3ollxl52Mz2JA1B2+
TzaU/iDctTQnRCk75RqDmVshnKXKXGNnClwZXtIea4mfVVJB4mJhwGvgsLRRj7eg
BM6E+jzBfz181Cr0PrhpzGJnfuOtEepby5F71GbPAgMBAAGjFzAVMBMGA1UdEQQM
MAqCCGNoaWEubmV0MA0GCSqGSIb3DQEBCwUAA4IBAQA5+/o35BCJRvrfMIp311Xv
ybio+Yq7Jpp4wDOT+6XlpGMMIHGtDw3fYXhZeXDLJQ144reDOnLWBEN7of1M0NHu
Y5ccTVeYaepZnvncyXtgokDtPZjegXj96zs1IDr5JU4F3x7xw3+zppTAZCgGQ4A9
rMwwFjsm+fbjITR9T5fLppUSW1aTCSii3i0VBzGyXZlLDuCqdOLYCOX6WFtx7j3y
jQYZlqXqv5idx1BiEJT4vqC2N8elpmPsZ0TIR7xIFft5HvlU/U+aCO4NRetJaRj9
JK9D6Jt3shpKLbyJOfa7foY6LBf+qS5MpC3kTnfoeVNpI6DHKWKE6d5+au48ARy5
-----END CERTIFICATE-----
"""

SSL_TEST_WALLET_PUBLIC_KEY = b"""-----BEGIN PRIVATE KEY-----
MIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQDT/HGxRGnq6IAT
EXgdHTrT88mmY+JRNzeBnD9Uh3uwBkaikJam31eY3oxEsQWVZRJ+Qsynr+VBgxFq
uNBnHmQ27JOqAH800oM1CC0bq4Z8ac6XO1SjCdUQdaqpjScUNfxWgk6gG3e9KiuH
cvyOezdIvPb5Z8Lgz1Wk53IiUpjOBRrLjvBYVebvpAog12q8Flbf3Myu27ZsL3lU
hVWpfl91sEQ7rEz3ollxl52Mz2JA1B2+TzaU/iDctTQnRCk75RqDmVshnKXKXGNn
ClwZXtIea4mfVVJB4mJhwGvgsLRRj7egBM6E+jzBfz181Cr0PrhpzGJnfuOtEepb
y5F71GbPAgMBAAECggEBAJuPzGrWlpdxCNN1ZVyQH6R8aUU2VVVeHNh7Lao9RhIV
eO5BBpzslt6yqeKauUs5gYmwQXjoxmb95OEZQK37inUXxQDjHnZH6UsYdemxRJ62
Eom+W0zNoVJT1upXkA7v0v4037f0kDj74jeitR1l5Fr3eJHriAHrhKDfy0zOqh28
H/28PUKAP9QVP93L8WMySDdQxTSgFnRmCN1ZFlR48UiIxD79W0SrY9W4V/A+rJ4o
TLoNSB3XBWWJA2iaCqhSHFziU8WvUqFa8ASrVnz4fQ9365jM1M5QlaGEfWkumKc6
7tX4CG1dYSF7RBemgEQuUKKoHmUxqZN+DqOFjrAlX6kCgYEA/pYUhOB1kdOs604y
J+UpbXiTK4Rdw+ZSjdXov56wfqvzklECyltx4m6VGx/8qVNnOHfBFFRvvFM0T9Lz
/DZZKhW4xuyZjeGz3qhcHICEdL1JIxpDyazb5KPGlJ6s+vqoY7GD1vObSzbPdv5l
yAmtn5sq2so+9pylki0o78FtbuMCgYEA1SnNuEJw7Nsq829FZzYEgwXL7HU/NbZ5
urZe3LEROeoFXFb6IZvMF2IT9yk+f4/pNyGSIWe45q6XlDQ34rMhrWrwy3BMo89l
xBBzdG/jHD3q2V2NrdkKc6jlaVbZS4mBpwpde1DYpB6BOPXl3K0+FH7jW/gaSyMW
cjmA+9vtICUCgYEA+Mdb4cUd3pTFA2P0azvq0cjjt8CviAGIZoXD3YyK2B3b9P0p
Bul5TlXVax5E3opb8bhEe0NPtO5xzhdMyQeq9g8n82u9WgJWrJxE9q03woQ99gly
eJ9see743L56Nv++kT0komaHOGalMZjDiUi7253bsNW11XOZ8FAlErUn5RUCgYAX
D4iz8GwrE6LX5yfI/K0MR6pCEIUgGHee3W/xzC4i59BgpwA0dphjxzaFvK6IOldu
oXEfsAru2eCIJgYNvndcPX+DYsjHx/4ocecrp5cYTRKFJXvYXOymipUXClBDvcKL
AbIPTzXAu5QbR27wqsVWjkumfXbKvicFgHcVyDslCQKBgEtHDzYjU1dWeo4MXjs8
e4C7I0pj9lPvrNFjtS5WmtpeupjdVzuPqTPRmtXk3EDFtkyklUYR9zoHxghDPeen
c/mzkwTj5tsjM4FByYglctZ4yr6hmFMFxM67fTSrKYRW2VWqFYa0eUVvFI+1X53U
EUKm1RKG4TkGm+pSLJEhkeiQ
-----END PRIVATE KEY-----
"""

SSL_TEST_FARMER_PRIVATE_CRT = b"""-----BEGIN CERTIFICATE-----
MIIDLDCCAhSgAwIBAgIUbgDpFoeaeAbCjZcmf9YI/M3IB1IwDQYJKoZIhvcNAQEL
BQAwRDENMAsGA1UECgwEQ2hpYTEQMA4GA1UEAwwHQ2hpYSBDQTEhMB8GA1UECwwY
T3JnYW5pYyBGYXJtaW5nIERpdmlzaW9uMCAXDTIyMDMyMjEwMjkyM1oYDzIxMDAw
ODAyMDAwMDAwWjBBMQ0wCwYDVQQDDARDaGlhMQ0wCwYDVQQKDARDaGlhMSEwHwYD
VQQLDBhPcmdhbmljIEZhcm1pbmcgRGl2aXNpb24wggEiMA0GCSqGSIb3DQEBAQUA
A4IBDwAwggEKAoIBAQC4vhXYgLWi/5xCrTP3efRW65MPn/vzynsCul7dya5vmTiO
BZV2BkzUBRfZygARIUy7z9VsX22c4I/xRtJUkjAtDaSw02bnlL0BZSjZg8DYWjZO
woO++FNweJ2SxvaPQypDCyRQuiIMGBcsqMX89owC2y0cQtYbB8kA90WXNeaSXXzB
WTpPd0pRDx+VOs60hGIfH5y6S/MkgDPHLkXYCGMqRK0vBbKr9yWq7YNkFmgGd6oV
qAspX0ykx3KOiubBO9WV9pw6Tn6Bzm+5yD2E4p+wmR6r25MEHExB8mzULoD3wQWE
1xRQDZ2dF9dr0CXSnDlOpCf3LcHX0z1NJzG93/M/AgMBAAGjFzAVMBMGA1UdEQQM
MAqCCGNoaWEubmV0MA0GCSqGSIb3DQEBCwUAA4IBAQC7rOkhmH/14hXD8dFxw7fv
MBE07KvCbbYxoupD3pUIHO27Nuwy1ZtcppHB1yLztFVy1gk4u5HfRPkliVrsUlCy
IQ6JiWl11TU9vPQHU6ZxAVYrmS4UhxKjOVQWJ9ZXHcQWamNZS31uCfEpG1AvLcQp
rP441aWGVl9pn4DvYCcrGA9iOIh4t4+IP9KdcehXwf5aIip6j7FR7lRgoS65xx18
aekW99yqzJtyqtx+UCn64a9lGFlCvzdUvh1N8qtv5O1FGC0u5erCkTpdR4mwbljh
Wl7fa/81yeoV1PM6sHrp3mEK1qY5yElHIEKlsoJvnoy0GRJXY+bhfEcZVEDvl9rW
-----END CERTIFICATE-----
"""

SSL_TEST_FARMER_PRIVATE_KEY = b"""-----BEGIN PRIVATE KEY-----
MIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQC4vhXYgLWi/5xC
rTP3efRW65MPn/vzynsCul7dya5vmTiOBZV2BkzUBRfZygARIUy7z9VsX22c4I/x
RtJUkjAtDaSw02bnlL0BZSjZg8DYWjZOwoO++FNweJ2SxvaPQypDCyRQuiIMGBcs
qMX89owC2y0cQtYbB8kA90WXNeaSXXzBWTpPd0pRDx+VOs60hGIfH5y6S/MkgDPH
LkXYCGMqRK0vBbKr9yWq7YNkFmgGd6oVqAspX0ykx3KOiubBO9WV9pw6Tn6Bzm+5
yD2E4p+wmR6r25MEHExB8mzULoD3wQWE1xRQDZ2dF9dr0CXSnDlOpCf3LcHX0z1N
JzG93/M/AgMBAAECggEBALOuvhSrav60WklHqOmkxg/cZFaoJigB4g7PMgHJbU3B
2w3XRH1ct1Dn+0CqhdIjbzykclJLppMUnyvu1BfJb+4B/RK3KrlHI2W9/DNDQEet
xnBoJDeT06PqzGe7+IdyriIzLgkOYJseuzuGk7rsGVWV05RPNWto8Qltd1QQ6sej
V8y1bBvvywhhhMi1fxr+s/nC4mzURpCJUdENv82gaklf192uIvB5GCLum91GjZKj
VmgL/3l9A0Wy3Hwp0xdOPxAoeddXks6d0yrlfwSa0AIFT8GNyuOKPRgCHWDjg1FA
3iOYZYQlmMt1OzKgTm0juuwK3VAao+zuBZPslfSs2CECgYEA9Z+NVCSfRlN6vvrv
Z+tiEBPMfKlf3Bb5K9QxLeJ3iGoqNyH1DbBn63SWukpI60qCE0HOsWazwI+G4DLj
XsGaa4DodEVqqncBzS4DIDU03xBo814d/X/5S5vW411o3ykDhbyoq9Exvt1UlDaC
Ntyv8AunBDH1Pcz1fHL2ELKgaSkCgYEAwIwZohhzNp4xX6NORRJh0hILWu20mMXE
Qq4xa83BqNqmXTmQfD99O39RdwSzL5IExCQCtAfHXDs0ZuQE1p98T7PI9xSOUrAe
iLHjlOerCPhUiFr2s1XE8Nkh5qz6nOFyaCgodbLXB+UMiAGR4hZCvxj9BZa+35Cr
egPUw+U4PicCgYBJwvVtPGY8d1tYOQFmQtC7JUb2dOLdtGR1ng56yhS9eaxdzCvM
RZqfoe6V2TMWvdRcNhn9Omtmu3N0prOTRC68dATazfHfaUe4N0YnCPNsvX/W/f+h
nineY9lfhDC3O5jcM7CvkG4Q9GSu8cOe+B05yDYK03njakaabeepUgtMKQKBgHRf
uNZppKjsL7c4AoRoucq3sTlB1hdH4HjUw3X+o/+kN0y9EACods5RAzHGG26y+EJ7
6U5aLTonZmKRigMV3ZJmfR4oxGRhofLIYV6MLql7Pcwz/kshmahf88dx4P6UnAsr
ylhowOI6o7pICJ33Clxpg/Ouyqpgy+MxEZVcowOdAoGBAN2aBN/UZrisEFeVzTVu
FALP5NUPl6gobaPLTh4zFf3gJqArivZgV6EOcXkBHJgRkETcZl9dFVH2rJbhjFbN
beT6eWgATdaoptZhuYuqNl0p36mkCFemB8bsU8h8MlfZVwBGcJHQKTFcXp//p40q
DSUp+S4QDmrzcKn0dAJVeP7d
-----END PRIVATE KEY-----
"""

SSL_TEST_FARMER_PUBLIC_CRT = b"""-----BEGIN CERTIFICATE-----
MIIDLDCCAhSgAwIBAgIUcSw+1Ww+zDNNx/vNquiiebp0nRAwDQYJKoZIhvcNAQEL
BQAwRDENMAsGA1UECgwEQ2hpYTEQMA4GA1UEAwwHQ2hpYSBDQTEhMB8GA1UECwwY
T3JnYW5pYyBGYXJtaW5nIERpdmlzaW9uMCAXDTIyMDMyMjEwMjkyM1oYDzIxMDAw
ODAyMDAwMDAwWjBBMQ0wCwYDVQQDDARDaGlhMQ0wCwYDVQQKDARDaGlhMSEwHwYD
VQQLDBhPcmdhbmljIEZhcm1pbmcgRGl2aXNpb24wggEiMA0GCSqGSIb3DQEBAQUA
A4IBDwAwggEKAoIBAQCj34tYd0hFq2vNzARK5oT3ZU9MX0GNLidDDBPpDkXEYZnR
yVqdLe61OWuU1dY7Imdoc72HCDQLEd3bV2dux2jE3ktHP0zELRIucyhBJvx5zl68
ZO004prWYH84O1GlTHsz/OQZeTyN8detpOgEmjZYJnPOWoMW063r5YAxfZ5BRdlx
MTmnJjLIxX2q60RjoVZXNtl5DOOxnYdGX6w5L6KXMr/A/65AePP1RYW6ugkQwcKA
+PsAbDz9T7qDmgu9gHcDtGUg30ua6kLgHPx3ZrL5RI9KxfP9l/r3TEXg1XhlVyv9
ogb12SQHitHR9HFcs2y1CraEw7HGTTfn1wqbqtzFAgMBAAGjFzAVMBMGA1UdEQQM
MAqCCGNoaWEubmV0MA0GCSqGSIb3DQEBCwUAA4IBAQB4Z7WQTY5irFfCZzVsLjpa
ntAiAe/EdaGbx/12Hy07efLQ29D7eMWOvjjlDUjAZFDefH6SPB3bZXY5rhY1qHnC
7l3Fut2SqToPy4/8m895GNOtvPJQJgw3nUijKA4k+tSdN9XZz39sDYGKzHPMuAk4
D0S6MWIrT00zEUMJMUoFfCF7W1II5phrlAZTczdEiXo3fn6nSgsDXGgZS6Y4QXh/
5HCPCuI/F1qZWK3eVdrrQaB7u2LLo3+qfku7unZ7+/EgomRL27pMukrL/N2kGU0U
7P8mpcs7j+Sn9POI9h2fSbB4IElbHP1AM/mTfLc38bKQNt1bnXzMKfhnOWHshBrm
-----END CERTIFICATE-----
"""

SSL_TEST_FARMER_PUBLIC_KEY = b"""-----BEGIN PRIVATE KEY-----
MIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQCj34tYd0hFq2vN
zARK5oT3ZU9MX0GNLidDDBPpDkXEYZnRyVqdLe61OWuU1dY7Imdoc72HCDQLEd3b
V2dux2jE3ktHP0zELRIucyhBJvx5zl68ZO004prWYH84O1GlTHsz/OQZeTyN8det
pOgEmjZYJnPOWoMW063r5YAxfZ5BRdlxMTmnJjLIxX2q60RjoVZXNtl5DOOxnYdG
X6w5L6KXMr/A/65AePP1RYW6ugkQwcKA+PsAbDz9T7qDmgu9gHcDtGUg30ua6kLg
HPx3ZrL5RI9KxfP9l/r3TEXg1XhlVyv9ogb12SQHitHR9HFcs2y1CraEw7HGTTfn
1wqbqtzFAgMBAAECggEBAIVpmj2Epw8pVxPts9TyxW/QR/XqWyjAWXCJZbBIUV5n
A1666g2q9nsN61r5mHb+NGfiSnujnxMgEZngF7IloFMekvTHQQ05kGLGmBAq2EOm
UpRYKpHyppI/b3NtP7QuhuM1UNK4VCdPrAKPjeEpV3L+oyttnum3nhG9/1bLaUrD
cJIu432eKPLNF0jdjtCCnuPmZthOh1qAETCtlQ3FmBnUOu2XVwY6kXMOFh8iA4GA
FMxx8MmHtAeCsY0ESp05OeAE3xNysrSMZPrhPPGtrvKGbImYJrmfOT8jdlncMx1U
bvQj15qsf8y6QjWsfgGYssoWPLtcZZGzXdwQp7jpPeECgYEAz5FK5Bs1kFjpBNDl
vSmkbwLVv4tPX5Q4WVafLA02AHfJznXNNydM0X5iQ1FvSrdUNx1hbHMytTQX/fRQ
Q+rHdCC5dnhhiYACUTgb2Pc6Vtfn0IASaen5pZGr2wDF3PND68afuJNaQM92B/yO
xKbQFg/810qTnvBLyPX489zYYbkCgYEAyhw+HHxcxTB+QJl5Y2dosdkYxtUnPiUL
zYaVpot92pHZ+K3FlIH1gDI17dITcWVOGLyxbUPsLG4apBEq2qXxeWlmGKT2AZi1
36+uJwXZSI7dzY4pODkU+IdqeHxa1gIRHoBDB0BMqMhTITnBL0Ke/3rGDQMhKVzC
WI4VtXjHyW0CgYEAsyoNg9G8rWkhUafi9iHQroW67MgZ7j1pWiv73rFUkJjVV+G1
Dktc8mNt+/952ftetOgmZM8W0PQzVWCiO82W9jUdARat0lrtJSASYXgdIkLg9Mbn
ngZ5F6IivjnvkGVmlkhvK4n9WH36urAUp8f5S2HndAoKXCG8uK0gg5Z4K/kCgYB5
1HZ4U1rUnrusExeCHSaV9kiiKoDiTBCGTndNEk7F/x9GcPFl6MTlBt9NQVHpC+j8
rlnBhK0Lxz8V4SdU76zUw/0AJAgKxFP1x3+SFEt7GmuHagdc1cPXYEGE6WkUEeDh
4u0EpPTQ1RiPMbJK27zeQdK6q0VFGp4oJVXeszSzLQKBgHlC8nj9NKpaFWh0zoNX
FKdjOgXvsTe3a6ZbjjQe7yCsuwMmsDxIExnRYowTp9dxs2benh5hn7aw+IulV/rD
YmXKRj6wNr5LUy0ECSAfAmpMilAN3R6BK+ySAIXL63iKsn5fc6i76kREUc/9wyJA
YAy+y2CnPvr/gJB1OwB6NCwx
-----END PRIVATE KEY-----
"""

SSL_TEST_HARVESTER_PRIVATE_CRT = b"""-----BEGIN CERTIFICATE-----
MIIDLDCCAhSgAwIBAgIUcr5lcnpo87wW1R4tGOd5W3U3m7MwDQYJKoZIhvcNAQEL
BQAwRDENMAsGA1UECgwEQ2hpYTEQMA4GA1UEAwwHQ2hpYSBDQTEhMB8GA1UECwwY
T3JnYW5pYyBGYXJtaW5nIERpdmlzaW9uMCAXDTIyMDMyMjEwMjkyM1oYDzIxMDAw
ODAyMDAwMDAwWjBBMQ0wCwYDVQQDDARDaGlhMQ0wCwYDVQQKDARDaGlhMSEwHwYD
VQQLDBhPcmdhbmljIEZhcm1pbmcgRGl2aXNpb24wggEiMA0GCSqGSIb3DQEBAQUA
A4IBDwAwggEKAoIBAQDFYItZq3rmZTSdcJK7m0sPbVSyexV4mIVkR1JLSYDkRUfC
xWqPB2ZY1sc6a+Tns/0qVOEddjfD8j5GrRU1g9VluSnKp2bg9NgQkqTEuyLDPF9C
iP1JOQudPSPQTeSwyOk2bQQ4LP/nRZXzZ+NnAEEHTkTD7D6LvFTGrIEShLIqxHdY
5EeFXF3zTpp6LOQYii91joqN6i4BUbbMr6MoRIgVUZeEdmKPHkyaIg2LJ+HiqrNw
xc8Yg1ksRBYAKBbPptLsIPXp0T5ja1SUEUkyDaFclzZnAfQhB57+0VuA4/pIJcLV
9p1avjw1PyrHqV48AGB/NqWA/+4kXEkZ+DrrY1D7AgMBAAGjFzAVMBMGA1UdEQQM
MAqCCGNoaWEubmV0MA0GCSqGSIb3DQEBCwUAA4IBAQBIvNub05nXZoxHcysNf39o
DudZ8wmn1urJpYQQUhFfZ7eGyTTgNiEI9Mz+kVK9f+BR6ylw5yDGpIC2BY2uDdR3
r+y6bs2loQzfIMWAOEsx86zMG1XmYj8zQ7pjZ/AOInu/Cy/w6AwNIt7U3B8+nZEA
qPatVOMPh0yWJ3CGjY3lP9mjhREyUBwBsUOq813JYXLsq/euFm5HPVptYf70Ms2Q
3qkSmyZFozJbW2/wqsb083kJ3djkVliqSDVQ2TnQCi8PT/9uE8LfMTrnWbVZlTO3
hxByAQAco0fiTQ7BN74FuhzqBLBadcnQ6HnWe87E/0OI9co3+vJR1H6xHSebJ9pu
-----END CERTIFICATE-----
"""

SSL_TEST_HARVESTER_PRIVATE_KEY = b"""-----BEGIN PRIVATE KEY-----
MIIEvAIBADANBgkqhkiG9w0BAQEFAASCBKYwggSiAgEAAoIBAQDFYItZq3rmZTSd
cJK7m0sPbVSyexV4mIVkR1JLSYDkRUfCxWqPB2ZY1sc6a+Tns/0qVOEddjfD8j5G
rRU1g9VluSnKp2bg9NgQkqTEuyLDPF9CiP1JOQudPSPQTeSwyOk2bQQ4LP/nRZXz
Z+NnAEEHTkTD7D6LvFTGrIEShLIqxHdY5EeFXF3zTpp6LOQYii91joqN6i4BUbbM
r6MoRIgVUZeEdmKPHkyaIg2LJ+HiqrNwxc8Yg1ksRBYAKBbPptLsIPXp0T5ja1SU
EUkyDaFclzZnAfQhB57+0VuA4/pIJcLV9p1avjw1PyrHqV48AGB/NqWA/+4kXEkZ
+DrrY1D7AgMBAAECggEATrtKGsS6S3kHWd3zyf4SHN9Br8hFMku0ueFxRDLXxTaV
f238KX2MJ9fUtMshDgPP8rjU60miyPiyOsMD+MrTrrYDo6DO+uDv5vx32TnEjhhg
70txrWmh5mDjDk5j8NjTnjAyRK4+jeRGAkfof8esKNvhtj1gXaEMOAvLmLVx1HjC
xaVUJXY2QtBJiJ89DEYdjiNwMZvJQ2FjTBk16d7di/Ntgtokm0hJfb0r+To99q21
67yC7QCrPE0slrnWA/Ks0WOaWPiEuG1H9PLvlPqUgByIuRbSezAJvdmBGH3EaABL
Ir2uq2sRWpb6YbhMJV3jlorWzzcQHGzdEU5FxnOacQKBgQDhJpCkfQXdZTtpAwHD
pP6NCtLAmc2URLa6DINKstfsTG7W1WCvPjIfMCsGDXEfIqcdCZouuUw+jBwOEK0E
75gL6P6AZqT1Rtp4ltHi9xW6/aAcNDVap3XC/GhXUWcI021r9PAoqhB8RlqxMSrb
3iL2StulaHyypHrV0SwoMBX85wKBgQDga8oDP2OHdWRe/hWWC+hzd+eeHH80RfN3
nVNwEWnzXMPfMfUYnfttQwraObYkVbU9grQDJUQlQD4xYQhK3uU6uMjWzodmTdey
HRCp2/9Y8D06sbd4nE8fgGj8zUdZUbvahYO1uOg5WJdgph3bXaEpN1QIyoZpbqLS
RYhqMVRUzQKBgHDZM4Y+Y8IkCzMHHstA15U554hBjpjSGAQIYYX/PdpiNOvY5yzu
r5CSQ/40no5MgBY9ydnBZkWzVBx4nz/qFvthPK5+xA9sA/SNI4Xu8iVXGfkI8fUO
Gigw+ttJIat6zU1e50B6fOjNGofVbPXm0P9BZfXx+Q5RAoBI5yj9cQfhAoGAHIO1
lDoOpFx3F1bDWWBD9b/rbvyB8RteNvmHa3ra8m/79zT6xlj0ZEqba2TfzrgRIjKk
Oq4WfYEvJckFa7XsfEyUQC7Xp1kGqfvlbR+lzyAfN4DzJeD+cKs5K73NbfzjmH1U
YdePshGekkopCwFXg8wi4kcRUv4atArfrVZ9N5UCgYBKe3qSZ+AMQPWR0NkZEyBv
Qa/IBU5uMtEG715FfydAQoqkXJ0GZ0MzX5ByhS+suGOotvzXOfK1XwStvYu6rXHO
WdmtYre5e48lbtP+b4Mv45rb57ymBGrb9eJAlurOk6aK4B4nN1P26zVQAuhcfF3M
DD+hIL1erePro7W8CsCb0A==
-----END PRIVATE KEY-----
"""

SSL_TEST_TIMELORD_PRIVATE_CRT = b"""-----BEGIN CERTIFICATE-----
MIIDLDCCAhSgAwIBAgIUPDgBpxOAo73yMiUGMFNbK0SvFvwwDQYJKoZIhvcNAQEL
BQAwRDENMAsGA1UECgwEQ2hpYTEQMA4GA1UEAwwHQ2hpYSBDQTEhMB8GA1UECwwY
T3JnYW5pYyBGYXJtaW5nIERpdmlzaW9uMCAXDTIyMDMyMjEwMjkyM1oYDzIxMDAw
ODAyMDAwMDAwWjBBMQ0wCwYDVQQDDARDaGlhMQ0wCwYDVQQKDARDaGlhMSEwHwYD
VQQLDBhPcmdhbmljIEZhcm1pbmcgRGl2aXNpb24wggEiMA0GCSqGSIb3DQEBAQUA
A4IBDwAwggEKAoIBAQDDT7pUEKAS2A96fkLb1IfDbHZCpOTUgKk7+uNQXTKarZv0
yys2/K/StPGJ3+mFlN1+dqubVHUILhPUpfFNHH3zintDsCjwu1GPKRuqgPla9ZAb
zBft+KKm2CewqvVotYOcfIAUqZMmfWuyxZFL/ITJqnJKHqYU3yO8pNO3k9c9tKVe
AVLlarcHJitjSkKz+s+3XRJYC/x6BsguRiNGSPVPAM/jV9PGhaQqlhWtQT0/kcEs
MRICpIPiPd01bX9NWbSoEbCVN2mBBxPi7fV4V2Y+xkdjj0QtkLmJJTnatNNK9UjK
5npRqHyw1ogyguno10Jx6e5vd+3hWiJlBOzpqiT1AgMBAAGjFzAVMBMGA1UdEQQM
MAqCCGNoaWEubmV0MA0GCSqGSIb3DQEBCwUAA4IBAQB5xd/q0Z5SfPECusnXmAwF
X48KLYhjc1/483R1gz2Vy1XNPWzDDs9I8MWD02BWr0dMMuhV6iPFmmQcJ76ejJD0
NMtBpjDFfCknFuMavbog9ikPEXhL3EtzXP3jC+xsdvYwi35hkBgGs5hnAkheKklp
cjRurmsBAHJBlEsUc2C6kxq8FXcLM+WzJJYOitzE+fpyxrmeOIfpUd8Vwiu90Ta0
/w1mGD5vlXBTiFCwLEc2fVR7OPm3QxKvJ+eUdLTh+X4VgJ5vvdiqCodgAeqDZw/Z
x4hOnAEktgEqadUz5t7fJzxuWWpNTL8OQLJgW1cE/Kt/P8F9IQ5rC7PS+XU+Ds7U
-----END CERTIFICATE-----
"""

SSL_TEST_TIMELORD_PRIVATE_KEY = b"""-----BEGIN PRIVATE KEY-----
MIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQDDT7pUEKAS2A96
fkLb1IfDbHZCpOTUgKk7+uNQXTKarZv0yys2/K/StPGJ3+mFlN1+dqubVHUILhPU
pfFNHH3zintDsCjwu1GPKRuqgPla9ZAbzBft+KKm2CewqvVotYOcfIAUqZMmfWuy
xZFL/ITJqnJKHqYU3yO8pNO3k9c9tKVeAVLlarcHJitjSkKz+s+3XRJYC/x6Bsgu
RiNGSPVPAM/jV9PGhaQqlhWtQT0/kcEsMRICpIPiPd01bX9NWbSoEbCVN2mBBxPi
7fV4V2Y+xkdjj0QtkLmJJTnatNNK9UjK5npRqHyw1ogyguno10Jx6e5vd+3hWiJl
BOzpqiT1AgMBAAECggEBAI72+Uk3sjSY+xuK+J25gHdIGXjHAsmaNEa3a1UUI0qd
8h7J6SQi6wCtenCV+nXRdiBv9UWKGPCX6eQqY+syA/AVWg0+EXnFY/oK+TlhlyVB
wu7WAl4rNcQzTTpAqcqvs1sEtyxoxFHUVNVTUPvyJ7EGlwoyTRfSDnKzpFYoXdHH
8+p1wOcfvWGVkUpRVopV5e890AX4mjYPtG9rc+S1EyMHVzcm1UjnAa++QiznSfal
mwiSHzyqHBlG6u8mJj+ZRLKLYKCciQsktA6TOIyvyA486ZHPLWwNjd9RhqgjdydD
a9rTOouDwaRAN8uDdRuKsVhdyFpE+ShhFLB88amdewECgYEA+8WUqPOHgCehvgKB
g2AqdkdN4McRjmIZAQJtwVae/1Mn89qlFQIw4+Nbxz9LFl3Pyd4G36nKXnudWvC8
5Y7hDpxwmvVr7Vrotz8HEv7BTDp8LGN9A3qzdUsqSsAvGCZtaOEA4AIM6z1SPg7W
WEvFuE9K1pIAyHudzs4A65uLbQUCgYEAxpdpjP7MXyVCdBTM7TOD7hVtLttHkp+M
ugxcXgH5Mn+fbWglSMpI9FNwFma9JLG7Ye/wOPiC7FNV7PGKz6H/o0V/TGs8PvPG
oo0xnvVuzNHSp83MSQyLHiKePXSBQI+GAD2Txu4sWbekgAn016IQgqBlPgf1Mi0i
0sJ9ALyL2zECgYBfr0CHUT5fAzDiMLud/U9F8mVzltRiQ3/zNUQXJV9589WMRL1W
laWVBlRcDf7weii9NIdyO2owrFQqOrHfoISB9AyLp9gjtdgZxHdgzbcSzGtix1C8
oMZRPobNL+r2B6yvHkwh1kWopX57HVJy7iEvodr0Xzqy9uALt5j78fp0LQKBgA4N
FoXIXXN58mq+MgWyeGo3D+OZ1kWUjmN3jm2EXDprdz9JeCHfViwbXznmiQl4ndZ/
IJMXWkQYXWMHcBfi0XCe8TPZ/ohBvVMxBErH+M/7JJmE4Shl/83hCysz/BUyUnvf
333ayj6K1NPOYImFSP/FE4TBEWM8eFNLOYb80DRxAoGAQTX2Cls67t/7r+YFatLo
BHt4aNnszbBFqnsSiH0zZVX+i7e1XxnhsdapwsEVrYdbcT9CCHaPPar5patEqVsl
/Mf8S2hCnCRR4poOc40rk7pX+RHVU0GdSsHT4L6eC+4R9/i5OTfOZoJz5rTgddZe
G7NK4b0sDhXu3CaA2j0CVKw=
-----END PRIVATE KEY-----
"""

SSL_TEST_TIMELORD_PUBLIC_CRT = b"""-----BEGIN CERTIFICATE-----
MIIDLDCCAhSgAwIBAgIUIDNyJc/WIgjFdIWtYp9/dZyhDFwwDQYJKoZIhvcNAQEL
BQAwRDENMAsGA1UECgwEQ2hpYTEQMA4GA1UEAwwHQ2hpYSBDQTEhMB8GA1UECwwY
T3JnYW5pYyBGYXJtaW5nIERpdmlzaW9uMCAXDTIyMDMyMjEwMjkyNFoYDzIxMDAw
ODAyMDAwMDAwWjBBMQ0wCwYDVQQDDARDaGlhMQ0wCwYDVQQKDARDaGlhMSEwHwYD
VQQLDBhPcmdhbmljIEZhcm1pbmcgRGl2aXNpb24wggEiMA0GCSqGSIb3DQEBAQUA
A4IBDwAwggEKAoIBAQC/em2gGo4JEdff7eRAMG3two7JlNvEzuTn95dcxWo3Pydz
OJ83gPrGCM93zBvxsCOppyER+c34D9toxAvu5N7S/68eGOPlvbqS1aUJtMRXIoGg
ghIlz1w97VOmQ2DS4PZX1Yw+563ah0T/kmKvrJ6Ti8MOqvJ28GNnDObBP1hSfezu
/iRbiaGJUF0wRULFaPX8uNnOT8oxDXzsyBRKmZLN/O3bwbpX3hzIK2D7BBpqUza0
AuO4/zemr3J21QFu4rD/Wbd5/zX4uxSOAIXbT2haDT5KZEUYQv2jXbHY6+tzpMRC
v+Bb3yAeFGt6K44fzqi0fj1pzoHZQ7pgqKwRKA0tAgMBAAGjFzAVMBMGA1UdEQQM
MAqCCGNoaWEubmV0MA0GCSqGSIb3DQEBCwUAA4IBAQBuL8MMR6mTzcL/0OOWVnQ1
phT2S9L1l6VmsZYK0/+kUNRphtglqiUg8TuHDUvXY6Bq5r+NY9De6ZhJMhsVYt5A
XRkBjEwIPLC5+JZi8iv9uip5qyqsfrt706zGz1NfVIk6pS97Nssj4d2WkdB8BrD9
fnngf6tnQJX4K7fhE/NWcE6YMSBA4GG/JvpH9ouJx4aN77zF6PKyX+iO3GDHXqNH
BAdEbHgr4pUPZuUg6c2x4T20NKnMNkx7C3Tx7tp2w49VamUwnwvm7vuzjajd2st0
q2O+l3iNwRuvzL+KaDhqexf3shDSCxuYSaInne2XmCiJjVW7QRfQmyA1LiUk/vfP
-----END CERTIFICATE-----
"""

SSL_TEST_TIMELORD_PUBLIC_KEY = b"""-----BEGIN PRIVATE KEY-----
MIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQC/em2gGo4JEdff
7eRAMG3two7JlNvEzuTn95dcxWo3PydzOJ83gPrGCM93zBvxsCOppyER+c34D9to
xAvu5N7S/68eGOPlvbqS1aUJtMRXIoGgghIlz1w97VOmQ2DS4PZX1Yw+563ah0T/
kmKvrJ6Ti8MOqvJ28GNnDObBP1hSfezu/iRbiaGJUF0wRULFaPX8uNnOT8oxDXzs
yBRKmZLN/O3bwbpX3hzIK2D7BBpqUza0AuO4/zemr3J21QFu4rD/Wbd5/zX4uxSO
AIXbT2haDT5KZEUYQv2jXbHY6+tzpMRCv+Bb3yAeFGt6K44fzqi0fj1pzoHZQ7pg
qKwRKA0tAgMBAAECggEAHyviHtdT2hwihZzntJ9ttfAfaKeoI2D/GNhQttSYlwfb
90D3goSnzodupvT+c5kWJS9FDfUZ19FVCbgorSprL/RZ4M9yglshvXe0V2ErOXgv
nB6wr6ETRi2VmZKMd6gR0ni8TR1QSywMSoLdN/YlFqYBCilAMaaut/78recPDNaV
Gv5RxAXoy7Dvm8G9hWR+QKIiaJXygaVdEnQI/z7Rc86aBxKYNwYz+pbGMM1k2gq3
lIHHzfEy2Jx1RO9QoEi8OZIyPZXFOww9tzJ6USdyduIb/9KbP+1TyyCC2vCEi/vM
Jk/TZMkEVI2YT6itkWYdcAgGwN9b7bu83zDvkH8RLQKBgQDh372ak0O3FymG6eOe
h6DAsMHs4CkZjlIAIK+3YddCJZeX0O89JTm0Ct4l0xXo45ORPAVMZCE4Q/S5J3WI
OubQNS+1SOCs93knJUCUzIylzjPx8SgH6OSUOhc6aqc/W33D8YkHthfYojypaxP+
q80YJrpc0EQWWnR9XM7MskBGvwKBgQDZBEa8ES1NMaLh974DwuFvaLNzhgeEwlAF
klx5JPE7aE34HFLOW3J//tAzIL3yxQZ86YZs/MhJlP24V0DRldmNqh75uhrkdAl/
VbF8BSUA7LnR561373T5OZD+oV49Lbcib2Z1fJHQ756IqEx8wmeR/WzzFAHYt5z0
bsCWgyVzEwKBgQCyhbo/7+D3VtE1lqqW46+EXLAJXmpdjoT1IOCA2k3eNAQKs9JC
y6c9y9EkqB+LAEPj6EJvzDwNUnib1rooQBWpvj/E0qLxUm9pJyJR+RG5Aq8/rFDt
X386QGeXfjBN/Sv7sG2TsLJMQH4dkUouYO8rBYEKVnlaCYhEhRPV6ZSv1QKBgAky
FjE35RyFQuqiTcnpAxZucFQv1Le6aBukVQjJGPO0esFNqfCWjWaBDJ9t/r5/vMOk
PY72syHzD0E1aUi4Ocy37bIVQbh2dkSQBAJGUYgVf9Y2I/KWEfXRi6ROgCjFfCIY
aFYIHkGlNamCwCL1NeBIxcoTCfT96sesvbpi+j5DAoGAQjZ7pYQstPZ5sEr/H2nG
PzDQh69XSgeDcyyh3bSLDWiauQLKB79O3X4AFMrvGGYw8skcPxmIyXyyMQpPHw+Q
Bmgp19lXRCv4EiEyd47dBMtx1mK4huNv0yjdC87PPEoqSy5vYmM39U5EpOoy65IN
At4QG2/6xEa2RMcmsW2erCg=
-----END PRIVATE KEY-----
"""

SSL_TEST_CRAWLER_PRIVATE_CRT = b"""-----BEGIN CERTIFICATE-----
MIIDLDCCAhSgAwIBAgIUMqlg7Aqc99ifdKynHggljrPnQjIwDQYJKoZIhvcNAQEL
BQAwRDENMAsGA1UECgwEQ2hpYTEQMA4GA1UEAwwHQ2hpYSBDQTEhMB8GA1UECwwY
T3JnYW5pYyBGYXJtaW5nIERpdmlzaW9uMCAXDTIyMDMyMjEwMjkyNFoYDzIxMDAw
ODAyMDAwMDAwWjBBMQ0wCwYDVQQDDARDaGlhMQ0wCwYDVQQKDARDaGlhMSEwHwYD
VQQLDBhPcmdhbmljIEZhcm1pbmcgRGl2aXNpb24wggEiMA0GCSqGSIb3DQEBAQUA
A4IBDwAwggEKAoIBAQDr7NWQ0b8tQSlXzaa41vexl0Zc3WrfF8aw4mEaMcXM6lkO
hX5QLZpuTCs0RGwLXVAuqEcbQqA7GIbhq/ch4c9PSkh+yBUOB8SHx3UanMe9sH7S
80rZCX+8HFMVMce5mMEPIRA7WmGRPf7+Fh0yHMAaIsaqDbI5f9DqLdWE+FsrFrdC
kp0RYTYQsYEl3YEPJfcYbfrX3I9GxKLSUX1iKsMlyohrFSlw/t2LlG1jeuxd5oLR
L79QY35LkCAsofDK/lThovM0qqnescGx4feZsLMCL4rv0td2GWNhA+4UofhTdul0
zRcaDZVrNEhCJk0RNf4wXtidqJN90Sf3dvIjx1qDAgMBAAGjFzAVMBMGA1UdEQQM
MAqCCGNoaWEubmV0MA0GCSqGSIb3DQEBCwUAA4IBAQCWj0tol4kMluTkz+sGjfpU
xTnbVkoJhaOVI3tdK5+Z8WkCS/IlFLFoHX1I5CoAtFDUTCrp1tU/5e0BzA2VfLME
B3+qgLQF1+Z2Qy+OBTRToUuOSg0n7qSQdG5zIsspKwRl+iobFKaxqw8j218/NKaa
+RJTdhRRrmrokiBxpz5AJK1WnLjYe65N/ZdfxHYoBMDtzrkCrPsoZQpHaUf/9K0p
v0tv8s4nr2NcAZrQeALoTvR0oJ5QlmRxfHY6xC170dLV9KHJTbV/FXXFmFQL1WkI
L74vcnYPvpD8tdY3kD8AXUFoYNb3sjjjmM5QS1pYva9PQUiuHqr8MAqAF4sHvnLF
-----END CERTIFICATE-----
"""

SSL_TEST_CRAWLER_PRIVATE_KEY = b"""-----BEGIN PRIVATE KEY-----
MIIEvwIBADANBgkqhkiG9w0BAQEFAASCBKkwggSlAgEAAoIBAQDr7NWQ0b8tQSlX
zaa41vexl0Zc3WrfF8aw4mEaMcXM6lkOhX5QLZpuTCs0RGwLXVAuqEcbQqA7GIbh
q/ch4c9PSkh+yBUOB8SHx3UanMe9sH7S80rZCX+8HFMVMce5mMEPIRA7WmGRPf7+
Fh0yHMAaIsaqDbI5f9DqLdWE+FsrFrdCkp0RYTYQsYEl3YEPJfcYbfrX3I9GxKLS
UX1iKsMlyohrFSlw/t2LlG1jeuxd5oLRL79QY35LkCAsofDK/lThovM0qqnescGx
4feZsLMCL4rv0td2GWNhA+4UofhTdul0zRcaDZVrNEhCJk0RNf4wXtidqJN90Sf3
dvIjx1qDAgMBAAECggEANdQ2sjE5JnEspqz0ck4R+8IhOsUGQlqhafBs6VYb5HI/
2ZFZzZ9qEeptHSLTaBBlYA/jEXQ1LOaet9TNsTxdWaEAQ3URYL8i9zvqGyVUaZJg
jW8XT8fcDiaESlyuTkltGy+XDYPEqSf1CzIufSWUKyJuI5S2amogV54Xjpw/6Od4
xrIvDgIJag5IM8dxUtx1wPjup+RMkqUbzewBWEAvKJNstKcouPS2QB4gyIJ5xBsV
AN2nmxx6ZGBpGxxDV0aLWppftmPUuojFkEvBD9yoQo5lLHhqnO/tTpTxZJnbjyNR
dPEEzpHFOgCdgwhO/xP+kNoHpB6m84HUTzRF7vI24QKBgQD5FRVrhKjqBgFihcsU
2+CZf9hQM4IzQPaVs2ZLZZVmOvpUe7eYY/9Mjp0Wcn3g7wXGyyPYSLgXjyKxddPy
9qDczcYdJtbOjlxER1aZdRQza9CKxZ2NAcyREEsc4ADEnQz/eHy67mNtB5oqIq8H
05T3ZbsUA8UhQ7MndSswVdn/MwKBgQDyejSxfIomi/OWG1yEgYO1Dml34h+yg/Pp
513YbQmnevTRgk+6GnKK9vezahNzTygSq590T45oc1ggZZjBumDh4OrRax+7XG3v
n+cpJSWYgsqW3DKrhTkLHJ7c/f6XLn9oLMpdGiQGDLO4iXpaBKccPvZHiOIKhs2F
xdwc9193cQKBgQCbWtcdVIS2UkCS3rgnrmyL0P1uKHJQ3XfvLxHifN2OAcMY5oFA
fz5A1cKMuaRhozOLJjCZOeH4b8JHxSIJLGJw1bd3fz4DXy+VNpmA5VFQMTLFGzSF
OlYJNIxk2iIgf4QX42KIhR9mZZN2LGPXEdSb6cuhVCij8sHPHnltkF6DmQKBgQDP
rD7pLGMeNItBqtmIW2y0a02FcdP4Du+fC5viuzCjkrmPnu4t1Gz5/B+WOGnEPq1x
oDAHbAPqDbASvzEf60MC8qHrDra0v6sgqnFPWhNjFdHxd1KmeImsrKybVabxUM+q
J4KCTts/my1qBcUWyBlgJcTE68W9gksQIbAt1uia4QKBgQCSIvXD6yeENloZR+YD
jUlsyICn59Z/p2AF9OJ5jY8t4HY8c4hBHoMzdxfRvGy4USq9NJ6vr/w5y76rnMCo
SHljHFE+JDfN2p5gQw8ZRar4Ia+0pjogQ3nQhN0dBWbNtETBf0XnCJhfLRXOOHMx
td1Mrxelh82bfgHW19MlGD1nIA==
-----END PRIVATE KEY-----
"""

SSL_TEST_DAEMON_PRIVATE_CRT = b"""-----BEGIN CERTIFICATE-----
MIIDLDCCAhSgAwIBAgIUO9NYo6D7Fn6nsq5uHYKUMvoi2dwwDQYJKoZIhvcNAQEL
BQAwRDENMAsGA1UECgwEQ2hpYTEQMA4GA1UEAwwHQ2hpYSBDQTEhMB8GA1UECwwY
T3JnYW5pYyBGYXJtaW5nIERpdmlzaW9uMCAXDTIyMDMyMjEwMjkyNFoYDzIxMDAw
ODAyMDAwMDAwWjBBMQ0wCwYDVQQDDARDaGlhMQ0wCwYDVQQKDARDaGlhMSEwHwYD
VQQLDBhPcmdhbmljIEZhcm1pbmcgRGl2aXNpb24wggEiMA0GCSqGSIb3DQEBAQUA
A4IBDwAwggEKAoIBAQClBJSKiguayx4ifSydXnEMoDWK+HeUkK/38DBFn/psx0fp
joXEUFXWcDba1WH9RtExs7PYD2n4w4BPSQjz6yIh1oNWc2HOpyHl0Kk5pL68yxWp
3jFzAJQHJGgkeRdMH36lUQwEnQ3U8a6YNqd0j5qp24p2qyv9AGARvcrCgp8GeyS5
t6/tedqzzyujUNiOWzwdfCsdKo7Bv6VbPtx18b1EDQylQefSg3yxLXDgZEPlFPkM
91/B/p2Om5p2Xi1ybITT7dgexHqqVo6bPzL7mYUZKSZ+dYZIb36mTxY7GWDf8ifE
kMO6+/8Wetwn+hw5ap4mzsAJGZU1a0lUOsQa+T1pAgMBAAGjFzAVMBMGA1UdEQQM
MAqCCGNoaWEubmV0MA0GCSqGSIb3DQEBCwUAA4IBAQCqtpCsF7eS40VB/wdjpn2o
jxGRfet1uP4QIAA3cNwGG4eWu4xW5lBk4duE6DXZYkD30qZYjHEsIPkefEc4sni0
O3IDSeomhw8Ek/GCgPdk47JF0tJEKRIe4hjMGKI3H0Gmczqp6F78QJNUvn5n/nBH
9WWefV6sMsBLJ56CKRoakwYJzti0aSbAaaT1f/iwctTTxg7Jg4begI7XJyxTvs36
hwnNCv0+XSol4rerpLVaMm2IKbzfpCHygqxUQ/erch3NJ7mRLQgT/biYM1atPLAF
b1BApc+IIrwDbDMeZd9DG/Ov1Kbns+3Lg5H1eNXhCf1DW9HQNu0Z3XzbARmxxQM6
-----END CERTIFICATE-----
"""

SSL_TEST_DAEMON_PRIVATE_KEY = b"""-----BEGIN PRIVATE KEY-----
MIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQClBJSKiguayx4i
fSydXnEMoDWK+HeUkK/38DBFn/psx0fpjoXEUFXWcDba1WH9RtExs7PYD2n4w4BP
SQjz6yIh1oNWc2HOpyHl0Kk5pL68yxWp3jFzAJQHJGgkeRdMH36lUQwEnQ3U8a6Y
Nqd0j5qp24p2qyv9AGARvcrCgp8GeyS5t6/tedqzzyujUNiOWzwdfCsdKo7Bv6Vb
Ptx18b1EDQylQefSg3yxLXDgZEPlFPkM91/B/p2Om5p2Xi1ybITT7dgexHqqVo6b
PzL7mYUZKSZ+dYZIb36mTxY7GWDf8ifEkMO6+/8Wetwn+hw5ap4mzsAJGZU1a0lU
OsQa+T1pAgMBAAECggEAHzRrhnsuUJpCW5FCI4wdYp7VIS91JXHq5L7V0gS7jWBt
19usrf/nC4LyzJT3T7bZjkWGJ8BacME/fT65Y66+KJnxAiMVhseSIGxB4/WkX/0j
Xpj2zuF4HJWk3+jKIAoAn/BgjmrIl9EQDBahuegB/kbWuzQJQHGWuSQjuH6M5eOL
oT0R61buQcj2jC9lGA0wQRbZ3/joWHvN6mHTSHxLr8Byxp4bR3lavsO2m6vbxFI1
R+JcnWNxxpBOBJCUT8K1O4PpPcIRt0+Mi4vEidH4hNW6xVCZqi6HVVnvZyIcVySA
cyXMEmdQmYI3qIsQQoe0TAng6nlSNHvuTFrrd0ZzgQKBgQDaTYvQUSxEmdea9hKH
ssu5PoAf8WwJDqxLtIzDcBNkFG5UUUSguWTYUc5dKtKwBkO6ZIUIrw0rT1oZk6Zl
8leLwLwES8ZOVthADhPaQCqQHeRzeOmrsPqvZa5W/QkNK94kfGPXeWN8Slo+Smob
+7amvlAXZd9Xx7yiC4jDOlbtUQKBgQDBg3p9dicsSEu206qSjstD3Ks219Hu4D+7
xGfSnjioDYNG4SPOCYK9kkfvA8lSQrbagwYb1dwVb5INlPlTcXomdBJ5tI8XdHTJ
em1X6hYwBdGg174SLwLq+fST105eynkyx3p2zCIQjFJ/2ybCLPjB2bDF6/SM64AJ
Fo6EybTomQKBgQCY3MIxfhW0d9GM9hBlqyKStZw8Qe53rSmi3WvQErPRWakkK8AV
l5xxCV+qx6i+j7RvWaH6QbHECQ27aTOUoY0CFFTT4UecZZ2JxRHLuzDSt8vXu+xM
SGJR3a6lxQvIiFZGUEANizfJubrVcYA51hnBSvSEXdZ1/iwtgEwlAL4L8QKBgG0S
OVk73mqEOUDMXykKGSGf4FUiIi688M9ZrZc2HQMD0smBnpfEHo/RQoBCpxeZiMzy
6t+Hk+v1HeJP5JQWst23sK4uijSTLDxfp//UbjsVHInG8Ff5bXCaADPQOFkPUG7B
ppINDuo63Uk5ccgiZveERrHYA9fl6R22PBA2TKSJAoGBAK+tZOCWqSzmqJICmsQl
25dkO4TxFSnKKR9GDJOG33/InVkuuiPeDTCJyF1FJtKaPoXd19QNgplYR8UDyJ1P
2cYO++vhhWa5WZqVzYAcO6fX5KJjrWS0ZgSNYG00qvTQwajUuiMZpo2n1G7rDmjw
B7u+xtbWWSeiabTmRwQsQ+MV
-----END PRIVATE KEY-----
"""

SSL_TEST_INTRODUCER_PUBLIC_CRT = b"""-----BEGIN CERTIFICATE-----
MIIDLDCCAhSgAwIBAgIUKrZllgClUfhW5LVCxMSaWdpORVUwDQYJKoZIhvcNAQEL
BQAwRDENMAsGA1UECgwEQ2hpYTEQMA4GA1UEAwwHQ2hpYSBDQTEhMB8GA1UECwwY
T3JnYW5pYyBGYXJtaW5nIERpdmlzaW9uMCAXDTIyMDMyMjEwMjkyNFoYDzIxMDAw
ODAyMDAwMDAwWjBBMQ0wCwYDVQQDDARDaGlhMQ0wCwYDVQQKDARDaGlhMSEwHwYD
VQQLDBhPcmdhbmljIEZhcm1pbmcgRGl2aXNpb24wggEiMA0GCSqGSIb3DQEBAQUA
A4IBDwAwggEKAoIBAQCxiqJHT5HiXBr1CxICYNvxLMEOaxEV+k98RIt1zrjrcfCk
GlQX8Y4nqF2gn/7s0wgW2lkPAjTnFH9r29lFzTx6sVqGuTal5efJiUqDxMYmWkuw
hVXcqSc0ocxKtL5hRikp+UifMW6YUQr0XDBrszSvVZRKiRtcwGBX7CUJ3pR40HxH
hdzF3K0XnqtymKa/Dz7egwpAms8EH16ndvNgt0Oy74iLLqbLSYIMqtRe99V7kClM
QpDpzQX47iQyxL047xpS0nArTgOfE2wCL+4lWa220O9TZf7Mon3XtX7SJb71lEkj
iNsQ++9S0vzM0BcWGeV+Y7H0MqBmbI0sYLltHG4dAgMBAAGjFzAVMBMGA1UdEQQM
MAqCCGNoaWEubmV0MA0GCSqGSIb3DQEBCwUAA4IBAQBWXFmtsc6tZu5VmqMEjOZ4
sPaf2yJgEDaPv70R8SiopJSXHNbn14+ksehjdLa4Z3R2QhzCicVMnhvovtXeXUi3
HuOnF6X5Xrk92wfw+1WW8DUsCLFFAjXggRxU5PDbXNafMSoP8005Jt7ai9S02JD2
yrbE1tgvCm4HYoliURCXh9//w1fen6D3WddcHuCHLYad5bHnplOgvtFobJaG3FEA
Px3wWmlv2hH22gQf+zGHkwVOd8Z+G9eSCl+wABRGUm4ef3n94DoqE1GqWJ02fHBT
hv3YRFiVH8A7AtBWyY3sdH5tgaO9uCwNiQ0gL64UyKS49F8jT5ChVTxidKyoQbWB
-----END CERTIFICATE-----
"""

SSL_TEST_INTRODUCER_PUBLIC_KEY = b"""-----BEGIN PRIVATE KEY-----
MIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQCxiqJHT5HiXBr1
CxICYNvxLMEOaxEV+k98RIt1zrjrcfCkGlQX8Y4nqF2gn/7s0wgW2lkPAjTnFH9r
29lFzTx6sVqGuTal5efJiUqDxMYmWkuwhVXcqSc0ocxKtL5hRikp+UifMW6YUQr0
XDBrszSvVZRKiRtcwGBX7CUJ3pR40HxHhdzF3K0XnqtymKa/Dz7egwpAms8EH16n
dvNgt0Oy74iLLqbLSYIMqtRe99V7kClMQpDpzQX47iQyxL047xpS0nArTgOfE2wC
L+4lWa220O9TZf7Mon3XtX7SJb71lEkjiNsQ++9S0vzM0BcWGeV+Y7H0MqBmbI0s
YLltHG4dAgMBAAECggEAC++cFVs+HY+/qDXEUjCc2Mv/dq6wCWA4s8wP7C2ntPyG
ByJWAP4WZoglM0VOaDGP26l2T1IAqIBySJgRNWYk6MK/qUsOZ3zbZms6fT1fbPip
Ggb8zMb6gclW6LbaDcQfxFikDz/NhaP9Lox8HOGBa0A/pfstwcCVOZQAsXcrWCvf
T1ilX5fViLDJERTqbNzvYQtcLplRZyfeOesAfgndQR5ZLh5BmzrXZYkLxMyznTaM
7l6gNL6qh6/+W39rRYIesHP8MTBMTj/MhE0XI3cWti77vdE6ydQLHMwzvrLp9/o3
QyDR3TP8+sL1C+PMOokZA5LEx6tapOvA29xKZJWcwQKBgQDmEAzF8eh04pQp+TFh
8JxvWrHg+OPtSj+Dfg8kO4VbMnTTaZvpmePETB1aHsUMA3DLCiNJK9dKvIXIrnhF
HzIuOtSa0HPGKJGLy5RESx5fozGIE79l5AK34Z39Un0+lNWyuf9fjGayjNcEErHN
yocoHsbAM9JmPMDgcWABCRCoKQKBgQDFjr7i/I49/Km4kC49nVSzC7vwzoqbgrgm
W+ImPRzMybYv7tMEOWO6tXzI0H91V3WVhLvGcTa7cqUhU9qo2lNHvw4uTMNghmve
WSTRcjb+wDR/uK4djbQN9aq0zxqxP52DZIkTg1AzbvNEcY6mWy8P1xWpNsf67mID
cSVPaBzk1QKBgQCpBDOOHMmNTYRSTct0y4Lx3+x8ff1dL8X3gV34XW38cNYZFyY+
+Rq29MA/nAlhaQmtcNY5hGbXdibHJz4eceu4wOm+jtPvSZCb5kUX4yP+WPMjqHZd
kaRZmPwrxjVTC57vfevaM1ijZgr06BMOP/MJi4qyW6AAEjQU79X7DMDa+QKBgGP+
wLf7xbOyc+WrdPxS6lBGHDbjFF1qaPNhhrJ8NFujrcfNRpnYwpX6ztKGVj16q1Wm
/bSQEXgHq3WXEBJvj7+9ANyGlk4BPBArZutsuFFx0CDlxZvH4d8+/czPF1+oJ34e
IRPzX2DpQ9Dc+atSdBu8boZb6BUnHA1J8+yhch6RAoGAZu1J9fqRkVXdPsPNtH/l
YbD/jwqglB6VCzLEjHHKBNNu4YnpSZN/wMNU7lWF0yjMajNGf3V1qghPu6xqqVj6
05xIC3C+PUQvYyiyFxKT0kDMLp4Bbxljr50aqYs/b22fx4iRq/BakJ7SyKdUZ9ei
p0weDMN6dQd5dKE+pUZYYpM=
-----END PRIVATE KEY-----
"""

SSL_TEST_PRIVATE_CA_CERT_AND_KEY_3: tuple[bytes, bytes] = (SSL_TEST_PRIVATE_CA_CRT, SSL_TEST_PRIVATE_CA_KEY)

SSL_TEST_NODE_CERTS_AND_KEYS_3: dict[str, dict[str, dict[str, bytes]]] = {
    "full_node": {
        "private": {"crt": SSL_TEST_FULLNODE_PRIVATE_CRT, "key": SSL_TEST_FULLNODE_PRIVATE_KEY},
        "public": {"crt": SSL_TEST_FULLNODE_PUBLIC_CRT, "key": SSL_TEST_FULLNODE_PUBLIC_KEY},
    },
    "wallet": {
        "private": {"crt": SSL_TEST_WALLET_PRIVATE_CRT, "key": SSL_TEST_WALLET_PRIVATE_KEY},
        "public": {"crt": SSL_TEST_WALLET_PUBLIC_CRT, "key": SSL_TEST_WALLET_PUBLIC_KEY},
    },
    "farmer": {
        "private": {"crt": SSL_TEST_FARMER_PRIVATE_CRT, "key": SSL_TEST_FARMER_PRIVATE_KEY},
        "public": {"crt": SSL_TEST_FARMER_PUBLIC_CRT, "key": SSL_TEST_FARMER_PUBLIC_KEY},
    },
    "harvester": {
        "private": {"crt": SSL_TEST_HARVESTER_PRIVATE_CRT, "key": SSL_TEST_HARVESTER_PRIVATE_KEY},
    },
    "timelord": {
        "private": {"crt": SSL_TEST_TIMELORD_PRIVATE_CRT, "key": SSL_TEST_TIMELORD_PRIVATE_KEY},
        "public": {"crt": SSL_TEST_TIMELORD_PUBLIC_CRT, "key": SSL_TEST_TIMELORD_PUBLIC_KEY},
    },
    "crawler": {
        "private": {"crt": SSL_TEST_CRAWLER_PRIVATE_CRT, "key": SSL_TEST_CRAWLER_PRIVATE_KEY},
    },
    "daemon": {
        "private": {"crt": SSL_TEST_DAEMON_PRIVATE_CRT, "key": SSL_TEST_DAEMON_PRIVATE_KEY},
    },
    "introducer": {
        "public": {"crt": SSL_TEST_INTRODUCER_PUBLIC_CRT, "key": SSL_TEST_INTRODUCER_PUBLIC_KEY},
    },
}
