"""
    PackageUtils.PyWin32Utils.py
"""

import os

def check_pywin32_postinstall():
    """
    This function checks if the pywin32 post-installation has been completed successfully.
    Generated by GitHub Copilot.
    """
    import site
    site_packages = site.getsitepackages()[1]
    pywin32_system32 = os.path.join(site_packages, 'pywin32_system32')
    pythoncom = [f for f in os.listdir(pywin32_system32) if f.startswith('pythoncom') and f.endswith('.dll')]
    pywintypes = [f for f in os.listdir(pywin32_system32) if f.startswith('pywintypes') and f.endswith('.dll')]
    pth_file = os.path.exists(os.path.join(site_packages, 'pywin32.pth'))
    return bool(pythoncom) and bool(pywintypes) and pth_file

if __name__ == "__main__":
    if check_pywin32_postinstall():
        print("pywin32_postinstall.py has been run successfully.")
    else:
        print("pywin32_postinstall.py has likely not been run or is incomplete.")