"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SecretManagerWrapperLayer = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const lambda = require("aws-cdk-lib/aws-lambda");
/**
 * An AWS SecretManager Wrapper layer that includes the AWS CLI, jq etc...
 */
class SecretManagerWrapperLayer extends lambda.LayerVersion {
    constructor(scope, id) {
        const image = aws_cdk_lib_1.DockerImage.fromBuild(path.join(__dirname, '../layer'));
        image.cp('/layer.zip', path.join(__dirname));
        const props = {
            removalPolicy: aws_cdk_lib_1.RemovalPolicy.DESTROY,
            code: lambda.Code.fromAsset(path.join(__dirname, 'layer.zip')),
            description: 'this layer has wrapper script help you setting secret manager json string into lambda runtime',
        };
        super(scope, id, props);
    }
    static getOrCreate(scope) {
        const stack = aws_cdk_lib_1.Stack.of(scope);
        const id = 'DenoLayer';
        const existing = stack.node.tryFindChild(id);
        return existing || new SecretManagerWrapperLayer(stack, id);
    }
}
exports.SecretManagerWrapperLayer = SecretManagerWrapperLayer;
_a = JSII_RTTI_SYMBOL_1;
SecretManagerWrapperLayer[_a] = { fqn: "cdk-secret-manager-wrapper-layer.SecretManagerWrapperLayer", version: "2.0.309" };
//# sourceMappingURL=data:application/json;base64,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