"""Vortexa endpoints."""

from vortexasdk.endpoints.asset_tanks import AssetTanks
from vortexasdk.endpoints.attributes import Attributes
from vortexasdk.endpoints.canal_transit import CanalTransit
from vortexasdk.endpoints.canal_transit_timeseries import (
    CanalTransitTimeseries,
)
from vortexasdk.endpoints.cargo_movements import CargoMovements
from vortexasdk.endpoints.cargo_timeseries import CargoTimeSeries
from vortexasdk.endpoints.corporations import Corporations
from vortexasdk.endpoints.geographies import Geographies
from vortexasdk.endpoints.products import Products
from vortexasdk.endpoints.vessels import Vessels
from vortexasdk.endpoints.storage_terminals import StorageTerminals
from vortexasdk.endpoints.vessel_availability_breakdown import (
    VesselAvailabilityBreakdown,
)
from vortexasdk.endpoints.vessel_availability_timeseries import (
    VesselAvailabilityTimeseries,
)
from vortexasdk.endpoints.vessel_availability_search import (
    VesselAvailabilitySearch,
)

from vortexasdk.endpoints.eia_forecasts import EIAForecasts
from vortexasdk.endpoints.origin_breakdown import OriginBreakdown
from vortexasdk.endpoints.destination_breakdown import DestinationBreakdown
from vortexasdk.endpoints.movement_status_breakdown import (
    MovementStatusBreakdown,
)
from vortexasdk.endpoints.vessel_class_breakdown import VesselClassBreakdown
from vortexasdk.endpoints.product_breakdown import ProductBreakdown
from vortexasdk.endpoints.parent_product_breakdown import (
    ParentProductBreakdown,
)
from vortexasdk.endpoints.onshore_inventories_timeseries import (
    OnshoreInventoriesTimeseries,
)
from vortexasdk.endpoints.onshore_inventories_search import (
    OnshoreInventoriesSearch,
)
from vortexasdk.endpoints.freight_pricing_search import FreightPricingSearch
from vortexasdk.endpoints.freight_pricing_timeseries import (
    FreightPricingTimeseries,
)
from vortexasdk.endpoints.voyages_timeseries import VoyagesTimeseries
from vortexasdk.endpoints.voyages_timeseries_v2 import VoyagesTimeseriesV2
from vortexasdk.endpoints.voyages_geography_breakdown import (
    VoyagesGeographyBreakdown,
)
from vortexasdk.endpoints.voyages_vessel_class_breakdown import (
    VoyagesVesselClassBreakdown,
)
from vortexasdk.endpoints.voyages_product_breakdown import (
    VoyagesProductBreakdown,
)
from vortexasdk.endpoints.voyages_routes_breakdown import (
    VoyagesRoutesBreakdown,
)
from vortexasdk.endpoints.voyages_congestion_breakdown import (
    VoyagesCongestionBreakdown,
)
from vortexasdk.endpoints.voyages_top_hits import VoyagesTopHits
from vortexasdk.endpoints.voyages_search_enriched import VoyagesSearchEnriched
from vortexasdk.endpoints.fixtures import Fixtures
from vortexasdk.endpoints.vessel_summary import VesselSummary
from vortexasdk.endpoints.vessel_positions import VesselPositions

from vortexasdk.endpoints.refineries import Refineries

# Explicitly list all exported classes, to help MyPy know what is available
__all__ = [
    "AssetTanks",
    "Attributes",
    "CanalTransit",
    "CanalTransitTimeseries",
    "CargoMovements",
    "CargoTimeSeries",
    "Corporations",
    "Geographies",
    "Products",
    "Vessels",
    "StorageTerminals",
    "VesselAvailabilityBreakdown",
    "VesselAvailabilityTimeseries",
    "VesselAvailabilitySearch",
    "EIAForecasts",
    "OriginBreakdown",
    "DestinationBreakdown",
    "MovementStatusBreakdown",
    "VesselClassBreakdown",
    "ProductBreakdown",
    "ParentProductBreakdown",
    "OnshoreInventoriesTimeseries",
    "OnshoreInventoriesSearch",
    "FreightPricingSearch",
    "FreightPricingTimeseries",
    "VoyagesTimeseries",
    "VoyagesTimeseriesV2",
    "VoyagesGeographyBreakdown",
    "VoyagesVesselClassBreakdown",
    "VoyagesProductBreakdown",
    "VoyagesRoutesBreakdown",
    "VoyagesCongestionBreakdown",
    "VoyagesTopHits",
    "VoyagesSearchEnriched",
    "Fixtures",
    "VesselSummary",
    "VesselPositions",
    "Refineries",
]
