import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AsConfigurationV1Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_configuration_v1#region AsConfigurationV1#region}
    */
    readonly region?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_configuration_v1#scaling_configuration_name AsConfigurationV1#scaling_configuration_name}
    */
    readonly scalingConfigurationName: string;
    /**
    * instance_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_configuration_v1#instance_config AsConfigurationV1#instance_config}
    */
    readonly instanceConfig: AsConfigurationV1InstanceConfig;
}
export interface AsConfigurationV1InstanceConfigDisk {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_configuration_v1#disk_type AsConfigurationV1#disk_type}
    */
    readonly diskType: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_configuration_v1#kms_id AsConfigurationV1#kms_id}
    */
    readonly kmsId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_configuration_v1#size AsConfigurationV1#size}
    */
    readonly size: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_configuration_v1#volume_type AsConfigurationV1#volume_type}
    */
    readonly volumeType: string;
}
export declare function asConfigurationV1InstanceConfigDiskToTerraform(struct?: AsConfigurationV1InstanceConfigDisk | cdktf.IResolvable): any;
export interface AsConfigurationV1InstanceConfigPersonality {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_configuration_v1#content AsConfigurationV1#content}
    */
    readonly content: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_configuration_v1#path AsConfigurationV1#path}
    */
    readonly path: string;
}
export declare function asConfigurationV1InstanceConfigPersonalityToTerraform(struct?: AsConfigurationV1InstanceConfigPersonality | cdktf.IResolvable): any;
export interface AsConfigurationV1InstanceConfigPublicIpEipBandwidth {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_configuration_v1#charging_mode AsConfigurationV1#charging_mode}
    */
    readonly chargingMode: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_configuration_v1#share_type AsConfigurationV1#share_type}
    */
    readonly shareType: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_configuration_v1#size AsConfigurationV1#size}
    */
    readonly size: number;
}
export declare function asConfigurationV1InstanceConfigPublicIpEipBandwidthToTerraform(struct?: AsConfigurationV1InstanceConfigPublicIpEipBandwidthOutputReference | AsConfigurationV1InstanceConfigPublicIpEipBandwidth): any;
export declare class AsConfigurationV1InstanceConfigPublicIpEipBandwidthOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): AsConfigurationV1InstanceConfigPublicIpEipBandwidth | undefined;
    set internalValue(value: AsConfigurationV1InstanceConfigPublicIpEipBandwidth | undefined);
    private _chargingMode?;
    get chargingMode(): string;
    set chargingMode(value: string);
    get chargingModeInput(): string | undefined;
    private _shareType?;
    get shareType(): string;
    set shareType(value: string);
    get shareTypeInput(): string | undefined;
    private _size?;
    get size(): number;
    set size(value: number);
    get sizeInput(): number | undefined;
}
export interface AsConfigurationV1InstanceConfigPublicIpEip {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_configuration_v1#ip_type AsConfigurationV1#ip_type}
    */
    readonly ipType: string;
    /**
    * bandwidth block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_configuration_v1#bandwidth AsConfigurationV1#bandwidth}
    */
    readonly bandwidth: AsConfigurationV1InstanceConfigPublicIpEipBandwidth;
}
export declare function asConfigurationV1InstanceConfigPublicIpEipToTerraform(struct?: AsConfigurationV1InstanceConfigPublicIpEipOutputReference | AsConfigurationV1InstanceConfigPublicIpEip): any;
export declare class AsConfigurationV1InstanceConfigPublicIpEipOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): AsConfigurationV1InstanceConfigPublicIpEip | undefined;
    set internalValue(value: AsConfigurationV1InstanceConfigPublicIpEip | undefined);
    private _ipType?;
    get ipType(): string;
    set ipType(value: string);
    get ipTypeInput(): string | undefined;
    private _bandwidth;
    get bandwidth(): AsConfigurationV1InstanceConfigPublicIpEipBandwidthOutputReference;
    putBandwidth(value: AsConfigurationV1InstanceConfigPublicIpEipBandwidth): void;
    get bandwidthInput(): AsConfigurationV1InstanceConfigPublicIpEipBandwidth | undefined;
}
export interface AsConfigurationV1InstanceConfigPublicIp {
    /**
    * eip block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_configuration_v1#eip AsConfigurationV1#eip}
    */
    readonly eip: AsConfigurationV1InstanceConfigPublicIpEip;
}
export declare function asConfigurationV1InstanceConfigPublicIpToTerraform(struct?: AsConfigurationV1InstanceConfigPublicIpOutputReference | AsConfigurationV1InstanceConfigPublicIp): any;
export declare class AsConfigurationV1InstanceConfigPublicIpOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): AsConfigurationV1InstanceConfigPublicIp | undefined;
    set internalValue(value: AsConfigurationV1InstanceConfigPublicIp | undefined);
    private _eip;
    get eip(): AsConfigurationV1InstanceConfigPublicIpEipOutputReference;
    putEip(value: AsConfigurationV1InstanceConfigPublicIpEip): void;
    get eipInput(): AsConfigurationV1InstanceConfigPublicIpEip | undefined;
}
export interface AsConfigurationV1InstanceConfig {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_configuration_v1#flavor AsConfigurationV1#flavor}
    */
    readonly flavor?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_configuration_v1#image AsConfigurationV1#image}
    */
    readonly image?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_configuration_v1#instance_id AsConfigurationV1#instance_id}
    */
    readonly instanceId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_configuration_v1#key_name AsConfigurationV1#key_name}
    */
    readonly keyName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_configuration_v1#metadata AsConfigurationV1#metadata}
    */
    readonly metadata?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_configuration_v1#security_groups AsConfigurationV1#security_groups}
    */
    readonly securityGroups?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_configuration_v1#user_data AsConfigurationV1#user_data}
    */
    readonly userData?: string;
    /**
    * disk block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_configuration_v1#disk AsConfigurationV1#disk}
    */
    readonly disk?: AsConfigurationV1InstanceConfigDisk[] | cdktf.IResolvable;
    /**
    * personality block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_configuration_v1#personality AsConfigurationV1#personality}
    */
    readonly personality?: AsConfigurationV1InstanceConfigPersonality[] | cdktf.IResolvable;
    /**
    * public_ip block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_configuration_v1#public_ip AsConfigurationV1#public_ip}
    */
    readonly publicIp?: AsConfigurationV1InstanceConfigPublicIp;
}
export declare function asConfigurationV1InstanceConfigToTerraform(struct?: AsConfigurationV1InstanceConfigOutputReference | AsConfigurationV1InstanceConfig): any;
export declare class AsConfigurationV1InstanceConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): AsConfigurationV1InstanceConfig | undefined;
    set internalValue(value: AsConfigurationV1InstanceConfig | undefined);
    private _flavor?;
    get flavor(): string;
    set flavor(value: string);
    resetFlavor(): void;
    get flavorInput(): string | undefined;
    private _image?;
    get image(): string;
    set image(value: string);
    resetImage(): void;
    get imageInput(): string | undefined;
    private _instanceId?;
    get instanceId(): string;
    set instanceId(value: string);
    resetInstanceId(): void;
    get instanceIdInput(): string | undefined;
    private _keyName?;
    get keyName(): string;
    set keyName(value: string);
    get keyNameInput(): string | undefined;
    private _metadata?;
    get metadata(): {
        [key: string]: string;
    };
    set metadata(value: {
        [key: string]: string;
    });
    resetMetadata(): void;
    get metadataInput(): {
        [key: string]: string;
    } | undefined;
    private _securityGroups?;
    get securityGroups(): string[];
    set securityGroups(value: string[]);
    resetSecurityGroups(): void;
    get securityGroupsInput(): string[] | undefined;
    private _userData?;
    get userData(): string;
    set userData(value: string);
    resetUserData(): void;
    get userDataInput(): string | undefined;
    private _disk?;
    get disk(): AsConfigurationV1InstanceConfigDisk[] | cdktf.IResolvable;
    set disk(value: AsConfigurationV1InstanceConfigDisk[] | cdktf.IResolvable);
    resetDisk(): void;
    get diskInput(): cdktf.IResolvable | AsConfigurationV1InstanceConfigDisk[] | undefined;
    private _personality?;
    get personality(): AsConfigurationV1InstanceConfigPersonality[] | cdktf.IResolvable;
    set personality(value: AsConfigurationV1InstanceConfigPersonality[] | cdktf.IResolvable);
    resetPersonality(): void;
    get personalityInput(): cdktf.IResolvable | AsConfigurationV1InstanceConfigPersonality[] | undefined;
    private _publicIp;
    get publicIp(): AsConfigurationV1InstanceConfigPublicIpOutputReference;
    putPublicIp(value: AsConfigurationV1InstanceConfigPublicIp): void;
    resetPublicIp(): void;
    get publicIpInput(): AsConfigurationV1InstanceConfigPublicIp | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_configuration_v1 opentelekomcloud_as_configuration_v1}
*/
export declare class AsConfigurationV1 extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_configuration_v1 opentelekomcloud_as_configuration_v1} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AsConfigurationV1Config
    */
    constructor(scope: Construct, id: string, config: AsConfigurationV1Config);
    get id(): string;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _scalingConfigurationName?;
    get scalingConfigurationName(): string;
    set scalingConfigurationName(value: string);
    get scalingConfigurationNameInput(): string | undefined;
    private _instanceConfig;
    get instanceConfig(): AsConfigurationV1InstanceConfigOutputReference;
    putInstanceConfig(value: AsConfigurationV1InstanceConfig): void;
    get instanceConfigInput(): AsConfigurationV1InstanceConfig | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
