import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AsPolicyV1Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_policy_v1#alarm_id AsPolicyV1#alarm_id}
    */
    readonly alarmId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_policy_v1#cool_down_time AsPolicyV1#cool_down_time}
    */
    readonly coolDownTime?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_policy_v1#region AsPolicyV1#region}
    */
    readonly region?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_policy_v1#scaling_group_id AsPolicyV1#scaling_group_id}
    */
    readonly scalingGroupId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_policy_v1#scaling_policy_name AsPolicyV1#scaling_policy_name}
    */
    readonly scalingPolicyName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_policy_v1#scaling_policy_type AsPolicyV1#scaling_policy_type}
    */
    readonly scalingPolicyType: string;
    /**
    * scaling_policy_action block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_policy_v1#scaling_policy_action AsPolicyV1#scaling_policy_action}
    */
    readonly scalingPolicyAction?: AsPolicyV1ScalingPolicyAction;
    /**
    * scheduled_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_policy_v1#scheduled_policy AsPolicyV1#scheduled_policy}
    */
    readonly scheduledPolicy?: AsPolicyV1ScheduledPolicy;
}
export interface AsPolicyV1ScalingPolicyAction {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_policy_v1#instance_number AsPolicyV1#instance_number}
    */
    readonly instanceNumber?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_policy_v1#operation AsPolicyV1#operation}
    */
    readonly operation?: string;
}
export declare function asPolicyV1ScalingPolicyActionToTerraform(struct?: AsPolicyV1ScalingPolicyActionOutputReference | AsPolicyV1ScalingPolicyAction): any;
export declare class AsPolicyV1ScalingPolicyActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): AsPolicyV1ScalingPolicyAction | undefined;
    set internalValue(value: AsPolicyV1ScalingPolicyAction | undefined);
    private _instanceNumber?;
    get instanceNumber(): number;
    set instanceNumber(value: number);
    resetInstanceNumber(): void;
    get instanceNumberInput(): number | undefined;
    private _operation?;
    get operation(): string;
    set operation(value: string);
    resetOperation(): void;
    get operationInput(): string | undefined;
}
export interface AsPolicyV1ScheduledPolicy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_policy_v1#end_time AsPolicyV1#end_time}
    */
    readonly endTime?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_policy_v1#launch_time AsPolicyV1#launch_time}
    */
    readonly launchTime: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_policy_v1#recurrence_type AsPolicyV1#recurrence_type}
    */
    readonly recurrenceType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_policy_v1#recurrence_value AsPolicyV1#recurrence_value}
    */
    readonly recurrenceValue?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_policy_v1#start_time AsPolicyV1#start_time}
    */
    readonly startTime?: string;
}
export declare function asPolicyV1ScheduledPolicyToTerraform(struct?: AsPolicyV1ScheduledPolicyOutputReference | AsPolicyV1ScheduledPolicy): any;
export declare class AsPolicyV1ScheduledPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): AsPolicyV1ScheduledPolicy | undefined;
    set internalValue(value: AsPolicyV1ScheduledPolicy | undefined);
    private _endTime?;
    get endTime(): string;
    set endTime(value: string);
    resetEndTime(): void;
    get endTimeInput(): string | undefined;
    private _launchTime?;
    get launchTime(): string;
    set launchTime(value: string);
    get launchTimeInput(): string | undefined;
    private _recurrenceType?;
    get recurrenceType(): string;
    set recurrenceType(value: string);
    resetRecurrenceType(): void;
    get recurrenceTypeInput(): string | undefined;
    private _recurrenceValue?;
    get recurrenceValue(): string;
    set recurrenceValue(value: string);
    resetRecurrenceValue(): void;
    get recurrenceValueInput(): string | undefined;
    private _startTime?;
    get startTime(): string;
    set startTime(value: string);
    resetStartTime(): void;
    get startTimeInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_policy_v1 opentelekomcloud_as_policy_v1}
*/
export declare class AsPolicyV1 extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_policy_v1 opentelekomcloud_as_policy_v1} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AsPolicyV1Config
    */
    constructor(scope: Construct, id: string, config: AsPolicyV1Config);
    private _alarmId?;
    get alarmId(): string;
    set alarmId(value: string);
    resetAlarmId(): void;
    get alarmIdInput(): string | undefined;
    private _coolDownTime?;
    get coolDownTime(): number;
    set coolDownTime(value: number);
    resetCoolDownTime(): void;
    get coolDownTimeInput(): number | undefined;
    get id(): string;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _scalingGroupId?;
    get scalingGroupId(): string;
    set scalingGroupId(value: string);
    get scalingGroupIdInput(): string | undefined;
    private _scalingPolicyName?;
    get scalingPolicyName(): string;
    set scalingPolicyName(value: string);
    get scalingPolicyNameInput(): string | undefined;
    private _scalingPolicyType?;
    get scalingPolicyType(): string;
    set scalingPolicyType(value: string);
    get scalingPolicyTypeInput(): string | undefined;
    private _scalingPolicyAction;
    get scalingPolicyAction(): AsPolicyV1ScalingPolicyActionOutputReference;
    putScalingPolicyAction(value: AsPolicyV1ScalingPolicyAction): void;
    resetScalingPolicyAction(): void;
    get scalingPolicyActionInput(): AsPolicyV1ScalingPolicyAction | undefined;
    private _scheduledPolicy;
    get scheduledPolicy(): AsPolicyV1ScheduledPolicyOutputReference;
    putScheduledPolicy(value: AsPolicyV1ScheduledPolicy): void;
    resetScheduledPolicy(): void;
    get scheduledPolicyInput(): AsPolicyV1ScheduledPolicy | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
