import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AsPolicyV2Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_policy_v2#alarm_id AsPolicyV2#alarm_id}
    */
    readonly alarmId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_policy_v2#cool_down_time AsPolicyV2#cool_down_time}
    */
    readonly coolDownTime?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_policy_v2#region AsPolicyV2#region}
    */
    readonly region?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_policy_v2#scaling_policy_name AsPolicyV2#scaling_policy_name}
    */
    readonly scalingPolicyName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_policy_v2#scaling_policy_type AsPolicyV2#scaling_policy_type}
    */
    readonly scalingPolicyType: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_policy_v2#scaling_resource_id AsPolicyV2#scaling_resource_id}
    */
    readonly scalingResourceId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_policy_v2#scaling_resource_type AsPolicyV2#scaling_resource_type}
    */
    readonly scalingResourceType: string;
    /**
    * scaling_policy_action block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_policy_v2#scaling_policy_action AsPolicyV2#scaling_policy_action}
    */
    readonly scalingPolicyAction?: AsPolicyV2ScalingPolicyAction[] | cdktf.IResolvable;
    /**
    * scheduled_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_policy_v2#scheduled_policy AsPolicyV2#scheduled_policy}
    */
    readonly scheduledPolicy?: AsPolicyV2ScheduledPolicy[] | cdktf.IResolvable;
}
export declare class AsPolicyV2Metadata extends cdktf.ComplexComputedList {
    get bandwidthShareType(): string;
    get eipAddress(): string;
    get eipId(): string;
}
export interface AsPolicyV2ScalingPolicyAction {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_policy_v2#limits AsPolicyV2#limits}
    */
    readonly limits?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_policy_v2#operation AsPolicyV2#operation}
    */
    readonly operation?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_policy_v2#percentage AsPolicyV2#percentage}
    */
    readonly percentage?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_policy_v2#size AsPolicyV2#size}
    */
    readonly size?: number;
}
export declare function asPolicyV2ScalingPolicyActionToTerraform(struct?: AsPolicyV2ScalingPolicyAction | cdktf.IResolvable): any;
export interface AsPolicyV2ScheduledPolicy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_policy_v2#end_time AsPolicyV2#end_time}
    */
    readonly endTime?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_policy_v2#launch_time AsPolicyV2#launch_time}
    */
    readonly launchTime: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_policy_v2#recurrence_type AsPolicyV2#recurrence_type}
    */
    readonly recurrenceType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_policy_v2#recurrence_value AsPolicyV2#recurrence_value}
    */
    readonly recurrenceValue?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_policy_v2#start_time AsPolicyV2#start_time}
    */
    readonly startTime?: string;
}
export declare function asPolicyV2ScheduledPolicyToTerraform(struct?: AsPolicyV2ScheduledPolicy | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_policy_v2 opentelekomcloud_as_policy_v2}
*/
export declare class AsPolicyV2 extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_policy_v2 opentelekomcloud_as_policy_v2} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AsPolicyV2Config
    */
    constructor(scope: Construct, id: string, config: AsPolicyV2Config);
    private _alarmId?;
    get alarmId(): string;
    set alarmId(value: string);
    resetAlarmId(): void;
    get alarmIdInput(): string | undefined;
    private _coolDownTime?;
    get coolDownTime(): number;
    set coolDownTime(value: number);
    resetCoolDownTime(): void;
    get coolDownTimeInput(): number | undefined;
    get createTime(): string;
    get id(): string;
    metadata(index: string): AsPolicyV2Metadata;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _scalingPolicyName?;
    get scalingPolicyName(): string;
    set scalingPolicyName(value: string);
    get scalingPolicyNameInput(): string | undefined;
    private _scalingPolicyType?;
    get scalingPolicyType(): string;
    set scalingPolicyType(value: string);
    get scalingPolicyTypeInput(): string | undefined;
    private _scalingResourceId?;
    get scalingResourceId(): string;
    set scalingResourceId(value: string);
    get scalingResourceIdInput(): string | undefined;
    private _scalingResourceType?;
    get scalingResourceType(): string;
    set scalingResourceType(value: string);
    get scalingResourceTypeInput(): string | undefined;
    private _scalingPolicyAction?;
    get scalingPolicyAction(): AsPolicyV2ScalingPolicyAction[] | cdktf.IResolvable;
    set scalingPolicyAction(value: AsPolicyV2ScalingPolicyAction[] | cdktf.IResolvable);
    resetScalingPolicyAction(): void;
    get scalingPolicyActionInput(): cdktf.IResolvable | AsPolicyV2ScalingPolicyAction[] | undefined;
    private _scheduledPolicy?;
    get scheduledPolicy(): AsPolicyV2ScheduledPolicy[] | cdktf.IResolvable;
    set scheduledPolicy(value: AsPolicyV2ScheduledPolicy[] | cdktf.IResolvable);
    resetScheduledPolicy(): void;
    get scheduledPolicyInput(): cdktf.IResolvable | AsPolicyV2ScheduledPolicy[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
