import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CbrPolicyV3Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cbr_policy_v3#enabled CbrPolicyV3#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cbr_policy_v3#name CbrPolicyV3#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cbr_policy_v3#operation_type CbrPolicyV3#operation_type}
    */
    readonly operationType: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cbr_policy_v3#trigger_pattern CbrPolicyV3#trigger_pattern}
    */
    readonly triggerPattern: string[];
    /**
    * operation_definition block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cbr_policy_v3#operation_definition CbrPolicyV3#operation_definition}
    */
    readonly operationDefinition?: CbrPolicyV3OperationDefinition;
}
export interface CbrPolicyV3OperationDefinition {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cbr_policy_v3#day_backups CbrPolicyV3#day_backups}
    */
    readonly dayBackups?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cbr_policy_v3#max_backups CbrPolicyV3#max_backups}
    */
    readonly maxBackups?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cbr_policy_v3#month_backups CbrPolicyV3#month_backups}
    */
    readonly monthBackups?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cbr_policy_v3#retention_duration_days CbrPolicyV3#retention_duration_days}
    */
    readonly retentionDurationDays?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cbr_policy_v3#timezone CbrPolicyV3#timezone}
    */
    readonly timezone: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cbr_policy_v3#week_backups CbrPolicyV3#week_backups}
    */
    readonly weekBackups?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cbr_policy_v3#year_backups CbrPolicyV3#year_backups}
    */
    readonly yearBackups?: number;
}
export declare function cbrPolicyV3OperationDefinitionToTerraform(struct?: CbrPolicyV3OperationDefinitionOutputReference | CbrPolicyV3OperationDefinition): any;
export declare class CbrPolicyV3OperationDefinitionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): CbrPolicyV3OperationDefinition | undefined;
    set internalValue(value: CbrPolicyV3OperationDefinition | undefined);
    private _dayBackups?;
    get dayBackups(): number;
    set dayBackups(value: number);
    resetDayBackups(): void;
    get dayBackupsInput(): number | undefined;
    private _maxBackups?;
    get maxBackups(): number;
    set maxBackups(value: number);
    resetMaxBackups(): void;
    get maxBackupsInput(): number | undefined;
    private _monthBackups?;
    get monthBackups(): number;
    set monthBackups(value: number);
    resetMonthBackups(): void;
    get monthBackupsInput(): number | undefined;
    private _retentionDurationDays?;
    get retentionDurationDays(): number;
    set retentionDurationDays(value: number);
    resetRetentionDurationDays(): void;
    get retentionDurationDaysInput(): number | undefined;
    private _timezone?;
    get timezone(): string;
    set timezone(value: string);
    get timezoneInput(): string | undefined;
    private _weekBackups?;
    get weekBackups(): number;
    set weekBackups(value: number);
    resetWeekBackups(): void;
    get weekBackupsInput(): number | undefined;
    private _yearBackups?;
    get yearBackups(): number;
    set yearBackups(value: number);
    resetYearBackups(): void;
    get yearBackupsInput(): number | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cbr_policy_v3 opentelekomcloud_cbr_policy_v3}
*/
export declare class CbrPolicyV3 extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cbr_policy_v3 opentelekomcloud_cbr_policy_v3} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CbrPolicyV3Config
    */
    constructor(scope: Construct, id: string, config: CbrPolicyV3Config);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _operationType?;
    get operationType(): string;
    set operationType(value: string);
    get operationTypeInput(): string | undefined;
    get region(): string;
    private _triggerPattern?;
    get triggerPattern(): string[];
    set triggerPattern(value: string[]);
    get triggerPatternInput(): string[] | undefined;
    private _operationDefinition;
    get operationDefinition(): CbrPolicyV3OperationDefinitionOutputReference;
    putOperationDefinition(value: CbrPolicyV3OperationDefinition): void;
    resetOperationDefinition(): void;
    get operationDefinitionInput(): CbrPolicyV3OperationDefinition | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
