import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CbrVaultV3Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cbr_vault_v3#auto_bind CbrVaultV3#auto_bind}
    */
    readonly autoBind?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cbr_vault_v3#auto_expand CbrVaultV3#auto_expand}
    */
    readonly autoExpand?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cbr_vault_v3#backup_policy_id CbrVaultV3#backup_policy_id}
    */
    readonly backupPolicyId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cbr_vault_v3#description CbrVaultV3#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cbr_vault_v3#enterprise_project_id CbrVaultV3#enterprise_project_id}
    */
    readonly enterpriseProjectId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cbr_vault_v3#name CbrVaultV3#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cbr_vault_v3#resource CbrVaultV3#resource}
    */
    readonly resource?: CbrVaultV3Resource[] | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cbr_vault_v3#tags CbrVaultV3#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * billing block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cbr_vault_v3#billing CbrVaultV3#billing}
    */
    readonly billing: CbrVaultV3Billing;
    /**
    * bind_rules block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cbr_vault_v3#bind_rules CbrVaultV3#bind_rules}
    */
    readonly bindRules?: CbrVaultV3BindRules[] | cdktf.IResolvable;
}
export interface CbrVaultV3Resource {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cbr_vault_v3#backup_count CbrVaultV3#backup_count}
    */
    readonly backupCount?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cbr_vault_v3#backup_size CbrVaultV3#backup_size}
    */
    readonly backupSize?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cbr_vault_v3#extra_info CbrVaultV3#extra_info}
    */
    readonly extraInfo?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cbr_vault_v3#id CbrVaultV3#id}
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cbr_vault_v3#name CbrVaultV3#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cbr_vault_v3#protect_status CbrVaultV3#protect_status}
    */
    readonly protectStatus?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cbr_vault_v3#size CbrVaultV3#size}
    */
    readonly size?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cbr_vault_v3#type CbrVaultV3#type}
    */
    readonly type?: string;
}
export declare function cbrVaultV3ResourceToTerraform(struct?: CbrVaultV3Resource | cdktf.IResolvable): any;
export interface CbrVaultV3Billing {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cbr_vault_v3#charging_mode CbrVaultV3#charging_mode}
    */
    readonly chargingMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cbr_vault_v3#cloud_type CbrVaultV3#cloud_type}
    */
    readonly cloudType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cbr_vault_v3#consistent_level CbrVaultV3#consistent_level}
    */
    readonly consistentLevel?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cbr_vault_v3#console_url CbrVaultV3#console_url}
    */
    readonly consoleUrl?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cbr_vault_v3#extra_info CbrVaultV3#extra_info}
    */
    readonly extraInfo?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cbr_vault_v3#is_auto_pay CbrVaultV3#is_auto_pay}
    */
    readonly isAutoPay?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cbr_vault_v3#is_auto_renew CbrVaultV3#is_auto_renew}
    */
    readonly isAutoRenew?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cbr_vault_v3#object_type CbrVaultV3#object_type}
    */
    readonly objectType: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cbr_vault_v3#period_num CbrVaultV3#period_num}
    */
    readonly periodNum?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cbr_vault_v3#period_type CbrVaultV3#period_type}
    */
    readonly periodType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cbr_vault_v3#protect_type CbrVaultV3#protect_type}
    */
    readonly protectType: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cbr_vault_v3#size CbrVaultV3#size}
    */
    readonly size: number;
}
export declare function cbrVaultV3BillingToTerraform(struct?: CbrVaultV3BillingOutputReference | CbrVaultV3Billing): any;
export declare class CbrVaultV3BillingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): CbrVaultV3Billing | undefined;
    set internalValue(value: CbrVaultV3Billing | undefined);
    get allocated(): number;
    private _chargingMode?;
    get chargingMode(): string;
    set chargingMode(value: string);
    resetChargingMode(): void;
    get chargingModeInput(): string | undefined;
    private _cloudType?;
    get cloudType(): string;
    set cloudType(value: string);
    resetCloudType(): void;
    get cloudTypeInput(): string | undefined;
    private _consistentLevel?;
    get consistentLevel(): string;
    set consistentLevel(value: string);
    resetConsistentLevel(): void;
    get consistentLevelInput(): string | undefined;
    private _consoleUrl?;
    get consoleUrl(): string;
    set consoleUrl(value: string);
    resetConsoleUrl(): void;
    get consoleUrlInput(): string | undefined;
    private _extraInfo?;
    get extraInfo(): {
        [key: string]: string;
    };
    set extraInfo(value: {
        [key: string]: string;
    });
    resetExtraInfo(): void;
    get extraInfoInput(): {
        [key: string]: string;
    } | undefined;
    get frozenScene(): string;
    private _isAutoPay?;
    get isAutoPay(): boolean | cdktf.IResolvable;
    set isAutoPay(value: boolean | cdktf.IResolvable);
    resetIsAutoPay(): void;
    get isAutoPayInput(): boolean | cdktf.IResolvable | undefined;
    private _isAutoRenew?;
    get isAutoRenew(): boolean | cdktf.IResolvable;
    set isAutoRenew(value: boolean | cdktf.IResolvable);
    resetIsAutoRenew(): void;
    get isAutoRenewInput(): boolean | cdktf.IResolvable | undefined;
    private _objectType?;
    get objectType(): string;
    set objectType(value: string);
    get objectTypeInput(): string | undefined;
    get orderId(): string;
    private _periodNum?;
    get periodNum(): number;
    set periodNum(value: number);
    resetPeriodNum(): void;
    get periodNumInput(): number | undefined;
    private _periodType?;
    get periodType(): string;
    set periodType(value: string);
    resetPeriodType(): void;
    get periodTypeInput(): string | undefined;
    get productId(): string;
    private _protectType?;
    get protectType(): string;
    set protectType(value: string);
    get protectTypeInput(): string | undefined;
    private _size?;
    get size(): number;
    set size(value: number);
    get sizeInput(): number | undefined;
    get specCode(): string;
    get status(): string;
    get storageUnit(): string;
    get used(): number;
}
export interface CbrVaultV3BindRules {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cbr_vault_v3#key CbrVaultV3#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cbr_vault_v3#value CbrVaultV3#value}
    */
    readonly value: string;
}
export declare function cbrVaultV3BindRulesToTerraform(struct?: CbrVaultV3BindRules | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cbr_vault_v3 opentelekomcloud_cbr_vault_v3}
*/
export declare class CbrVaultV3 extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cbr_vault_v3 opentelekomcloud_cbr_vault_v3} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CbrVaultV3Config
    */
    constructor(scope: Construct, id: string, config: CbrVaultV3Config);
    private _autoBind?;
    get autoBind(): boolean | cdktf.IResolvable;
    set autoBind(value: boolean | cdktf.IResolvable);
    resetAutoBind(): void;
    get autoBindInput(): boolean | cdktf.IResolvable | undefined;
    private _autoExpand?;
    get autoExpand(): boolean | cdktf.IResolvable;
    set autoExpand(value: boolean | cdktf.IResolvable);
    resetAutoExpand(): void;
    get autoExpandInput(): boolean | cdktf.IResolvable | undefined;
    private _backupPolicyId?;
    get backupPolicyId(): string;
    set backupPolicyId(value: string);
    resetBackupPolicyId(): void;
    get backupPolicyIdInput(): string | undefined;
    get createdAt(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _enterpriseProjectId?;
    get enterpriseProjectId(): string;
    set enterpriseProjectId(value: string);
    resetEnterpriseProjectId(): void;
    get enterpriseProjectIdInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get projectId(): string;
    get providerId(): string;
    private _resource?;
    get resource(): CbrVaultV3Resource[] | cdktf.IResolvable;
    set resource(value: CbrVaultV3Resource[] | cdktf.IResolvable);
    resetResource(): void;
    get resourceInput(): cdktf.IResolvable | CbrVaultV3Resource[] | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    get userId(): string;
    private _billing;
    get billing(): CbrVaultV3BillingOutputReference;
    putBilling(value: CbrVaultV3Billing): void;
    get billingInput(): CbrVaultV3Billing | undefined;
    private _bindRules?;
    get bindRules(): CbrVaultV3BindRules[] | cdktf.IResolvable;
    set bindRules(value: CbrVaultV3BindRules[] | cdktf.IResolvable);
    resetBindRules(): void;
    get bindRulesInput(): cdktf.IResolvable | CbrVaultV3BindRules[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
