import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CceAddonV3Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_addon_v3#cluster_id CceAddonV3#cluster_id}
    */
    readonly clusterId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_addon_v3#template_name CceAddonV3#template_name}
    */
    readonly templateName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_addon_v3#template_version CceAddonV3#template_version}
    */
    readonly templateVersion: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_addon_v3#timeouts CceAddonV3#timeouts}
    */
    readonly timeouts?: CceAddonV3Timeouts;
    /**
    * values block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_addon_v3#values CceAddonV3#values}
    */
    readonly values: CceAddonV3Values;
}
export interface CceAddonV3Timeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_addon_v3#delete CceAddonV3#delete}
    */
    readonly delete?: string;
}
export declare function cceAddonV3TimeoutsToTerraform(struct?: CceAddonV3TimeoutsOutputReference | CceAddonV3Timeouts | cdktf.IResolvable): any;
export declare class CceAddonV3TimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): CceAddonV3Timeouts | undefined;
    set internalValue(value: CceAddonV3Timeouts | undefined);
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
export interface CceAddonV3Values {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_addon_v3#basic CceAddonV3#basic}
    */
    readonly basic: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_addon_v3#custom CceAddonV3#custom}
    */
    readonly custom: {
        [key: string]: string;
    };
}
export declare function cceAddonV3ValuesToTerraform(struct?: CceAddonV3ValuesOutputReference | CceAddonV3Values): any;
export declare class CceAddonV3ValuesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): CceAddonV3Values | undefined;
    set internalValue(value: CceAddonV3Values | undefined);
    private _basic?;
    get basic(): {
        [key: string]: string;
    };
    set basic(value: {
        [key: string]: string;
    });
    get basicInput(): {
        [key: string]: string;
    } | undefined;
    private _custom?;
    get custom(): {
        [key: string]: string;
    };
    set custom(value: {
        [key: string]: string;
    });
    get customInput(): {
        [key: string]: string;
    } | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_addon_v3 opentelekomcloud_cce_addon_v3}
*/
export declare class CceAddonV3 extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_addon_v3 opentelekomcloud_cce_addon_v3} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CceAddonV3Config
    */
    constructor(scope: Construct, id: string, config: CceAddonV3Config);
    private _clusterId?;
    get clusterId(): string;
    set clusterId(value: string);
    get clusterIdInput(): string | undefined;
    get description(): string;
    get id(): string;
    get name(): string;
    private _templateName?;
    get templateName(): string;
    set templateName(value: string);
    get templateNameInput(): string | undefined;
    private _templateVersion?;
    get templateVersion(): string;
    set templateVersion(value: string);
    get templateVersionInput(): string | undefined;
    private _timeouts;
    get timeouts(): CceAddonV3TimeoutsOutputReference;
    putTimeouts(value: CceAddonV3Timeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): CceAddonV3Timeouts | undefined;
    private _values;
    get values(): CceAddonV3ValuesOutputReference;
    putValues(value: CceAddonV3Values): void;
    get valuesInput(): CceAddonV3Values | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
