import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CceNodePoolV3Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_pool_v3#availability_zone CceNodePoolV3#availability_zone}
    */
    readonly availabilityZone?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_pool_v3#cluster_id CceNodePoolV3#cluster_id}
    */
    readonly clusterId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_pool_v3#docker_base_size CceNodePoolV3#docker_base_size}
    */
    readonly dockerBaseSize?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_pool_v3#docker_lvm_config_override CceNodePoolV3#docker_lvm_config_override}
    */
    readonly dockerLvmConfigOverride?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_pool_v3#flavor CceNodePoolV3#flavor}
    */
    readonly flavor: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_pool_v3#initial_node_count CceNodePoolV3#initial_node_count}
    */
    readonly initialNodeCount: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_pool_v3#k8s_tags CceNodePoolV3#k8s_tags}
    */
    readonly k8STags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_pool_v3#key_pair CceNodePoolV3#key_pair}
    */
    readonly keyPair?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_pool_v3#max_node_count CceNodePoolV3#max_node_count}
    */
    readonly maxNodeCount?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_pool_v3#max_pods CceNodePoolV3#max_pods}
    */
    readonly maxPods?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_pool_v3#min_node_count CceNodePoolV3#min_node_count}
    */
    readonly minNodeCount?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_pool_v3#name CceNodePoolV3#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_pool_v3#os CceNodePoolV3#os}
    */
    readonly os?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_pool_v3#password CceNodePoolV3#password}
    */
    readonly password?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_pool_v3#postinstall CceNodePoolV3#postinstall}
    */
    readonly postinstall?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_pool_v3#preinstall CceNodePoolV3#preinstall}
    */
    readonly preinstall?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_pool_v3#priority CceNodePoolV3#priority}
    */
    readonly priority?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_pool_v3#scale_down_cooldown_time CceNodePoolV3#scale_down_cooldown_time}
    */
    readonly scaleDownCooldownTime?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_pool_v3#scale_enable CceNodePoolV3#scale_enable}
    */
    readonly scaleEnable?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_pool_v3#server_group_reference CceNodePoolV3#server_group_reference}
    */
    readonly serverGroupReference?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_pool_v3#subnet_id CceNodePoolV3#subnet_id}
    */
    readonly subnetId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_pool_v3#user_tags CceNodePoolV3#user_tags}
    */
    readonly userTags?: {
        [key: string]: string;
    };
    /**
    * data_volumes block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_pool_v3#data_volumes CceNodePoolV3#data_volumes}
    */
    readonly dataVolumes: CceNodePoolV3DataVolumes[] | cdktf.IResolvable;
    /**
    * root_volume block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_pool_v3#root_volume CceNodePoolV3#root_volume}
    */
    readonly rootVolume: CceNodePoolV3RootVolume;
    /**
    * taints block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_pool_v3#taints CceNodePoolV3#taints}
    */
    readonly taints?: CceNodePoolV3Taints[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_pool_v3#timeouts CceNodePoolV3#timeouts}
    */
    readonly timeouts?: CceNodePoolV3Timeouts;
}
export interface CceNodePoolV3DataVolumes {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_pool_v3#extend_param CceNodePoolV3#extend_param}
    */
    readonly extendParam?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_pool_v3#kms_id CceNodePoolV3#kms_id}
    */
    readonly kmsId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_pool_v3#size CceNodePoolV3#size}
    */
    readonly size: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_pool_v3#volumetype CceNodePoolV3#volumetype}
    */
    readonly volumetype: string;
}
export declare function cceNodePoolV3DataVolumesToTerraform(struct?: CceNodePoolV3DataVolumes | cdktf.IResolvable): any;
export interface CceNodePoolV3RootVolume {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_pool_v3#extend_param CceNodePoolV3#extend_param}
    */
    readonly extendParam?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_pool_v3#size CceNodePoolV3#size}
    */
    readonly size: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_pool_v3#volumetype CceNodePoolV3#volumetype}
    */
    readonly volumetype: string;
}
export declare function cceNodePoolV3RootVolumeToTerraform(struct?: CceNodePoolV3RootVolumeOutputReference | CceNodePoolV3RootVolume): any;
export declare class CceNodePoolV3RootVolumeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): CceNodePoolV3RootVolume | undefined;
    set internalValue(value: CceNodePoolV3RootVolume | undefined);
    private _extendParam?;
    get extendParam(): string;
    set extendParam(value: string);
    resetExtendParam(): void;
    get extendParamInput(): string | undefined;
    private _size?;
    get size(): number;
    set size(value: number);
    get sizeInput(): number | undefined;
    private _volumetype?;
    get volumetype(): string;
    set volumetype(value: string);
    get volumetypeInput(): string | undefined;
}
export interface CceNodePoolV3Taints {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_pool_v3#effect CceNodePoolV3#effect}
    */
    readonly effect: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_pool_v3#key CceNodePoolV3#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_pool_v3#value CceNodePoolV3#value}
    */
    readonly value: string;
}
export declare function cceNodePoolV3TaintsToTerraform(struct?: CceNodePoolV3Taints | cdktf.IResolvable): any;
export interface CceNodePoolV3Timeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_pool_v3#create CceNodePoolV3#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_pool_v3#default CceNodePoolV3#default}
    */
    readonly default?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_pool_v3#delete CceNodePoolV3#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_pool_v3#update CceNodePoolV3#update}
    */
    readonly update?: string;
}
export declare function cceNodePoolV3TimeoutsToTerraform(struct?: CceNodePoolV3TimeoutsOutputReference | CceNodePoolV3Timeouts | cdktf.IResolvable): any;
export declare class CceNodePoolV3TimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): CceNodePoolV3Timeouts | undefined;
    set internalValue(value: CceNodePoolV3Timeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _default?;
    get default(): string;
    set default(value: string);
    resetDefault(): void;
    get defaultInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_pool_v3 opentelekomcloud_cce_node_pool_v3}
*/
export declare class CceNodePoolV3 extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_pool_v3 opentelekomcloud_cce_node_pool_v3} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CceNodePoolV3Config
    */
    constructor(scope: Construct, id: string, config: CceNodePoolV3Config);
    private _availabilityZone?;
    get availabilityZone(): string;
    set availabilityZone(value: string);
    resetAvailabilityZone(): void;
    get availabilityZoneInput(): string | undefined;
    private _clusterId?;
    get clusterId(): string;
    set clusterId(value: string);
    get clusterIdInput(): string | undefined;
    private _dockerBaseSize?;
    get dockerBaseSize(): number;
    set dockerBaseSize(value: number);
    resetDockerBaseSize(): void;
    get dockerBaseSizeInput(): number | undefined;
    private _dockerLvmConfigOverride?;
    get dockerLvmConfigOverride(): string;
    set dockerLvmConfigOverride(value: string);
    resetDockerLvmConfigOverride(): void;
    get dockerLvmConfigOverrideInput(): string | undefined;
    private _flavor?;
    get flavor(): string;
    set flavor(value: string);
    get flavorInput(): string | undefined;
    get id(): string;
    private _initialNodeCount?;
    get initialNodeCount(): number;
    set initialNodeCount(value: number);
    get initialNodeCountInput(): number | undefined;
    private _k8STags?;
    get k8STags(): {
        [key: string]: string;
    };
    set k8STags(value: {
        [key: string]: string;
    });
    resetK8STags(): void;
    get k8STagsInput(): {
        [key: string]: string;
    } | undefined;
    private _keyPair?;
    get keyPair(): string;
    set keyPair(value: string);
    resetKeyPair(): void;
    get keyPairInput(): string | undefined;
    private _maxNodeCount?;
    get maxNodeCount(): number;
    set maxNodeCount(value: number);
    resetMaxNodeCount(): void;
    get maxNodeCountInput(): number | undefined;
    private _maxPods?;
    get maxPods(): number;
    set maxPods(value: number);
    resetMaxPods(): void;
    get maxPodsInput(): number | undefined;
    private _minNodeCount?;
    get minNodeCount(): number;
    set minNodeCount(value: number);
    resetMinNodeCount(): void;
    get minNodeCountInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _os?;
    get os(): string;
    set os(value: string);
    resetOs(): void;
    get osInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _postinstall?;
    get postinstall(): string;
    set postinstall(value: string);
    resetPostinstall(): void;
    get postinstallInput(): string | undefined;
    private _preinstall?;
    get preinstall(): string;
    set preinstall(value: string);
    resetPreinstall(): void;
    get preinstallInput(): string | undefined;
    private _priority?;
    get priority(): number;
    set priority(value: number);
    resetPriority(): void;
    get priorityInput(): number | undefined;
    private _scaleDownCooldownTime?;
    get scaleDownCooldownTime(): number;
    set scaleDownCooldownTime(value: number);
    resetScaleDownCooldownTime(): void;
    get scaleDownCooldownTimeInput(): number | undefined;
    private _scaleEnable?;
    get scaleEnable(): boolean | cdktf.IResolvable;
    set scaleEnable(value: boolean | cdktf.IResolvable);
    resetScaleEnable(): void;
    get scaleEnableInput(): boolean | cdktf.IResolvable | undefined;
    private _serverGroupReference?;
    get serverGroupReference(): string;
    set serverGroupReference(value: string);
    resetServerGroupReference(): void;
    get serverGroupReferenceInput(): string | undefined;
    get status(): string;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    resetSubnetId(): void;
    get subnetIdInput(): string | undefined;
    private _userTags?;
    get userTags(): {
        [key: string]: string;
    };
    set userTags(value: {
        [key: string]: string;
    });
    resetUserTags(): void;
    get userTagsInput(): {
        [key: string]: string;
    } | undefined;
    private _dataVolumes?;
    get dataVolumes(): CceNodePoolV3DataVolumes[] | cdktf.IResolvable;
    set dataVolumes(value: CceNodePoolV3DataVolumes[] | cdktf.IResolvable);
    get dataVolumesInput(): cdktf.IResolvable | CceNodePoolV3DataVolumes[] | undefined;
    private _rootVolume;
    get rootVolume(): CceNodePoolV3RootVolumeOutputReference;
    putRootVolume(value: CceNodePoolV3RootVolume): void;
    get rootVolumeInput(): CceNodePoolV3RootVolume | undefined;
    private _taints?;
    get taints(): CceNodePoolV3Taints[] | cdktf.IResolvable;
    set taints(value: CceNodePoolV3Taints[] | cdktf.IResolvable);
    resetTaints(): void;
    get taintsInput(): cdktf.IResolvable | CceNodePoolV3Taints[] | undefined;
    private _timeouts;
    get timeouts(): CceNodePoolV3TimeoutsOutputReference;
    putTimeouts(value: CceNodePoolV3Timeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): CceNodePoolV3Timeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
