import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CesAlarmruleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ces_alarmrule#alarm_action_enabled CesAlarmrule#alarm_action_enabled}
    */
    readonly alarmActionEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ces_alarmrule#alarm_description CesAlarmrule#alarm_description}
    */
    readonly alarmDescription?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ces_alarmrule#alarm_enabled CesAlarmrule#alarm_enabled}
    */
    readonly alarmEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ces_alarmrule#alarm_level CesAlarmrule#alarm_level}
    */
    readonly alarmLevel?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ces_alarmrule#alarm_name CesAlarmrule#alarm_name}
    */
    readonly alarmName: string;
    /**
    * alarm_actions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ces_alarmrule#alarm_actions CesAlarmrule#alarm_actions}
    */
    readonly alarmActions?: CesAlarmruleAlarmActions[] | cdktf.IResolvable;
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ces_alarmrule#condition CesAlarmrule#condition}
    */
    readonly condition: CesAlarmruleCondition;
    /**
    * insufficientdata_actions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ces_alarmrule#insufficientdata_actions CesAlarmrule#insufficientdata_actions}
    */
    readonly insufficientdataActions?: CesAlarmruleInsufficientdataActions[] | cdktf.IResolvable;
    /**
    * metric block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ces_alarmrule#metric CesAlarmrule#metric}
    */
    readonly metric: CesAlarmruleMetric;
    /**
    * ok_actions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ces_alarmrule#ok_actions CesAlarmrule#ok_actions}
    */
    readonly okActions?: CesAlarmruleOkActions[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ces_alarmrule#timeouts CesAlarmrule#timeouts}
    */
    readonly timeouts?: CesAlarmruleTimeouts;
}
export interface CesAlarmruleAlarmActions {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ces_alarmrule#notification_list CesAlarmrule#notification_list}
    */
    readonly notificationList: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ces_alarmrule#type CesAlarmrule#type}
    */
    readonly type: string;
}
export declare function cesAlarmruleAlarmActionsToTerraform(struct?: CesAlarmruleAlarmActions | cdktf.IResolvable): any;
export interface CesAlarmruleCondition {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ces_alarmrule#comparison_operator CesAlarmrule#comparison_operator}
    */
    readonly comparisonOperator: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ces_alarmrule#count CesAlarmrule#count}
    */
    readonly count: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ces_alarmrule#filter CesAlarmrule#filter}
    */
    readonly filter: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ces_alarmrule#period CesAlarmrule#period}
    */
    readonly period: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ces_alarmrule#unit CesAlarmrule#unit}
    */
    readonly unit?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ces_alarmrule#value CesAlarmrule#value}
    */
    readonly value: number;
}
export declare function cesAlarmruleConditionToTerraform(struct?: CesAlarmruleConditionOutputReference | CesAlarmruleCondition): any;
export declare class CesAlarmruleConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): CesAlarmruleCondition | undefined;
    set internalValue(value: CesAlarmruleCondition | undefined);
    private _comparisonOperator?;
    get comparisonOperator(): string;
    set comparisonOperator(value: string);
    get comparisonOperatorInput(): string | undefined;
    private _count?;
    get count(): number;
    set count(value: number);
    get countInput(): number | undefined;
    private _filter?;
    get filter(): string;
    set filter(value: string);
    get filterInput(): string | undefined;
    private _period?;
    get period(): number;
    set period(value: number);
    get periodInput(): number | undefined;
    private _unit?;
    get unit(): string;
    set unit(value: string);
    resetUnit(): void;
    get unitInput(): string | undefined;
    private _value?;
    get value(): number;
    set value(value: number);
    get valueInput(): number | undefined;
}
export interface CesAlarmruleInsufficientdataActions {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ces_alarmrule#notification_list CesAlarmrule#notification_list}
    */
    readonly notificationList: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ces_alarmrule#type CesAlarmrule#type}
    */
    readonly type: string;
}
export declare function cesAlarmruleInsufficientdataActionsToTerraform(struct?: CesAlarmruleInsufficientdataActions | cdktf.IResolvable): any;
export interface CesAlarmruleMetricDimensions {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ces_alarmrule#name CesAlarmrule#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ces_alarmrule#value CesAlarmrule#value}
    */
    readonly value: string;
}
export declare function cesAlarmruleMetricDimensionsToTerraform(struct?: CesAlarmruleMetricDimensions | cdktf.IResolvable): any;
export interface CesAlarmruleMetric {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ces_alarmrule#metric_name CesAlarmrule#metric_name}
    */
    readonly metricName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ces_alarmrule#namespace CesAlarmrule#namespace}
    */
    readonly namespace: string;
    /**
    * dimensions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ces_alarmrule#dimensions CesAlarmrule#dimensions}
    */
    readonly dimensions: CesAlarmruleMetricDimensions[] | cdktf.IResolvable;
}
export declare function cesAlarmruleMetricToTerraform(struct?: CesAlarmruleMetricOutputReference | CesAlarmruleMetric): any;
export declare class CesAlarmruleMetricOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): CesAlarmruleMetric | undefined;
    set internalValue(value: CesAlarmruleMetric | undefined);
    private _metricName?;
    get metricName(): string;
    set metricName(value: string);
    get metricNameInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    get namespaceInput(): string | undefined;
    private _dimensions?;
    get dimensions(): CesAlarmruleMetricDimensions[] | cdktf.IResolvable;
    set dimensions(value: CesAlarmruleMetricDimensions[] | cdktf.IResolvable);
    get dimensionsInput(): cdktf.IResolvable | CesAlarmruleMetricDimensions[] | undefined;
}
export interface CesAlarmruleOkActions {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ces_alarmrule#notification_list CesAlarmrule#notification_list}
    */
    readonly notificationList: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ces_alarmrule#type CesAlarmrule#type}
    */
    readonly type: string;
}
export declare function cesAlarmruleOkActionsToTerraform(struct?: CesAlarmruleOkActions | cdktf.IResolvable): any;
export interface CesAlarmruleTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ces_alarmrule#create CesAlarmrule#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ces_alarmrule#delete CesAlarmrule#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ces_alarmrule#update CesAlarmrule#update}
    */
    readonly update?: string;
}
export declare function cesAlarmruleTimeoutsToTerraform(struct?: CesAlarmruleTimeoutsOutputReference | CesAlarmruleTimeouts | cdktf.IResolvable): any;
export declare class CesAlarmruleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): CesAlarmruleTimeouts | undefined;
    set internalValue(value: CesAlarmruleTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ces_alarmrule opentelekomcloud_ces_alarmrule}
*/
export declare class CesAlarmrule extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ces_alarmrule opentelekomcloud_ces_alarmrule} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CesAlarmruleConfig
    */
    constructor(scope: Construct, id: string, config: CesAlarmruleConfig);
    private _alarmActionEnabled?;
    get alarmActionEnabled(): boolean | cdktf.IResolvable;
    set alarmActionEnabled(value: boolean | cdktf.IResolvable);
    resetAlarmActionEnabled(): void;
    get alarmActionEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _alarmDescription?;
    get alarmDescription(): string;
    set alarmDescription(value: string);
    resetAlarmDescription(): void;
    get alarmDescriptionInput(): string | undefined;
    private _alarmEnabled?;
    get alarmEnabled(): boolean | cdktf.IResolvable;
    set alarmEnabled(value: boolean | cdktf.IResolvable);
    resetAlarmEnabled(): void;
    get alarmEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _alarmLevel?;
    get alarmLevel(): number;
    set alarmLevel(value: number);
    resetAlarmLevel(): void;
    get alarmLevelInput(): number | undefined;
    private _alarmName?;
    get alarmName(): string;
    set alarmName(value: string);
    get alarmNameInput(): string | undefined;
    get alarmState(): string;
    get id(): string;
    get updateTime(): number;
    private _alarmActions?;
    get alarmActions(): CesAlarmruleAlarmActions[] | cdktf.IResolvable;
    set alarmActions(value: CesAlarmruleAlarmActions[] | cdktf.IResolvable);
    resetAlarmActions(): void;
    get alarmActionsInput(): cdktf.IResolvable | CesAlarmruleAlarmActions[] | undefined;
    private _condition;
    get condition(): CesAlarmruleConditionOutputReference;
    putCondition(value: CesAlarmruleCondition): void;
    get conditionInput(): CesAlarmruleCondition | undefined;
    private _insufficientdataActions?;
    get insufficientdataActions(): CesAlarmruleInsufficientdataActions[] | cdktf.IResolvable;
    set insufficientdataActions(value: CesAlarmruleInsufficientdataActions[] | cdktf.IResolvable);
    resetInsufficientdataActions(): void;
    get insufficientdataActionsInput(): cdktf.IResolvable | CesAlarmruleInsufficientdataActions[] | undefined;
    private _metric;
    get metric(): CesAlarmruleMetricOutputReference;
    putMetric(value: CesAlarmruleMetric): void;
    get metricInput(): CesAlarmruleMetric | undefined;
    private _okActions?;
    get okActions(): CesAlarmruleOkActions[] | cdktf.IResolvable;
    set okActions(value: CesAlarmruleOkActions[] | cdktf.IResolvable);
    resetOkActions(): void;
    get okActionsInput(): cdktf.IResolvable | CesAlarmruleOkActions[] | undefined;
    private _timeouts;
    get timeouts(): CesAlarmruleTimeoutsOutputReference;
    putTimeouts(value: CesAlarmruleTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): CesAlarmruleTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
