import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeBmsServerV2Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_bms_server_v2#admin_pass ComputeBmsServerV2#admin_pass}
    */
    readonly adminPass?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_bms_server_v2#availability_zone ComputeBmsServerV2#availability_zone}
    */
    readonly availabilityZone: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_bms_server_v2#flavor_id ComputeBmsServerV2#flavor_id}
    */
    readonly flavorId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_bms_server_v2#flavor_name ComputeBmsServerV2#flavor_name}
    */
    readonly flavorName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_bms_server_v2#image_id ComputeBmsServerV2#image_id}
    */
    readonly imageId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_bms_server_v2#image_name ComputeBmsServerV2#image_name}
    */
    readonly imageName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_bms_server_v2#key_pair ComputeBmsServerV2#key_pair}
    */
    readonly keyPair?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_bms_server_v2#metadata ComputeBmsServerV2#metadata}
    */
    readonly metadata?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_bms_server_v2#name ComputeBmsServerV2#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_bms_server_v2#region ComputeBmsServerV2#region}
    */
    readonly region?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_bms_server_v2#security_groups ComputeBmsServerV2#security_groups}
    */
    readonly securityGroups?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_bms_server_v2#stop_before_destroy ComputeBmsServerV2#stop_before_destroy}
    */
    readonly stopBeforeDestroy?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_bms_server_v2#tags ComputeBmsServerV2#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_bms_server_v2#user_data ComputeBmsServerV2#user_data}
    */
    readonly userData?: string;
    /**
    * block_device block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_bms_server_v2#block_device ComputeBmsServerV2#block_device}
    */
    readonly blockDevice?: ComputeBmsServerV2BlockDevice[] | cdktf.IResolvable;
    /**
    * network block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_bms_server_v2#network ComputeBmsServerV2#network}
    */
    readonly network?: ComputeBmsServerV2Network[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_bms_server_v2#timeouts ComputeBmsServerV2#timeouts}
    */
    readonly timeouts?: ComputeBmsServerV2Timeouts;
}
export interface ComputeBmsServerV2BlockDevice {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_bms_server_v2#boot_index ComputeBmsServerV2#boot_index}
    */
    readonly bootIndex?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_bms_server_v2#delete_on_termination ComputeBmsServerV2#delete_on_termination}
    */
    readonly deleteOnTermination?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_bms_server_v2#destination_type ComputeBmsServerV2#destination_type}
    */
    readonly destinationType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_bms_server_v2#device_name ComputeBmsServerV2#device_name}
    */
    readonly deviceName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_bms_server_v2#guest_format ComputeBmsServerV2#guest_format}
    */
    readonly guestFormat?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_bms_server_v2#source_type ComputeBmsServerV2#source_type}
    */
    readonly sourceType: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_bms_server_v2#uuid ComputeBmsServerV2#uuid}
    */
    readonly uuid?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_bms_server_v2#volume_size ComputeBmsServerV2#volume_size}
    */
    readonly volumeSize?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_bms_server_v2#volume_type ComputeBmsServerV2#volume_type}
    */
    readonly volumeType?: string;
}
export declare function computeBmsServerV2BlockDeviceToTerraform(struct?: ComputeBmsServerV2BlockDevice | cdktf.IResolvable): any;
export interface ComputeBmsServerV2Network {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_bms_server_v2#access_network ComputeBmsServerV2#access_network}
    */
    readonly accessNetwork?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_bms_server_v2#fixed_ip_v4 ComputeBmsServerV2#fixed_ip_v4}
    */
    readonly fixedIpV4?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_bms_server_v2#fixed_ip_v6 ComputeBmsServerV2#fixed_ip_v6}
    */
    readonly fixedIpV6?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_bms_server_v2#name ComputeBmsServerV2#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_bms_server_v2#port ComputeBmsServerV2#port}
    */
    readonly port?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_bms_server_v2#uuid ComputeBmsServerV2#uuid}
    */
    readonly uuid?: string;
}
export declare function computeBmsServerV2NetworkToTerraform(struct?: ComputeBmsServerV2Network | cdktf.IResolvable): any;
export interface ComputeBmsServerV2Timeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_bms_server_v2#create ComputeBmsServerV2#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_bms_server_v2#delete ComputeBmsServerV2#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_bms_server_v2#update ComputeBmsServerV2#update}
    */
    readonly update?: string;
}
export declare function computeBmsServerV2TimeoutsToTerraform(struct?: ComputeBmsServerV2TimeoutsOutputReference | ComputeBmsServerV2Timeouts | cdktf.IResolvable): any;
export declare class ComputeBmsServerV2TimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): ComputeBmsServerV2Timeouts | undefined;
    set internalValue(value: ComputeBmsServerV2Timeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_bms_server_v2 opentelekomcloud_compute_bms_server_v2}
*/
export declare class ComputeBmsServerV2 extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_bms_server_v2 opentelekomcloud_compute_bms_server_v2} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ComputeBmsServerV2Config
    */
    constructor(scope: Construct, id: string, config: ComputeBmsServerV2Config);
    get accessIpV4(): string;
    get accessIpV6(): string;
    private _adminPass?;
    get adminPass(): string;
    set adminPass(value: string);
    resetAdminPass(): void;
    get adminPassInput(): string | undefined;
    private _availabilityZone?;
    get availabilityZone(): string;
    set availabilityZone(value: string);
    get availabilityZoneInput(): string | undefined;
    get configDrive(): cdktf.IResolvable;
    private _flavorId?;
    get flavorId(): string;
    set flavorId(value: string);
    resetFlavorId(): void;
    get flavorIdInput(): string | undefined;
    private _flavorName?;
    get flavorName(): string;
    set flavorName(value: string);
    resetFlavorName(): void;
    get flavorNameInput(): string | undefined;
    get hostId(): string;
    get hostStatus(): string;
    get id(): string;
    private _imageId?;
    get imageId(): string;
    set imageId(value: string);
    resetImageId(): void;
    get imageIdInput(): string | undefined;
    private _imageName?;
    get imageName(): string;
    set imageName(value: string);
    resetImageName(): void;
    get imageNameInput(): string | undefined;
    get kernelId(): string;
    private _keyPair?;
    get keyPair(): string;
    set keyPair(value: string);
    resetKeyPair(): void;
    get keyPairInput(): string | undefined;
    private _metadata?;
    get metadata(): {
        [key: string]: string;
    };
    set metadata(value: {
        [key: string]: string;
    });
    resetMetadata(): void;
    get metadataInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _securityGroups?;
    get securityGroups(): string[];
    set securityGroups(value: string[]);
    resetSecurityGroups(): void;
    get securityGroupsInput(): string[] | undefined;
    private _stopBeforeDestroy?;
    get stopBeforeDestroy(): boolean | cdktf.IResolvable;
    set stopBeforeDestroy(value: boolean | cdktf.IResolvable);
    resetStopBeforeDestroy(): void;
    get stopBeforeDestroyInput(): boolean | cdktf.IResolvable | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    get tenantId(): string;
    private _userData?;
    get userData(): string;
    set userData(value: string);
    resetUserData(): void;
    get userDataInput(): string | undefined;
    get userId(): string;
    private _blockDevice?;
    get blockDevice(): ComputeBmsServerV2BlockDevice[] | cdktf.IResolvable;
    set blockDevice(value: ComputeBmsServerV2BlockDevice[] | cdktf.IResolvable);
    resetBlockDevice(): void;
    get blockDeviceInput(): cdktf.IResolvable | ComputeBmsServerV2BlockDevice[] | undefined;
    private _network?;
    get network(): ComputeBmsServerV2Network[] | cdktf.IResolvable;
    set network(value: ComputeBmsServerV2Network[] | cdktf.IResolvable);
    resetNetwork(): void;
    get networkInput(): cdktf.IResolvable | ComputeBmsServerV2Network[] | undefined;
    private _timeouts;
    get timeouts(): ComputeBmsServerV2TimeoutsOutputReference;
    putTimeouts(value: ComputeBmsServerV2Timeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): ComputeBmsServerV2Timeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
