import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeFloatingipV2Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_floatingip_v2#pool ComputeFloatingipV2#pool}
    */
    readonly pool?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_floatingip_v2#region ComputeFloatingipV2#region}
    */
    readonly region?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_floatingip_v2 opentelekomcloud_compute_floatingip_v2}
*/
export declare class ComputeFloatingipV2 extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_floatingip_v2 opentelekomcloud_compute_floatingip_v2} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ComputeFloatingipV2Config = {}
    */
    constructor(scope: Construct, id: string, config?: ComputeFloatingipV2Config);
    get address(): string;
    get fixedIp(): string;
    get id(): string;
    get instanceId(): string;
    private _pool?;
    get pool(): string;
    set pool(value: string);
    resetPool(): void;
    get poolInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
