import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeVolumeAttachV2Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_volume_attach_v2#device ComputeVolumeAttachV2#device}
    */
    readonly device?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_volume_attach_v2#instance_id ComputeVolumeAttachV2#instance_id}
    */
    readonly instanceId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_volume_attach_v2#region ComputeVolumeAttachV2#region}
    */
    readonly region?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_volume_attach_v2#volume_id ComputeVolumeAttachV2#volume_id}
    */
    readonly volumeId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_volume_attach_v2#timeouts ComputeVolumeAttachV2#timeouts}
    */
    readonly timeouts?: ComputeVolumeAttachV2Timeouts;
}
export interface ComputeVolumeAttachV2Timeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_volume_attach_v2#create ComputeVolumeAttachV2#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_volume_attach_v2#delete ComputeVolumeAttachV2#delete}
    */
    readonly delete?: string;
}
export declare function computeVolumeAttachV2TimeoutsToTerraform(struct?: ComputeVolumeAttachV2TimeoutsOutputReference | ComputeVolumeAttachV2Timeouts | cdktf.IResolvable): any;
export declare class ComputeVolumeAttachV2TimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): ComputeVolumeAttachV2Timeouts | undefined;
    set internalValue(value: ComputeVolumeAttachV2Timeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_volume_attach_v2 opentelekomcloud_compute_volume_attach_v2}
*/
export declare class ComputeVolumeAttachV2 extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_volume_attach_v2 opentelekomcloud_compute_volume_attach_v2} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ComputeVolumeAttachV2Config
    */
    constructor(scope: Construct, id: string, config: ComputeVolumeAttachV2Config);
    private _device?;
    get device(): string;
    set device(value: string);
    resetDevice(): void;
    get deviceInput(): string | undefined;
    get id(): string;
    private _instanceId?;
    get instanceId(): string;
    set instanceId(value: string);
    get instanceIdInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _volumeId?;
    get volumeId(): string;
    set volumeId(value: string);
    get volumeIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): ComputeVolumeAttachV2TimeoutsOutputReference;
    putTimeouts(value: ComputeVolumeAttachV2Timeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): ComputeVolumeAttachV2Timeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
