import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CsbsBackupPolicyV1Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/csbs_backup_policy_v1#common CsbsBackupPolicyV1#common}
    */
    readonly common?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/csbs_backup_policy_v1#description CsbsBackupPolicyV1#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/csbs_backup_policy_v1#name CsbsBackupPolicyV1#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/csbs_backup_policy_v1#provider_id CsbsBackupPolicyV1#provider_id}
    */
    readonly providerId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/csbs_backup_policy_v1#region CsbsBackupPolicyV1#region}
    */
    readonly region?: string;
    /**
    * resource block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/csbs_backup_policy_v1#resource CsbsBackupPolicyV1#resource}
    */
    readonly resource: CsbsBackupPolicyV1Resource[] | cdktf.IResolvable;
    /**
    * scheduled_operation block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/csbs_backup_policy_v1#scheduled_operation CsbsBackupPolicyV1#scheduled_operation}
    */
    readonly scheduledOperation: CsbsBackupPolicyV1ScheduledOperation;
    /**
    * tags block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/csbs_backup_policy_v1#tags CsbsBackupPolicyV1#tags}
    */
    readonly tags?: CsbsBackupPolicyV1Tags[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/csbs_backup_policy_v1#timeouts CsbsBackupPolicyV1#timeouts}
    */
    readonly timeouts?: CsbsBackupPolicyV1Timeouts;
}
export interface CsbsBackupPolicyV1Resource {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/csbs_backup_policy_v1#id CsbsBackupPolicyV1#id}
    */
    readonly id: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/csbs_backup_policy_v1#name CsbsBackupPolicyV1#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/csbs_backup_policy_v1#type CsbsBackupPolicyV1#type}
    */
    readonly type: string;
}
export declare function csbsBackupPolicyV1ResourceToTerraform(struct?: CsbsBackupPolicyV1Resource | cdktf.IResolvable): any;
export interface CsbsBackupPolicyV1ScheduledOperation {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/csbs_backup_policy_v1#day_backups CsbsBackupPolicyV1#day_backups}
    */
    readonly dayBackups?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/csbs_backup_policy_v1#description CsbsBackupPolicyV1#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/csbs_backup_policy_v1#enabled CsbsBackupPolicyV1#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/csbs_backup_policy_v1#max_backups CsbsBackupPolicyV1#max_backups}
    */
    readonly maxBackups?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/csbs_backup_policy_v1#month_backups CsbsBackupPolicyV1#month_backups}
    */
    readonly monthBackups?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/csbs_backup_policy_v1#name CsbsBackupPolicyV1#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/csbs_backup_policy_v1#operation_type CsbsBackupPolicyV1#operation_type}
    */
    readonly operationType: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/csbs_backup_policy_v1#permanent CsbsBackupPolicyV1#permanent}
    */
    readonly permanent?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/csbs_backup_policy_v1#retention_duration_days CsbsBackupPolicyV1#retention_duration_days}
    */
    readonly retentionDurationDays?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/csbs_backup_policy_v1#timezone CsbsBackupPolicyV1#timezone}
    */
    readonly timezone?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/csbs_backup_policy_v1#trigger_pattern CsbsBackupPolicyV1#trigger_pattern}
    */
    readonly triggerPattern: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/csbs_backup_policy_v1#week_backups CsbsBackupPolicyV1#week_backups}
    */
    readonly weekBackups?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/csbs_backup_policy_v1#year_backups CsbsBackupPolicyV1#year_backups}
    */
    readonly yearBackups?: number;
}
export declare function csbsBackupPolicyV1ScheduledOperationToTerraform(struct?: CsbsBackupPolicyV1ScheduledOperationOutputReference | CsbsBackupPolicyV1ScheduledOperation | cdktf.IResolvable): any;
export declare class CsbsBackupPolicyV1ScheduledOperationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): CsbsBackupPolicyV1ScheduledOperation | undefined;
    set internalValue(value: CsbsBackupPolicyV1ScheduledOperation | undefined);
    private _dayBackups?;
    get dayBackups(): number;
    set dayBackups(value: number);
    resetDayBackups(): void;
    get dayBackupsInput(): number | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _maxBackups?;
    get maxBackups(): number;
    set maxBackups(value: number);
    resetMaxBackups(): void;
    get maxBackupsInput(): number | undefined;
    private _monthBackups?;
    get monthBackups(): number;
    set monthBackups(value: number);
    resetMonthBackups(): void;
    get monthBackupsInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _operationType?;
    get operationType(): string;
    set operationType(value: string);
    get operationTypeInput(): string | undefined;
    private _permanent?;
    get permanent(): boolean | cdktf.IResolvable;
    set permanent(value: boolean | cdktf.IResolvable);
    resetPermanent(): void;
    get permanentInput(): boolean | cdktf.IResolvable | undefined;
    private _retentionDurationDays?;
    get retentionDurationDays(): number;
    set retentionDurationDays(value: number);
    resetRetentionDurationDays(): void;
    get retentionDurationDaysInput(): number | undefined;
    private _timezone?;
    get timezone(): string;
    set timezone(value: string);
    resetTimezone(): void;
    get timezoneInput(): string | undefined;
    get triggerId(): string;
    get triggerName(): string;
    private _triggerPattern?;
    get triggerPattern(): string;
    set triggerPattern(value: string);
    get triggerPatternInput(): string | undefined;
    get triggerType(): string;
    private _weekBackups?;
    get weekBackups(): number;
    set weekBackups(value: number);
    resetWeekBackups(): void;
    get weekBackupsInput(): number | undefined;
    private _yearBackups?;
    get yearBackups(): number;
    set yearBackups(value: number);
    resetYearBackups(): void;
    get yearBackupsInput(): number | undefined;
}
export interface CsbsBackupPolicyV1Tags {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/csbs_backup_policy_v1#key CsbsBackupPolicyV1#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/csbs_backup_policy_v1#value CsbsBackupPolicyV1#value}
    */
    readonly value: string;
}
export declare function csbsBackupPolicyV1TagsToTerraform(struct?: CsbsBackupPolicyV1Tags | cdktf.IResolvable): any;
export interface CsbsBackupPolicyV1Timeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/csbs_backup_policy_v1#create CsbsBackupPolicyV1#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/csbs_backup_policy_v1#delete CsbsBackupPolicyV1#delete}
    */
    readonly delete?: string;
}
export declare function csbsBackupPolicyV1TimeoutsToTerraform(struct?: CsbsBackupPolicyV1TimeoutsOutputReference | CsbsBackupPolicyV1Timeouts | cdktf.IResolvable): any;
export declare class CsbsBackupPolicyV1TimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): CsbsBackupPolicyV1Timeouts | undefined;
    set internalValue(value: CsbsBackupPolicyV1Timeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/csbs_backup_policy_v1 opentelekomcloud_csbs_backup_policy_v1}
*/
export declare class CsbsBackupPolicyV1 extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/csbs_backup_policy_v1 opentelekomcloud_csbs_backup_policy_v1} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CsbsBackupPolicyV1Config
    */
    constructor(scope: Construct, id: string, config: CsbsBackupPolicyV1Config);
    private _common?;
    get common(): {
        [key: string]: string;
    };
    set common(value: {
        [key: string]: string;
    });
    resetCommon(): void;
    get commonInput(): {
        [key: string]: string;
    } | undefined;
    get createdAt(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _providerId?;
    get providerId(): string;
    set providerId(value: string);
    resetProviderId(): void;
    get providerIdInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    get status(): string;
    private _resource?;
    get resource(): CsbsBackupPolicyV1Resource[] | cdktf.IResolvable;
    set resource(value: CsbsBackupPolicyV1Resource[] | cdktf.IResolvable);
    get resourceInput(): cdktf.IResolvable | CsbsBackupPolicyV1Resource[] | undefined;
    private _scheduledOperation;
    get scheduledOperation(): CsbsBackupPolicyV1ScheduledOperationOutputReference;
    putScheduledOperation(value: CsbsBackupPolicyV1ScheduledOperation): void;
    get scheduledOperationInput(): CsbsBackupPolicyV1ScheduledOperation | undefined;
    private _tags?;
    get tags(): CsbsBackupPolicyV1Tags[] | cdktf.IResolvable;
    set tags(value: CsbsBackupPolicyV1Tags[] | cdktf.IResolvable);
    resetTags(): void;
    get tagsInput(): cdktf.IResolvable | CsbsBackupPolicyV1Tags[] | undefined;
    private _timeouts;
    get timeouts(): CsbsBackupPolicyV1TimeoutsOutputReference;
    putTimeouts(value: CsbsBackupPolicyV1Timeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): CsbsBackupPolicyV1Timeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
