import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CsbsBackupV1Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/csbs_backup_v1#backup_name CsbsBackupV1#backup_name}
    */
    readonly backupName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/csbs_backup_v1#description CsbsBackupV1#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/csbs_backup_v1#region CsbsBackupV1#region}
    */
    readonly region?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/csbs_backup_v1#resource_id CsbsBackupV1#resource_id}
    */
    readonly resourceId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/csbs_backup_v1#resource_type CsbsBackupV1#resource_type}
    */
    readonly resourceType?: string;
    /**
    * tags block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/csbs_backup_v1#tags CsbsBackupV1#tags}
    */
    readonly tags?: CsbsBackupV1Tags[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/csbs_backup_v1#timeouts CsbsBackupV1#timeouts}
    */
    readonly timeouts?: CsbsBackupV1Timeouts;
}
export declare class CsbsBackupV1VmMetadata extends cdktf.ComplexComputedList {
    get cloudServiceType(): string;
    get disk(): number;
    get eip(): string;
    get imageType(): string;
    get name(): string;
    get privateIp(): string;
    get ram(): number;
    get vcpus(): number;
}
export declare class CsbsBackupV1VolumeBackups extends cdktf.ComplexComputedList {
    get averageSpeed(): number;
    get bootable(): cdktf.IResolvable;
    get id(): string;
    get imageType(): string;
    get incremental(): cdktf.IResolvable;
    get name(): string;
    get size(): number;
    get snapshotId(): string;
    get sourceVolumeId(): string;
    get sourceVolumeName(): string;
    get sourceVolumeSize(): number;
    get spaceSavingRatio(): number;
    get status(): string;
}
export interface CsbsBackupV1Tags {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/csbs_backup_v1#key CsbsBackupV1#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/csbs_backup_v1#value CsbsBackupV1#value}
    */
    readonly value: string;
}
export declare function csbsBackupV1TagsToTerraform(struct?: CsbsBackupV1Tags | cdktf.IResolvable): any;
export interface CsbsBackupV1Timeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/csbs_backup_v1#create CsbsBackupV1#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/csbs_backup_v1#delete CsbsBackupV1#delete}
    */
    readonly delete?: string;
}
export declare function csbsBackupV1TimeoutsToTerraform(struct?: CsbsBackupV1TimeoutsOutputReference | CsbsBackupV1Timeouts | cdktf.IResolvable): any;
export declare class CsbsBackupV1TimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): CsbsBackupV1Timeouts | undefined;
    set internalValue(value: CsbsBackupV1Timeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/csbs_backup_v1 opentelekomcloud_csbs_backup_v1}
*/
export declare class CsbsBackupV1 extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/csbs_backup_v1 opentelekomcloud_csbs_backup_v1} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CsbsBackupV1Config
    */
    constructor(scope: Construct, id: string, config: CsbsBackupV1Config);
    private _backupName?;
    get backupName(): string;
    set backupName(value: string);
    resetBackupName(): void;
    get backupNameInput(): string | undefined;
    get backupRecordId(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _resourceId?;
    get resourceId(): string;
    set resourceId(value: string);
    get resourceIdInput(): string | undefined;
    private _resourceType?;
    get resourceType(): string;
    set resourceType(value: string);
    resetResourceType(): void;
    get resourceTypeInput(): string | undefined;
    get status(): string;
    vmMetadata(index: string): CsbsBackupV1VmMetadata;
    volumeBackups(index: string): CsbsBackupV1VolumeBackups;
    private _tags?;
    get tags(): CsbsBackupV1Tags[] | cdktf.IResolvable;
    set tags(value: CsbsBackupV1Tags[] | cdktf.IResolvable);
    resetTags(): void;
    get tagsInput(): cdktf.IResolvable | CsbsBackupV1Tags[] | undefined;
    private _timeouts;
    get timeouts(): CsbsBackupV1TimeoutsOutputReference;
    putTimeouts(value: CsbsBackupV1Timeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): CsbsBackupV1Timeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
