import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CssClusterV1Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/css_cluster_v1#admin_pass CssClusterV1#admin_pass}
    */
    readonly adminPass?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/css_cluster_v1#enable_authority CssClusterV1#enable_authority}
    */
    readonly enableAuthority?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/css_cluster_v1#enable_https CssClusterV1#enable_https}
    */
    readonly enableHttps?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/css_cluster_v1#expect_node_num CssClusterV1#expect_node_num}
    */
    readonly expectNodeNum?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/css_cluster_v1#name CssClusterV1#name}
    */
    readonly name: string;
    /**
    * datastore block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/css_cluster_v1#datastore CssClusterV1#datastore}
    */
    readonly datastore?: CssClusterV1Datastore;
    /**
    * node_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/css_cluster_v1#node_config CssClusterV1#node_config}
    */
    readonly nodeConfig: CssClusterV1NodeConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/css_cluster_v1#timeouts CssClusterV1#timeouts}
    */
    readonly timeouts?: CssClusterV1Timeouts;
}
export declare class CssClusterV1Nodes extends cdktf.ComplexComputedList {
    get id(): string;
    get name(): string;
    get type(): string;
}
export interface CssClusterV1Datastore {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/css_cluster_v1#type CssClusterV1#type}
    */
    readonly type?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/css_cluster_v1#version CssClusterV1#version}
    */
    readonly version?: string;
}
export declare function cssClusterV1DatastoreToTerraform(struct?: CssClusterV1DatastoreOutputReference | CssClusterV1Datastore): any;
export declare class CssClusterV1DatastoreOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): CssClusterV1Datastore | undefined;
    set internalValue(value: CssClusterV1Datastore | undefined);
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    resetVersion(): void;
    get versionInput(): string | undefined;
}
export interface CssClusterV1NodeConfigNetworkInfo {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/css_cluster_v1#network_id CssClusterV1#network_id}
    */
    readonly networkId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/css_cluster_v1#security_group_id CssClusterV1#security_group_id}
    */
    readonly securityGroupId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/css_cluster_v1#vpc_id CssClusterV1#vpc_id}
    */
    readonly vpcId: string;
}
export declare function cssClusterV1NodeConfigNetworkInfoToTerraform(struct?: CssClusterV1NodeConfigNetworkInfoOutputReference | CssClusterV1NodeConfigNetworkInfo): any;
export declare class CssClusterV1NodeConfigNetworkInfoOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): CssClusterV1NodeConfigNetworkInfo | undefined;
    set internalValue(value: CssClusterV1NodeConfigNetworkInfo | undefined);
    private _networkId?;
    get networkId(): string;
    set networkId(value: string);
    get networkIdInput(): string | undefined;
    private _securityGroupId?;
    get securityGroupId(): string;
    set securityGroupId(value: string);
    get securityGroupIdInput(): string | undefined;
    private _vpcId?;
    get vpcId(): string;
    set vpcId(value: string);
    get vpcIdInput(): string | undefined;
}
export interface CssClusterV1NodeConfigVolume {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/css_cluster_v1#encryption_key CssClusterV1#encryption_key}
    */
    readonly encryptionKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/css_cluster_v1#size CssClusterV1#size}
    */
    readonly size: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/css_cluster_v1#volume_type CssClusterV1#volume_type}
    */
    readonly volumeType: string;
}
export declare function cssClusterV1NodeConfigVolumeToTerraform(struct?: CssClusterV1NodeConfigVolumeOutputReference | CssClusterV1NodeConfigVolume): any;
export declare class CssClusterV1NodeConfigVolumeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): CssClusterV1NodeConfigVolume | undefined;
    set internalValue(value: CssClusterV1NodeConfigVolume | undefined);
    private _encryptionKey?;
    get encryptionKey(): string;
    set encryptionKey(value: string);
    resetEncryptionKey(): void;
    get encryptionKeyInput(): string | undefined;
    private _size?;
    get size(): number;
    set size(value: number);
    get sizeInput(): number | undefined;
    private _volumeType?;
    get volumeType(): string;
    set volumeType(value: string);
    get volumeTypeInput(): string | undefined;
}
export interface CssClusterV1NodeConfig {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/css_cluster_v1#availability_zone CssClusterV1#availability_zone}
    */
    readonly availabilityZone?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/css_cluster_v1#flavor CssClusterV1#flavor}
    */
    readonly flavor: string;
    /**
    * network_info block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/css_cluster_v1#network_info CssClusterV1#network_info}
    */
    readonly networkInfo: CssClusterV1NodeConfigNetworkInfo;
    /**
    * volume block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/css_cluster_v1#volume CssClusterV1#volume}
    */
    readonly volume: CssClusterV1NodeConfigVolume;
}
export declare function cssClusterV1NodeConfigToTerraform(struct?: CssClusterV1NodeConfigOutputReference | CssClusterV1NodeConfig): any;
export declare class CssClusterV1NodeConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): CssClusterV1NodeConfig | undefined;
    set internalValue(value: CssClusterV1NodeConfig | undefined);
    private _availabilityZone?;
    get availabilityZone(): string;
    set availabilityZone(value: string);
    resetAvailabilityZone(): void;
    get availabilityZoneInput(): string | undefined;
    private _flavor?;
    get flavor(): string;
    set flavor(value: string);
    get flavorInput(): string | undefined;
    private _networkInfo;
    get networkInfo(): CssClusterV1NodeConfigNetworkInfoOutputReference;
    putNetworkInfo(value: CssClusterV1NodeConfigNetworkInfo): void;
    get networkInfoInput(): CssClusterV1NodeConfigNetworkInfo | undefined;
    private _volume;
    get volume(): CssClusterV1NodeConfigVolumeOutputReference;
    putVolume(value: CssClusterV1NodeConfigVolume): void;
    get volumeInput(): CssClusterV1NodeConfigVolume | undefined;
}
export interface CssClusterV1Timeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/css_cluster_v1#create CssClusterV1#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/css_cluster_v1#update CssClusterV1#update}
    */
    readonly update?: string;
}
export declare function cssClusterV1TimeoutsToTerraform(struct?: CssClusterV1TimeoutsOutputReference | CssClusterV1Timeouts | cdktf.IResolvable): any;
export declare class CssClusterV1TimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): CssClusterV1Timeouts | undefined;
    set internalValue(value: CssClusterV1Timeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/css_cluster_v1 opentelekomcloud_css_cluster_v1}
*/
export declare class CssClusterV1 extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/css_cluster_v1 opentelekomcloud_css_cluster_v1} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CssClusterV1Config
    */
    constructor(scope: Construct, id: string, config: CssClusterV1Config);
    private _adminPass?;
    get adminPass(): string;
    set adminPass(value: string);
    resetAdminPass(): void;
    get adminPassInput(): string | undefined;
    get created(): string;
    private _enableAuthority?;
    get enableAuthority(): boolean | cdktf.IResolvable;
    set enableAuthority(value: boolean | cdktf.IResolvable);
    resetEnableAuthority(): void;
    get enableAuthorityInput(): boolean | cdktf.IResolvable | undefined;
    private _enableHttps?;
    get enableHttps(): boolean | cdktf.IResolvable;
    set enableHttps(value: boolean | cdktf.IResolvable);
    resetEnableHttps(): void;
    get enableHttpsInput(): boolean | cdktf.IResolvable | undefined;
    get endpoint(): string;
    private _expectNodeNum?;
    get expectNodeNum(): number;
    set expectNodeNum(value: number);
    resetExpectNodeNum(): void;
    get expectNodeNumInput(): number | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    nodes(index: string): CssClusterV1Nodes;
    get updated(): string;
    private _datastore;
    get datastore(): CssClusterV1DatastoreOutputReference;
    putDatastore(value: CssClusterV1Datastore): void;
    resetDatastore(): void;
    get datastoreInput(): CssClusterV1Datastore | undefined;
    private _nodeConfig;
    get nodeConfig(): CssClusterV1NodeConfigOutputReference;
    putNodeConfig(value: CssClusterV1NodeConfig): void;
    get nodeConfigInput(): CssClusterV1NodeConfig | undefined;
    private _timeouts;
    get timeouts(): CssClusterV1TimeoutsOutputReference;
    putTimeouts(value: CssClusterV1Timeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): CssClusterV1Timeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
