import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataOpentelekomcloudCceClusterV3Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/cce_cluster_v3#cluster_type DataOpentelekomcloudCceClusterV3#cluster_type}
    */
    readonly clusterType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/cce_cluster_v3#name DataOpentelekomcloudCceClusterV3#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/cce_cluster_v3#region DataOpentelekomcloudCceClusterV3#region}
    */
    readonly region?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/cce_cluster_v3#status DataOpentelekomcloudCceClusterV3#status}
    */
    readonly status?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/cce_cluster_v3#vpc_id DataOpentelekomcloudCceClusterV3#vpc_id}
    */
    readonly vpcId?: string;
}
export declare class DataOpentelekomcloudCceClusterV3CertificateClusters extends cdktf.ComplexComputedList {
    get certificateAuthorityData(): string;
    get name(): string;
    get server(): string;
}
export declare class DataOpentelekomcloudCceClusterV3CertificateUsers extends cdktf.ComplexComputedList {
    get clientCertificateData(): string;
    get clientKeyData(): string;
    get name(): string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/cce_cluster_v3 opentelekomcloud_cce_cluster_v3}
*/
export declare class DataOpentelekomcloudCceClusterV3 extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/cce_cluster_v3 opentelekomcloud_cce_cluster_v3} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataOpentelekomcloudCceClusterV3Config = {}
    */
    constructor(scope: Construct, id: string, config?: DataOpentelekomcloudCceClusterV3Config);
    get authenticationMode(): string;
    get billingMode(): number;
    certificateClusters(index: string): DataOpentelekomcloudCceClusterV3CertificateClusters;
    certificateUsers(index: string): DataOpentelekomcloudCceClusterV3CertificateUsers;
    private _clusterType?;
    get clusterType(): string;
    set clusterType(value: string);
    resetClusterType(): void;
    get clusterTypeInput(): string | undefined;
    get clusterVersion(): string;
    get containerNetworkCidr(): string;
    get containerNetworkType(): string;
    get description(): string;
    get external(): string;
    get externalOtc(): string;
    get flavorId(): string;
    get highwaySubnetId(): string;
    get id(): string;
    get internal(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _status?;
    get status(): string;
    set status(value: string);
    resetStatus(): void;
    get statusInput(): string | undefined;
    get subnetId(): string;
    private _vpcId?;
    get vpcId(): string;
    set vpcId(value: string);
    resetVpcId(): void;
    get vpcIdInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
