import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataOpentelekomcloudCceNodeV3Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/cce_node_v3#cluster_id DataOpentelekomcloudCceNodeV3#cluster_id}
    */
    readonly clusterId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/cce_node_v3#name DataOpentelekomcloudCceNodeV3#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/cce_node_v3#node_id DataOpentelekomcloudCceNodeV3#node_id}
    */
    readonly nodeId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/cce_node_v3#region DataOpentelekomcloudCceNodeV3#region}
    */
    readonly region?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/cce_node_v3#status DataOpentelekomcloudCceNodeV3#status}
    */
    readonly status?: string;
}
export declare class DataOpentelekomcloudCceNodeV3DataVolumes extends cdktf.ComplexComputedList {
    get diskSize(): number;
    get extendParam(): string;
    get kmsId(): string;
    get volumeType(): string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/cce_node_v3 opentelekomcloud_cce_node_v3}
*/
export declare class DataOpentelekomcloudCceNodeV3 extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/cce_node_v3 opentelekomcloud_cce_node_v3} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataOpentelekomcloudCceNodeV3Config
    */
    constructor(scope: Construct, id: string, config: DataOpentelekomcloudCceNodeV3Config);
    get availabilityZone(): string;
    get bandwidthSize(): number;
    get billingMode(): number;
    get chargeMode(): string;
    private _clusterId?;
    get clusterId(): string;
    set clusterId(value: string);
    get clusterIdInput(): string | undefined;
    dataVolumes(index: string): DataOpentelekomcloudCceNodeV3DataVolumes;
    get diskSize(): number;
    get eipCount(): number;
    get eipIds(): string[];
    get flavorId(): string;
    get id(): string;
    get ipType(): string;
    get keyPair(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _nodeId?;
    get nodeId(): string;
    set nodeId(value: string);
    resetNodeId(): void;
    get nodeIdInput(): string | undefined;
    get privateIp(): string;
    get publicIp(): string;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    get serverId(): string;
    get shareType(): string;
    private _status?;
    get status(): string;
    set status(value: string);
    resetStatus(): void;
    get statusInput(): string | undefined;
    get volumeType(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
