import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataOpentelekomcloudComputeBmsServerV2Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/compute_bms_server_v2#flavor_id DataOpentelekomcloudComputeBmsServerV2#flavor_id}
    */
    readonly flavorId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/compute_bms_server_v2#host_status DataOpentelekomcloudComputeBmsServerV2#host_status}
    */
    readonly hostStatus?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/compute_bms_server_v2#id DataOpentelekomcloudComputeBmsServerV2#id}
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/compute_bms_server_v2#image_id DataOpentelekomcloudComputeBmsServerV2#image_id}
    */
    readonly imageId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/compute_bms_server_v2#key_name DataOpentelekomcloudComputeBmsServerV2#key_name}
    */
    readonly keyName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/compute_bms_server_v2#name DataOpentelekomcloudComputeBmsServerV2#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/compute_bms_server_v2#region DataOpentelekomcloudComputeBmsServerV2#region}
    */
    readonly region?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/compute_bms_server_v2#status DataOpentelekomcloudComputeBmsServerV2#status}
    */
    readonly status?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/compute_bms_server_v2#user_id DataOpentelekomcloudComputeBmsServerV2#user_id}
    */
    readonly userId?: string;
}
export declare class DataOpentelekomcloudComputeBmsServerV2Network extends cdktf.ComplexComputedList {
    get ip(): string;
    get mac(): string;
    get name(): string;
    get type(): string;
    get version(): number;
}
export declare class DataOpentelekomcloudComputeBmsServerV2SecurityGroups extends cdktf.ComplexComputedList {
    get name(): string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/compute_bms_server_v2 opentelekomcloud_compute_bms_server_v2}
*/
export declare class DataOpentelekomcloudComputeBmsServerV2 extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/compute_bms_server_v2 opentelekomcloud_compute_bms_server_v2} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataOpentelekomcloudComputeBmsServerV2Config = {}
    */
    constructor(scope: Construct, id: string, config?: DataOpentelekomcloudComputeBmsServerV2Config);
    get accessIpV4(): string;
    get accessIpV6(): string;
    get availabilityZone(): string;
    get configDrive(): string;
    get description(): string;
    private _flavorId?;
    get flavorId(): string;
    set flavorId(value: string);
    resetFlavorId(): void;
    get flavorIdInput(): string | undefined;
    get hostId(): string;
    private _hostStatus?;
    get hostStatus(): string;
    set hostStatus(value: string);
    resetHostStatus(): void;
    get hostStatusInput(): string | undefined;
    get hypervisorHostname(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _imageId?;
    get imageId(): string;
    set imageId(value: string);
    resetImageId(): void;
    get imageIdInput(): string | undefined;
    get instanceName(): string;
    get kernelId(): string;
    private _keyName?;
    get keyName(): string;
    set keyName(value: string);
    resetKeyName(): void;
    get keyNameInput(): string | undefined;
    get locked(): cdktf.IResolvable;
    metadata(key: string): string | cdktf.IResolvable;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    network(index: string): DataOpentelekomcloudComputeBmsServerV2Network;
    get progress(): number;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    securityGroups(index: string): DataOpentelekomcloudComputeBmsServerV2SecurityGroups;
    private _status?;
    get status(): string;
    set status(value: string);
    resetStatus(): void;
    get statusInput(): string | undefined;
    get tags(): string[];
    get tenantId(): string;
    private _userId?;
    get userId(): string;
    set userId(value: string);
    resetUserId(): void;
    get userIdInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
