import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataOpentelekomcloudCsbsBackupPolicyV1Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/csbs_backup_policy_v1#name DataOpentelekomcloudCsbsBackupPolicyV1#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/csbs_backup_policy_v1#region DataOpentelekomcloudCsbsBackupPolicyV1#region}
    */
    readonly region?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/csbs_backup_policy_v1#status DataOpentelekomcloudCsbsBackupPolicyV1#status}
    */
    readonly status?: string;
}
export declare class DataOpentelekomcloudCsbsBackupPolicyV1Resource extends cdktf.ComplexComputedList {
    get id(): string;
    get name(): string;
    get type(): string;
}
export declare class DataOpentelekomcloudCsbsBackupPolicyV1ScheduledOperation extends cdktf.ComplexComputedList {
    get description(): string;
    get enabled(): cdktf.IResolvable;
    get id(): string;
    get maxBackups(): number;
    get name(): string;
    get operationType(): string;
    get permanent(): cdktf.IResolvable;
    get retentionDurationDays(): number;
    get triggerId(): string;
    get triggerName(): string;
    get triggerPattern(): string;
    get triggerType(): string;
}
export declare class DataOpentelekomcloudCsbsBackupPolicyV1Tags extends cdktf.ComplexComputedList {
    get key(): string;
    get value(): string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/csbs_backup_policy_v1 opentelekomcloud_csbs_backup_policy_v1}
*/
export declare class DataOpentelekomcloudCsbsBackupPolicyV1 extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/csbs_backup_policy_v1 opentelekomcloud_csbs_backup_policy_v1} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataOpentelekomcloudCsbsBackupPolicyV1Config = {}
    */
    constructor(scope: Construct, id: string, config?: DataOpentelekomcloudCsbsBackupPolicyV1Config);
    common(key: string): string | cdktf.IResolvable;
    get description(): string;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    get providerId(): string;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    resource(index: string): DataOpentelekomcloudCsbsBackupPolicyV1Resource;
    scheduledOperation(index: string): DataOpentelekomcloudCsbsBackupPolicyV1ScheduledOperation;
    private _status?;
    get status(): string;
    set status(value: string);
    resetStatus(): void;
    get statusInput(): string | undefined;
    tags(index: string): DataOpentelekomcloudCsbsBackupPolicyV1Tags;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
