import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataOpentelekomcloudCsbsBackupV1Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/csbs_backup_v1#backup_name DataOpentelekomcloudCsbsBackupV1#backup_name}
    */
    readonly backupName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/csbs_backup_v1#backup_record_id DataOpentelekomcloudCsbsBackupV1#backup_record_id}
    */
    readonly backupRecordId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/csbs_backup_v1#id DataOpentelekomcloudCsbsBackupV1#id}
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/csbs_backup_v1#policy_id DataOpentelekomcloudCsbsBackupV1#policy_id}
    */
    readonly policyId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/csbs_backup_v1#region DataOpentelekomcloudCsbsBackupV1#region}
    */
    readonly region?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/csbs_backup_v1#resource_id DataOpentelekomcloudCsbsBackupV1#resource_id}
    */
    readonly resourceId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/csbs_backup_v1#resource_name DataOpentelekomcloudCsbsBackupV1#resource_name}
    */
    readonly resourceName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/csbs_backup_v1#resource_type DataOpentelekomcloudCsbsBackupV1#resource_type}
    */
    readonly resourceType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/csbs_backup_v1#status DataOpentelekomcloudCsbsBackupV1#status}
    */
    readonly status?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/csbs_backup_v1#vm_ip DataOpentelekomcloudCsbsBackupV1#vm_ip}
    */
    readonly vmIp?: string;
}
export declare class DataOpentelekomcloudCsbsBackupV1Tags extends cdktf.ComplexComputedList {
    get key(): string;
    get value(): string;
}
export declare class DataOpentelekomcloudCsbsBackupV1VmMetadata extends cdktf.ComplexComputedList {
    get cloudServiceType(): string;
    get disk(): number;
    get eip(): string;
    get imageType(): string;
    get name(): string;
    get privateIp(): string;
    get ram(): number;
    get vcpus(): number;
}
export declare class DataOpentelekomcloudCsbsBackupV1VolumeBackups extends cdktf.ComplexComputedList {
    get averageSpeed(): number;
    get bootable(): cdktf.IResolvable;
    get id(): string;
    get imageType(): string;
    get incremental(): cdktf.IResolvable;
    get name(): string;
    get size(): number;
    get snapshotId(): string;
    get sourceVolumeId(): string;
    get sourceVolumeName(): string;
    get sourceVolumeSize(): number;
    get spaceSavingRatio(): number;
    get status(): string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/csbs_backup_v1 opentelekomcloud_csbs_backup_v1}
*/
export declare class DataOpentelekomcloudCsbsBackupV1 extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/csbs_backup_v1 opentelekomcloud_csbs_backup_v1} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataOpentelekomcloudCsbsBackupV1Config = {}
    */
    constructor(scope: Construct, id: string, config?: DataOpentelekomcloudCsbsBackupV1Config);
    get autoTrigger(): cdktf.IResolvable;
    get averageSpeed(): number;
    private _backupName?;
    get backupName(): string;
    set backupName(value: string);
    resetBackupName(): void;
    get backupNameInput(): string | undefined;
    private _backupRecordId?;
    get backupRecordId(): string;
    set backupRecordId(value: string);
    resetBackupRecordId(): void;
    get backupRecordIdInput(): string | undefined;
    get description(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _policyId?;
    get policyId(): string;
    set policyId(value: string);
    resetPolicyId(): void;
    get policyIdInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _resourceId?;
    get resourceId(): string;
    set resourceId(value: string);
    resetResourceId(): void;
    get resourceIdInput(): string | undefined;
    private _resourceName?;
    get resourceName(): string;
    set resourceName(value: string);
    resetResourceName(): void;
    get resourceNameInput(): string | undefined;
    private _resourceType?;
    get resourceType(): string;
    set resourceType(value: string);
    resetResourceType(): void;
    get resourceTypeInput(): string | undefined;
    get size(): number;
    private _status?;
    get status(): string;
    set status(value: string);
    resetStatus(): void;
    get statusInput(): string | undefined;
    tags(index: string): DataOpentelekomcloudCsbsBackupV1Tags;
    private _vmIp?;
    get vmIp(): string;
    set vmIp(value: string);
    resetVmIp(): void;
    get vmIpInput(): string | undefined;
    vmMetadata(index: string): DataOpentelekomcloudCsbsBackupV1VmMetadata;
    volumeBackups(index: string): DataOpentelekomcloudCsbsBackupV1VolumeBackups;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
