import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataOpentelekomcloudDdsInstanceV3Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/dds_instance_v3#datastore_type DataOpentelekomcloudDdsInstanceV3#datastore_type}
    */
    readonly datastoreType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/dds_instance_v3#instance_id DataOpentelekomcloudDdsInstanceV3#instance_id}
    */
    readonly instanceId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/dds_instance_v3#name DataOpentelekomcloudDdsInstanceV3#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/dds_instance_v3#subnet_id DataOpentelekomcloudDdsInstanceV3#subnet_id}
    */
    readonly subnetId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/dds_instance_v3#vpc_id DataOpentelekomcloudDdsInstanceV3#vpc_id}
    */
    readonly vpcId?: string;
}
export declare class DataOpentelekomcloudDdsInstanceV3BackupStrategy extends cdktf.ComplexComputedList {
    get keepDays(): number;
    get startTime(): string;
}
export declare class DataOpentelekomcloudDdsInstanceV3Datastore extends cdktf.ComplexComputedList {
    get storageEngine(): string;
    get type(): string;
    get version(): string;
}
export declare class DataOpentelekomcloudDdsInstanceV3Nodes extends cdktf.ComplexComputedList {
    get id(): string;
    get name(): string;
    get privateIp(): string;
    get publicIp(): string;
    get role(): string;
    get status(): string;
    get type(): string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/dds_instance_v3 opentelekomcloud_dds_instance_v3}
*/
export declare class DataOpentelekomcloudDdsInstanceV3 extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/dds_instance_v3 opentelekomcloud_dds_instance_v3} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataOpentelekomcloudDdsInstanceV3Config = {}
    */
    constructor(scope: Construct, id: string, config?: DataOpentelekomcloudDdsInstanceV3Config);
    backupStrategy(index: string): DataOpentelekomcloudDdsInstanceV3BackupStrategy;
    datastore(index: string): DataOpentelekomcloudDdsInstanceV3Datastore;
    private _datastoreType?;
    get datastoreType(): string;
    set datastoreType(value: string);
    resetDatastoreType(): void;
    get datastoreTypeInput(): string | undefined;
    get dbUsername(): string;
    get diskEncryptionId(): string;
    get id(): string;
    private _instanceId?;
    get instanceId(): string;
    set instanceId(value: string);
    resetInstanceId(): void;
    get instanceIdInput(): string | undefined;
    get mode(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    nodes(index: string): DataOpentelekomcloudDdsInstanceV3Nodes;
    get payMode(): string;
    get port(): number;
    get region(): string;
    get securityGroupId(): string;
    get ssl(): cdktf.IResolvable;
    get status(): string;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    resetSubnetId(): void;
    get subnetIdInput(): string | undefined;
    private _vpcId?;
    get vpcId(): string;
    set vpcId(value: string);
    resetVpcId(): void;
    get vpcIdInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
