import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataOpentelekomcloudIdentityAuthScopeV3Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/identity_auth_scope_v3#name DataOpentelekomcloudIdentityAuthScopeV3#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/identity_auth_scope_v3#region DataOpentelekomcloudIdentityAuthScopeV3#region}
    */
    readonly region?: string;
}
export declare class DataOpentelekomcloudIdentityAuthScopeV3Roles extends cdktf.ComplexComputedList {
    get roleId(): string;
    get roleName(): string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/identity_auth_scope_v3 opentelekomcloud_identity_auth_scope_v3}
*/
export declare class DataOpentelekomcloudIdentityAuthScopeV3 extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/identity_auth_scope_v3 opentelekomcloud_identity_auth_scope_v3} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataOpentelekomcloudIdentityAuthScopeV3Config
    */
    constructor(scope: Construct, id: string, config: DataOpentelekomcloudIdentityAuthScopeV3Config);
    get domainId(): string;
    get domainName(): string;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get projectDomainId(): string;
    get projectDomainName(): string;
    get projectId(): string;
    get projectName(): string;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    roles(index: string): DataOpentelekomcloudIdentityAuthScopeV3Roles;
    get userDomainId(): string;
    get userDomainName(): string;
    get userId(): string;
    get userName(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
