import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataOpentelekomcloudKmsDataKeyV1Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/kms_data_key_v1#datakey_length DataOpentelekomcloudKmsDataKeyV1#datakey_length}
    */
    readonly datakeyLength: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/kms_data_key_v1#encryption_context DataOpentelekomcloudKmsDataKeyV1#encryption_context}
    */
    readonly encryptionContext?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/kms_data_key_v1#key_id DataOpentelekomcloudKmsDataKeyV1#key_id}
    */
    readonly keyId: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/kms_data_key_v1 opentelekomcloud_kms_data_key_v1}
*/
export declare class DataOpentelekomcloudKmsDataKeyV1 extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/kms_data_key_v1 opentelekomcloud_kms_data_key_v1} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataOpentelekomcloudKmsDataKeyV1Config
    */
    constructor(scope: Construct, id: string, config: DataOpentelekomcloudKmsDataKeyV1Config);
    get cipherText(): string;
    private _datakeyLength?;
    get datakeyLength(): string;
    set datakeyLength(value: string);
    get datakeyLengthInput(): string | undefined;
    private _encryptionContext?;
    get encryptionContext(): string;
    set encryptionContext(value: string);
    resetEncryptionContext(): void;
    get encryptionContextInput(): string | undefined;
    get id(): string;
    private _keyId?;
    get keyId(): string;
    set keyId(value: string);
    get keyIdInput(): string | undefined;
    get plainText(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
