import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataOpentelekomcloudKmsKeyV1Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/kms_key_v1#default_key_flag DataOpentelekomcloudKmsKeyV1#default_key_flag}
    */
    readonly defaultKeyFlag?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/kms_key_v1#domain_id DataOpentelekomcloudKmsKeyV1#domain_id}
    */
    readonly domainId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/kms_key_v1#key_alias DataOpentelekomcloudKmsKeyV1#key_alias}
    */
    readonly keyAlias?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/kms_key_v1#key_description DataOpentelekomcloudKmsKeyV1#key_description}
    */
    readonly keyDescription?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/kms_key_v1#key_id DataOpentelekomcloudKmsKeyV1#key_id}
    */
    readonly keyId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/kms_key_v1#key_state DataOpentelekomcloudKmsKeyV1#key_state}
    */
    readonly keyState?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/kms_key_v1#origin DataOpentelekomcloudKmsKeyV1#origin}
    */
    readonly origin?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/kms_key_v1#realm DataOpentelekomcloudKmsKeyV1#realm}
    */
    readonly realm?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/kms_key_v1 opentelekomcloud_kms_key_v1}
*/
export declare class DataOpentelekomcloudKmsKeyV1 extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/kms_key_v1 opentelekomcloud_kms_key_v1} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataOpentelekomcloudKmsKeyV1Config = {}
    */
    constructor(scope: Construct, id: string, config?: DataOpentelekomcloudKmsKeyV1Config);
    get creationDate(): string;
    private _defaultKeyFlag?;
    get defaultKeyFlag(): string;
    set defaultKeyFlag(value: string);
    resetDefaultKeyFlag(): void;
    get defaultKeyFlagInput(): string | undefined;
    private _domainId?;
    get domainId(): string;
    set domainId(value: string);
    resetDomainId(): void;
    get domainIdInput(): string | undefined;
    get expirationTime(): string;
    get id(): string;
    private _keyAlias?;
    get keyAlias(): string;
    set keyAlias(value: string);
    resetKeyAlias(): void;
    get keyAliasInput(): string | undefined;
    private _keyDescription?;
    get keyDescription(): string;
    set keyDescription(value: string);
    resetKeyDescription(): void;
    get keyDescriptionInput(): string | undefined;
    private _keyId?;
    get keyId(): string;
    set keyId(value: string);
    resetKeyId(): void;
    get keyIdInput(): string | undefined;
    private _keyState?;
    get keyState(): string;
    set keyState(value: string);
    resetKeyState(): void;
    get keyStateInput(): string | undefined;
    private _origin?;
    get origin(): string;
    set origin(value: string);
    resetOrigin(): void;
    get originInput(): string | undefined;
    private _realm?;
    get realm(): string;
    set realm(value: string);
    resetRealm(): void;
    get realmInput(): string | undefined;
    get scheduledDeletionDate(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
