import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataOpentelekomcloudLbLoadbalancerV3Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/lb_loadbalancer_v3#l4_flavor DataOpentelekomcloudLbLoadbalancerV3#l4_flavor}
    */
    readonly l4Flavor?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/lb_loadbalancer_v3#l7_flavor DataOpentelekomcloudLbLoadbalancerV3#l7_flavor}
    */
    readonly l7Flavor?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/lb_loadbalancer_v3#name DataOpentelekomcloudLbLoadbalancerV3#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/lb_loadbalancer_v3#router_id DataOpentelekomcloudLbLoadbalancerV3#router_id}
    */
    readonly routerId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/lb_loadbalancer_v3#subnet_id DataOpentelekomcloudLbLoadbalancerV3#subnet_id}
    */
    readonly subnetId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/lb_loadbalancer_v3#vip_address DataOpentelekomcloudLbLoadbalancerV3#vip_address}
    */
    readonly vipAddress?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/lb_loadbalancer_v3#vip_port_id DataOpentelekomcloudLbLoadbalancerV3#vip_port_id}
    */
    readonly vipPortId?: string;
}
export declare class DataOpentelekomcloudLbLoadbalancerV3PublicIp extends cdktf.ComplexComputedList {
    get address(): string;
    get bandwidthChargeMode(): string;
    get bandwidthName(): string;
    get bandwidthShareType(): string;
    get bandwidthSize(): number;
    get id(): string;
    get ipType(): string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/lb_loadbalancer_v3 opentelekomcloud_lb_loadbalancer_v3}
*/
export declare class DataOpentelekomcloudLbLoadbalancerV3 extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/lb_loadbalancer_v3 opentelekomcloud_lb_loadbalancer_v3} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataOpentelekomcloudLbLoadbalancerV3Config = {}
    */
    constructor(scope: Construct, id: string, config?: DataOpentelekomcloudLbLoadbalancerV3Config);
    get adminStateUp(): cdktf.IResolvable;
    get availabilityZones(): string[];
    get createdAt(): string;
    get description(): string;
    get id(): string;
    get ipTargetEnable(): cdktf.IResolvable;
    private _l4Flavor?;
    get l4Flavor(): string;
    set l4Flavor(value: string);
    resetL4Flavor(): void;
    get l4FlavorInput(): string | undefined;
    private _l7Flavor?;
    get l7Flavor(): string;
    set l7Flavor(value: string);
    resetL7Flavor(): void;
    get l7FlavorInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    get networkIds(): string[];
    publicIp(index: string): DataOpentelekomcloudLbLoadbalancerV3PublicIp;
    private _routerId?;
    get routerId(): string;
    set routerId(value: string);
    resetRouterId(): void;
    get routerIdInput(): string | undefined;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    resetSubnetId(): void;
    get subnetIdInput(): string | undefined;
    tags(key: string): string | cdktf.IResolvable;
    get updatedAt(): string;
    private _vipAddress?;
    get vipAddress(): string;
    set vipAddress(value: string);
    resetVipAddress(): void;
    get vipAddressInput(): string | undefined;
    private _vipPortId?;
    get vipPortId(): string;
    set vipPortId(value: string);
    resetVipPortId(): void;
    get vipPortIdInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
