import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataOpentelekomcloudObsBucketConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/obs_bucket#bucket DataOpentelekomcloudObsBucket#bucket}
    */
    readonly bucket: string;
}
export declare class DataOpentelekomcloudObsBucketCorsRule extends cdktf.ComplexComputedList {
    get allowedHeaders(): string[];
    get allowedMethods(): string[];
    get allowedOrigins(): string[];
    get exposeHeaders(): string[];
    get maxAgeSeconds(): number;
}
export declare class DataOpentelekomcloudObsBucketEventNotificationsFilterRule extends cdktf.ComplexComputedList {
    get name(): string;
    get value(): string;
}
export declare class DataOpentelekomcloudObsBucketEventNotifications extends cdktf.ComplexComputedList {
    get events(): string[];
    get filterRule(): cdktf.IResolvable;
    get id(): string;
    get topic(): string;
}
export declare class DataOpentelekomcloudObsBucketLifecycleRuleExpiration extends cdktf.ComplexComputedList {
    get days(): number;
}
export declare class DataOpentelekomcloudObsBucketLifecycleRuleNoncurrentVersionExpiration extends cdktf.ComplexComputedList {
    get days(): number;
}
export declare class DataOpentelekomcloudObsBucketLifecycleRuleNoncurrentVersionTransition extends cdktf.ComplexComputedList {
    get days(): number;
    get storageClass(): string;
}
export declare class DataOpentelekomcloudObsBucketLifecycleRuleTransition extends cdktf.ComplexComputedList {
    get days(): number;
    get storageClass(): string;
}
export declare class DataOpentelekomcloudObsBucketLifecycleRule extends cdktf.ComplexComputedList {
    get enabled(): cdktf.IResolvable;
    get expiration(): cdktf.IResolvable;
    get name(): string;
    get noncurrentVersionExpiration(): cdktf.IResolvable;
    get noncurrentVersionTransition(): cdktf.IResolvable;
    get prefix(): string;
    get transition(): cdktf.IResolvable;
}
export declare class DataOpentelekomcloudObsBucketLogging extends cdktf.ComplexComputedList {
    get targetBucket(): string;
    get targetPrefix(): string;
}
export declare class DataOpentelekomcloudObsBucketServerSideEncryption extends cdktf.ComplexComputedList {
    get algorithm(): string;
    get kmsKeyId(): string;
}
export declare class DataOpentelekomcloudObsBucketWebsite extends cdktf.ComplexComputedList {
    get errorDocument(): string;
    get indexDocument(): string;
    get redirectAllRequestsTo(): string;
    get routingRules(): string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/obs_bucket opentelekomcloud_obs_bucket}
*/
export declare class DataOpentelekomcloudObsBucket extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/obs_bucket opentelekomcloud_obs_bucket} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataOpentelekomcloudObsBucketConfig
    */
    constructor(scope: Construct, id: string, config: DataOpentelekomcloudObsBucketConfig);
    private _bucket?;
    get bucket(): string;
    set bucket(value: string);
    get bucketInput(): string | undefined;
    get bucketDomainName(): string;
    corsRule(index: string): DataOpentelekomcloudObsBucketCorsRule;
    eventNotifications(index: string): DataOpentelekomcloudObsBucketEventNotifications;
    get id(): string;
    lifecycleRule(index: string): DataOpentelekomcloudObsBucketLifecycleRule;
    logging(index: string): DataOpentelekomcloudObsBucketLogging;
    get region(): string;
    serverSideEncryption(index: string): DataOpentelekomcloudObsBucketServerSideEncryption;
    get storageClass(): string;
    tags(key: string): string | cdktf.IResolvable;
    get versioning(): cdktf.IResolvable;
    website(index: string): DataOpentelekomcloudObsBucketWebsite;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
