import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataOpentelekomcloudVpcepServiceV1Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/vpcep_service_v1#name DataOpentelekomcloudVpcepServiceV1#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/vpcep_service_v1#status DataOpentelekomcloudVpcepServiceV1#status}
    */
    readonly status?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/vpcep_service_v1#tags DataOpentelekomcloudVpcepServiceV1#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
}
export declare class DataOpentelekomcloudVpcepServiceV1Port extends cdktf.ComplexComputedList {
    get clientPort(): number;
    get protocol(): string;
    get serverPort(): number;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/vpcep_service_v1 opentelekomcloud_vpcep_service_v1}
*/
export declare class DataOpentelekomcloudVpcepServiceV1 extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/vpcep_service_v1 opentelekomcloud_vpcep_service_v1} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataOpentelekomcloudVpcepServiceV1Config = {}
    */
    constructor(scope: Construct, id: string, config?: DataOpentelekomcloudVpcepServiceV1Config);
    get approvalEnabled(): cdktf.IResolvable;
    get connectionCount(): number;
    get createdAt(): string;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    port(index: string): DataOpentelekomcloudVpcepServiceV1Port;
    get portId(): string;
    get projectId(): string;
    get serverType(): string;
    get serviceType(): string;
    private _status?;
    get status(): string;
    set status(value: string);
    resetStatus(): void;
    get statusInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    get tcpProxy(): string;
    get updatedAt(): string;
    get vipPortId(): string;
    get vpcId(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
