import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DdsInstanceV3Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dds_instance_v3#availability_zone DdsInstanceV3#availability_zone}
    */
    readonly availabilityZone: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dds_instance_v3#disk_encryption_id DdsInstanceV3#disk_encryption_id}
    */
    readonly diskEncryptionId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dds_instance_v3#mode DdsInstanceV3#mode}
    */
    readonly mode: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dds_instance_v3#name DdsInstanceV3#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dds_instance_v3#password DdsInstanceV3#password}
    */
    readonly password: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dds_instance_v3#region DdsInstanceV3#region}
    */
    readonly region?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dds_instance_v3#security_group_id DdsInstanceV3#security_group_id}
    */
    readonly securityGroupId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dds_instance_v3#ssl DdsInstanceV3#ssl}
    */
    readonly ssl?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dds_instance_v3#subnet_id DdsInstanceV3#subnet_id}
    */
    readonly subnetId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dds_instance_v3#vpc_id DdsInstanceV3#vpc_id}
    */
    readonly vpcId: string;
    /**
    * backup_strategy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dds_instance_v3#backup_strategy DdsInstanceV3#backup_strategy}
    */
    readonly backupStrategy?: DdsInstanceV3BackupStrategy;
    /**
    * datastore block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dds_instance_v3#datastore DdsInstanceV3#datastore}
    */
    readonly datastore: DdsInstanceV3Datastore;
    /**
    * flavor block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dds_instance_v3#flavor DdsInstanceV3#flavor}
    */
    readonly flavor: DdsInstanceV3Flavor[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dds_instance_v3#timeouts DdsInstanceV3#timeouts}
    */
    readonly timeouts?: DdsInstanceV3Timeouts;
}
export declare class DdsInstanceV3Nodes extends cdktf.ComplexComputedList {
    get id(): string;
    get name(): string;
    get privateIp(): string;
    get publicIp(): string;
    get role(): string;
    get status(): string;
    get type(): string;
}
export interface DdsInstanceV3BackupStrategy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dds_instance_v3#keep_days DdsInstanceV3#keep_days}
    */
    readonly keepDays: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dds_instance_v3#start_time DdsInstanceV3#start_time}
    */
    readonly startTime: string;
}
export declare function ddsInstanceV3BackupStrategyToTerraform(struct?: DdsInstanceV3BackupStrategyOutputReference | DdsInstanceV3BackupStrategy): any;
export declare class DdsInstanceV3BackupStrategyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DdsInstanceV3BackupStrategy | undefined;
    set internalValue(value: DdsInstanceV3BackupStrategy | undefined);
    private _keepDays?;
    get keepDays(): number;
    set keepDays(value: number);
    get keepDaysInput(): number | undefined;
    private _startTime?;
    get startTime(): string;
    set startTime(value: string);
    get startTimeInput(): string | undefined;
}
export interface DdsInstanceV3Datastore {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dds_instance_v3#storage_engine DdsInstanceV3#storage_engine}
    */
    readonly storageEngine?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dds_instance_v3#type DdsInstanceV3#type}
    */
    readonly type: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dds_instance_v3#version DdsInstanceV3#version}
    */
    readonly version: string;
}
export declare function ddsInstanceV3DatastoreToTerraform(struct?: DdsInstanceV3DatastoreOutputReference | DdsInstanceV3Datastore): any;
export declare class DdsInstanceV3DatastoreOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DdsInstanceV3Datastore | undefined;
    set internalValue(value: DdsInstanceV3Datastore | undefined);
    private _storageEngine?;
    get storageEngine(): string;
    set storageEngine(value: string);
    resetStorageEngine(): void;
    get storageEngineInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    get versionInput(): string | undefined;
}
export interface DdsInstanceV3Flavor {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dds_instance_v3#num DdsInstanceV3#num}
    */
    readonly num: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dds_instance_v3#size DdsInstanceV3#size}
    */
    readonly size?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dds_instance_v3#spec_code DdsInstanceV3#spec_code}
    */
    readonly specCode: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dds_instance_v3#storage DdsInstanceV3#storage}
    */
    readonly storage?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dds_instance_v3#type DdsInstanceV3#type}
    */
    readonly type: string;
}
export declare function ddsInstanceV3FlavorToTerraform(struct?: DdsInstanceV3Flavor | cdktf.IResolvable): any;
export interface DdsInstanceV3Timeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dds_instance_v3#create DdsInstanceV3#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dds_instance_v3#delete DdsInstanceV3#delete}
    */
    readonly delete?: string;
}
export declare function ddsInstanceV3TimeoutsToTerraform(struct?: DdsInstanceV3TimeoutsOutputReference | DdsInstanceV3Timeouts | cdktf.IResolvable): any;
export declare class DdsInstanceV3TimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DdsInstanceV3Timeouts | undefined;
    set internalValue(value: DdsInstanceV3Timeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dds_instance_v3 opentelekomcloud_dds_instance_v3}
*/
export declare class DdsInstanceV3 extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dds_instance_v3 opentelekomcloud_dds_instance_v3} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DdsInstanceV3Config
    */
    constructor(scope: Construct, id: string, config: DdsInstanceV3Config);
    private _availabilityZone?;
    get availabilityZone(): string;
    set availabilityZone(value: string);
    get availabilityZoneInput(): string | undefined;
    get dbUsername(): string;
    private _diskEncryptionId?;
    get diskEncryptionId(): string;
    set diskEncryptionId(value: string);
    resetDiskEncryptionId(): void;
    get diskEncryptionIdInput(): string | undefined;
    get id(): string;
    private _mode?;
    get mode(): string;
    set mode(value: string);
    get modeInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    nodes(index: string): DdsInstanceV3Nodes;
    private _password?;
    get password(): string;
    set password(value: string);
    get passwordInput(): string | undefined;
    get payMode(): string;
    get port(): number;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _securityGroupId?;
    get securityGroupId(): string;
    set securityGroupId(value: string);
    get securityGroupIdInput(): string | undefined;
    private _ssl?;
    get ssl(): boolean | cdktf.IResolvable;
    set ssl(value: boolean | cdktf.IResolvable);
    resetSsl(): void;
    get sslInput(): boolean | cdktf.IResolvable | undefined;
    get status(): string;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    get subnetIdInput(): string | undefined;
    private _vpcId?;
    get vpcId(): string;
    set vpcId(value: string);
    get vpcIdInput(): string | undefined;
    private _backupStrategy;
    get backupStrategy(): DdsInstanceV3BackupStrategyOutputReference;
    putBackupStrategy(value: DdsInstanceV3BackupStrategy): void;
    resetBackupStrategy(): void;
    get backupStrategyInput(): DdsInstanceV3BackupStrategy | undefined;
    private _datastore;
    get datastore(): DdsInstanceV3DatastoreOutputReference;
    putDatastore(value: DdsInstanceV3Datastore): void;
    get datastoreInput(): DdsInstanceV3Datastore | undefined;
    private _flavor?;
    get flavor(): DdsInstanceV3Flavor[] | cdktf.IResolvable;
    set flavor(value: DdsInstanceV3Flavor[] | cdktf.IResolvable);
    get flavorInput(): cdktf.IResolvable | DdsInstanceV3Flavor[] | undefined;
    private _timeouts;
    get timeouts(): DdsInstanceV3TimeoutsOutputReference;
    putTimeouts(value: DdsInstanceV3Timeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DdsInstanceV3Timeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
