import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DehHostV1Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/deh_host_v1#auto_placement DehHostV1#auto_placement}
    */
    readonly autoPlacement?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/deh_host_v1#availability_zone DehHostV1#availability_zone}
    */
    readonly availabilityZone: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/deh_host_v1#available_memory DehHostV1#available_memory}
    */
    readonly availableMemory?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/deh_host_v1#available_vcpus DehHostV1#available_vcpus}
    */
    readonly availableVcpus?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/deh_host_v1#cores DehHostV1#cores}
    */
    readonly cores?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/deh_host_v1#host_type DehHostV1#host_type}
    */
    readonly hostType: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/deh_host_v1#host_type_name DehHostV1#host_type_name}
    */
    readonly hostTypeName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/deh_host_v1#instance_total DehHostV1#instance_total}
    */
    readonly instanceTotal?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/deh_host_v1#instance_uuids DehHostV1#instance_uuids}
    */
    readonly instanceUuids?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/deh_host_v1#memory DehHostV1#memory}
    */
    readonly memory?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/deh_host_v1#name DehHostV1#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/deh_host_v1#region DehHostV1#region}
    */
    readonly region?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/deh_host_v1#sockets DehHostV1#sockets}
    */
    readonly sockets?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/deh_host_v1#status DehHostV1#status}
    */
    readonly status?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/deh_host_v1#vcpus DehHostV1#vcpus}
    */
    readonly vcpus?: number;
    /**
    * available_instance_capacities block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/deh_host_v1#available_instance_capacities DehHostV1#available_instance_capacities}
    */
    readonly availableInstanceCapacities?: DehHostV1AvailableInstanceCapacities[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/deh_host_v1#timeouts DehHostV1#timeouts}
    */
    readonly timeouts?: DehHostV1Timeouts;
}
export interface DehHostV1AvailableInstanceCapacities {
}
export declare function dehHostV1AvailableInstanceCapacitiesToTerraform(struct?: DehHostV1AvailableInstanceCapacities | cdktf.IResolvable): any;
export interface DehHostV1Timeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/deh_host_v1#create DehHostV1#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/deh_host_v1#delete DehHostV1#delete}
    */
    readonly delete?: string;
}
export declare function dehHostV1TimeoutsToTerraform(struct?: DehHostV1TimeoutsOutputReference | DehHostV1Timeouts | cdktf.IResolvable): any;
export declare class DehHostV1TimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DehHostV1Timeouts | undefined;
    set internalValue(value: DehHostV1Timeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/deh_host_v1 opentelekomcloud_deh_host_v1}
*/
export declare class DehHostV1 extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/deh_host_v1 opentelekomcloud_deh_host_v1} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DehHostV1Config
    */
    constructor(scope: Construct, id: string, config: DehHostV1Config);
    private _autoPlacement?;
    get autoPlacement(): string;
    set autoPlacement(value: string);
    resetAutoPlacement(): void;
    get autoPlacementInput(): string | undefined;
    private _availabilityZone?;
    get availabilityZone(): string;
    set availabilityZone(value: string);
    get availabilityZoneInput(): string | undefined;
    private _availableMemory?;
    get availableMemory(): number;
    set availableMemory(value: number);
    resetAvailableMemory(): void;
    get availableMemoryInput(): number | undefined;
    private _availableVcpus?;
    get availableVcpus(): number;
    set availableVcpus(value: number);
    resetAvailableVcpus(): void;
    get availableVcpusInput(): number | undefined;
    private _cores?;
    get cores(): number;
    set cores(value: number);
    resetCores(): void;
    get coresInput(): number | undefined;
    private _hostType?;
    get hostType(): string;
    set hostType(value: string);
    get hostTypeInput(): string | undefined;
    private _hostTypeName?;
    get hostTypeName(): string;
    set hostTypeName(value: string);
    resetHostTypeName(): void;
    get hostTypeNameInput(): string | undefined;
    get id(): string;
    private _instanceTotal?;
    get instanceTotal(): number;
    set instanceTotal(value: number);
    resetInstanceTotal(): void;
    get instanceTotalInput(): number | undefined;
    private _instanceUuids?;
    get instanceUuids(): string[];
    set instanceUuids(value: string[]);
    resetInstanceUuids(): void;
    get instanceUuidsInput(): string[] | undefined;
    private _memory?;
    get memory(): number;
    set memory(value: number);
    resetMemory(): void;
    get memoryInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _sockets?;
    get sockets(): number;
    set sockets(value: number);
    resetSockets(): void;
    get socketsInput(): number | undefined;
    private _status?;
    get status(): string;
    set status(value: string);
    resetStatus(): void;
    get statusInput(): string | undefined;
    private _vcpus?;
    get vcpus(): number;
    set vcpus(value: number);
    resetVcpus(): void;
    get vcpusInput(): number | undefined;
    private _availableInstanceCapacities?;
    get availableInstanceCapacities(): DehHostV1AvailableInstanceCapacities[] | cdktf.IResolvable;
    set availableInstanceCapacities(value: DehHostV1AvailableInstanceCapacities[] | cdktf.IResolvable);
    resetAvailableInstanceCapacities(): void;
    get availableInstanceCapacitiesInput(): cdktf.IResolvable | DehHostV1AvailableInstanceCapacities[] | undefined;
    private _timeouts;
    get timeouts(): DehHostV1TimeoutsOutputReference;
    putTimeouts(value: DehHostV1Timeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DehHostV1Timeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
