import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DmsGroupV1Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dms_group_v1#name DmsGroupV1#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dms_group_v1#queue_id DmsGroupV1#queue_id}
    */
    readonly queueId: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dms_group_v1 opentelekomcloud_dms_group_v1}
*/
export declare class DmsGroupV1 extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dms_group_v1 opentelekomcloud_dms_group_v1} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DmsGroupV1Config
    */
    constructor(scope: Construct, id: string, config: DmsGroupV1Config);
    get availableDeadletters(): number;
    get availableMessages(): number;
    get consumedMessages(): number;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get producedDeadletters(): number;
    get producedMessages(): number;
    private _queueId?;
    get queueId(): string;
    set queueId(value: string);
    get queueIdInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
