import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DmsInstanceV1Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dms_instance_v1#access_user DmsInstanceV1#access_user}
    */
    readonly accessUser?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dms_instance_v1#available_zones DmsInstanceV1#available_zones}
    */
    readonly availableZones: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dms_instance_v1#description DmsInstanceV1#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dms_instance_v1#engine DmsInstanceV1#engine}
    */
    readonly engine: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dms_instance_v1#engine_version DmsInstanceV1#engine_version}
    */
    readonly engineVersion: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dms_instance_v1#maintain_begin DmsInstanceV1#maintain_begin}
    */
    readonly maintainBegin?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dms_instance_v1#maintain_end DmsInstanceV1#maintain_end}
    */
    readonly maintainEnd?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dms_instance_v1#name DmsInstanceV1#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dms_instance_v1#partition_num DmsInstanceV1#partition_num}
    */
    readonly partitionNum?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dms_instance_v1#password DmsInstanceV1#password}
    */
    readonly password?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dms_instance_v1#product_id DmsInstanceV1#product_id}
    */
    readonly productId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dms_instance_v1#retention_policy DmsInstanceV1#retention_policy}
    */
    readonly retentionPolicy?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dms_instance_v1#security_group_id DmsInstanceV1#security_group_id}
    */
    readonly securityGroupId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dms_instance_v1#specification DmsInstanceV1#specification}
    */
    readonly specification?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dms_instance_v1#storage_space DmsInstanceV1#storage_space}
    */
    readonly storageSpace: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dms_instance_v1#storage_spec_code DmsInstanceV1#storage_spec_code}
    */
    readonly storageSpecCode: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dms_instance_v1#subnet_id DmsInstanceV1#subnet_id}
    */
    readonly subnetId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dms_instance_v1#vpc_id DmsInstanceV1#vpc_id}
    */
    readonly vpcId: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dms_instance_v1 opentelekomcloud_dms_instance_v1}
*/
export declare class DmsInstanceV1 extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dms_instance_v1 opentelekomcloud_dms_instance_v1} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DmsInstanceV1Config
    */
    constructor(scope: Construct, id: string, config: DmsInstanceV1Config);
    private _accessUser?;
    get accessUser(): string;
    set accessUser(value: string);
    resetAccessUser(): void;
    get accessUserInput(): string | undefined;
    private _availableZones?;
    get availableZones(): string[];
    set availableZones(value: string[]);
    get availableZonesInput(): string[] | undefined;
    get connectAddress(): string;
    get createdAt(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _engine?;
    get engine(): string;
    set engine(value: string);
    get engineInput(): string | undefined;
    private _engineVersion?;
    get engineVersion(): string;
    set engineVersion(value: string);
    get engineVersionInput(): string | undefined;
    get id(): string;
    private _maintainBegin?;
    get maintainBegin(): string;
    set maintainBegin(value: string);
    resetMaintainBegin(): void;
    get maintainBeginInput(): string | undefined;
    private _maintainEnd?;
    get maintainEnd(): string;
    set maintainEnd(value: string);
    resetMaintainEnd(): void;
    get maintainEndInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get orderId(): string;
    private _partitionNum?;
    get partitionNum(): number;
    set partitionNum(value: number);
    resetPartitionNum(): void;
    get partitionNumInput(): number | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    get port(): number;
    private _productId?;
    get productId(): string;
    set productId(value: string);
    get productIdInput(): string | undefined;
    get resourceSpecCode(): string;
    private _retentionPolicy?;
    get retentionPolicy(): string;
    set retentionPolicy(value: string);
    resetRetentionPolicy(): void;
    get retentionPolicyInput(): string | undefined;
    private _securityGroupId?;
    get securityGroupId(): string;
    set securityGroupId(value: string);
    get securityGroupIdInput(): string | undefined;
    get securityGroupName(): string;
    private _specification?;
    get specification(): string;
    set specification(value: string);
    resetSpecification(): void;
    get specificationInput(): string | undefined;
    get status(): string;
    private _storageSpace?;
    get storageSpace(): number;
    set storageSpace(value: number);
    get storageSpaceInput(): number | undefined;
    private _storageSpecCode?;
    get storageSpecCode(): string;
    set storageSpecCode(value: string);
    get storageSpecCodeInput(): string | undefined;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    get subnetIdInput(): string | undefined;
    get subnetName(): string;
    get type(): string;
    get usedStorageSpace(): number;
    get userId(): string;
    get userName(): string;
    private _vpcId?;
    get vpcId(): string;
    set vpcId(value: string);
    get vpcIdInput(): string | undefined;
    get vpcName(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
