import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DnsZoneV2Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dns_zone_v2#description DnsZoneV2#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dns_zone_v2#email DnsZoneV2#email}
    */
    readonly email?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dns_zone_v2#name DnsZoneV2#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dns_zone_v2#region DnsZoneV2#region}
    */
    readonly region?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dns_zone_v2#tags DnsZoneV2#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dns_zone_v2#ttl DnsZoneV2#ttl}
    */
    readonly ttl?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dns_zone_v2#type DnsZoneV2#type}
    */
    readonly type?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dns_zone_v2#value_specs DnsZoneV2#value_specs}
    */
    readonly valueSpecs?: {
        [key: string]: string;
    };
    /**
    * router block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dns_zone_v2#router DnsZoneV2#router}
    */
    readonly router?: DnsZoneV2Router[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dns_zone_v2#timeouts DnsZoneV2#timeouts}
    */
    readonly timeouts?: DnsZoneV2Timeouts;
}
export interface DnsZoneV2Router {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dns_zone_v2#router_id DnsZoneV2#router_id}
    */
    readonly routerId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dns_zone_v2#router_region DnsZoneV2#router_region}
    */
    readonly routerRegion: string;
}
export declare function dnsZoneV2RouterToTerraform(struct?: DnsZoneV2Router | cdktf.IResolvable): any;
export interface DnsZoneV2Timeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dns_zone_v2#create DnsZoneV2#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dns_zone_v2#delete DnsZoneV2#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dns_zone_v2#update DnsZoneV2#update}
    */
    readonly update?: string;
}
export declare function dnsZoneV2TimeoutsToTerraform(struct?: DnsZoneV2TimeoutsOutputReference | DnsZoneV2Timeouts | cdktf.IResolvable): any;
export declare class DnsZoneV2TimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DnsZoneV2Timeouts | undefined;
    set internalValue(value: DnsZoneV2Timeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dns_zone_v2 opentelekomcloud_dns_zone_v2}
*/
export declare class DnsZoneV2 extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dns_zone_v2 opentelekomcloud_dns_zone_v2} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DnsZoneV2Config
    */
    constructor(scope: Construct, id: string, config: DnsZoneV2Config);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _email?;
    get email(): string;
    set email(value: string);
    resetEmail(): void;
    get emailInput(): string | undefined;
    get id(): string;
    get masters(): string[];
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _ttl?;
    get ttl(): number;
    set ttl(value: number);
    resetTtl(): void;
    get ttlInput(): number | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    private _valueSpecs?;
    get valueSpecs(): {
        [key: string]: string;
    };
    set valueSpecs(value: {
        [key: string]: string;
    });
    resetValueSpecs(): void;
    get valueSpecsInput(): {
        [key: string]: string;
    } | undefined;
    private _router?;
    get router(): DnsZoneV2Router[] | cdktf.IResolvable;
    set router(value: DnsZoneV2Router[] | cdktf.IResolvable);
    resetRouter(): void;
    get routerInput(): cdktf.IResolvable | DnsZoneV2Router[] | undefined;
    private _timeouts;
    get timeouts(): DnsZoneV2TimeoutsOutputReference;
    putTimeouts(value: DnsZoneV2Timeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DnsZoneV2Timeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
