import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface EvsVolumeV3Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/evs_volume_v3#availability_zone EvsVolumeV3#availability_zone}
    */
    readonly availabilityZone: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/evs_volume_v3#backup_id EvsVolumeV3#backup_id}
    */
    readonly backupId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/evs_volume_v3#cascade EvsVolumeV3#cascade}
    */
    readonly cascade?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/evs_volume_v3#description EvsVolumeV3#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/evs_volume_v3#device_type EvsVolumeV3#device_type}
    */
    readonly deviceType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/evs_volume_v3#image_id EvsVolumeV3#image_id}
    */
    readonly imageId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/evs_volume_v3#kms_id EvsVolumeV3#kms_id}
    */
    readonly kmsId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/evs_volume_v3#multiattach EvsVolumeV3#multiattach}
    */
    readonly multiattach?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/evs_volume_v3#name EvsVolumeV3#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/evs_volume_v3#size EvsVolumeV3#size}
    */
    readonly size?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/evs_volume_v3#snapshot_id EvsVolumeV3#snapshot_id}
    */
    readonly snapshotId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/evs_volume_v3#tags EvsVolumeV3#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/evs_volume_v3#volume_type EvsVolumeV3#volume_type}
    */
    readonly volumeType: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/evs_volume_v3#timeouts EvsVolumeV3#timeouts}
    */
    readonly timeouts?: EvsVolumeV3Timeouts;
}
export declare class EvsVolumeV3Attachment extends cdktf.ComplexComputedList {
    get device(): string;
    get id(): string;
    get instanceId(): string;
}
export interface EvsVolumeV3Timeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/evs_volume_v3#create EvsVolumeV3#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/evs_volume_v3#delete EvsVolumeV3#delete}
    */
    readonly delete?: string;
}
export declare function evsVolumeV3TimeoutsToTerraform(struct?: EvsVolumeV3TimeoutsOutputReference | EvsVolumeV3Timeouts | cdktf.IResolvable): any;
export declare class EvsVolumeV3TimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): EvsVolumeV3Timeouts | undefined;
    set internalValue(value: EvsVolumeV3Timeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/evs_volume_v3 opentelekomcloud_evs_volume_v3}
*/
export declare class EvsVolumeV3 extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/evs_volume_v3 opentelekomcloud_evs_volume_v3} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options EvsVolumeV3Config
    */
    constructor(scope: Construct, id: string, config: EvsVolumeV3Config);
    attachment(index: string): EvsVolumeV3Attachment;
    private _availabilityZone?;
    get availabilityZone(): string;
    set availabilityZone(value: string);
    get availabilityZoneInput(): string | undefined;
    private _backupId?;
    get backupId(): string;
    set backupId(value: string);
    resetBackupId(): void;
    get backupIdInput(): string | undefined;
    private _cascade?;
    get cascade(): boolean | cdktf.IResolvable;
    set cascade(value: boolean | cdktf.IResolvable);
    resetCascade(): void;
    get cascadeInput(): boolean | cdktf.IResolvable | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _deviceType?;
    get deviceType(): string;
    set deviceType(value: string);
    resetDeviceType(): void;
    get deviceTypeInput(): string | undefined;
    get id(): string;
    private _imageId?;
    get imageId(): string;
    set imageId(value: string);
    resetImageId(): void;
    get imageIdInput(): string | undefined;
    private _kmsId?;
    get kmsId(): string;
    set kmsId(value: string);
    resetKmsId(): void;
    get kmsIdInput(): string | undefined;
    private _multiattach?;
    get multiattach(): boolean | cdktf.IResolvable;
    set multiattach(value: boolean | cdktf.IResolvable);
    resetMultiattach(): void;
    get multiattachInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _size?;
    get size(): number;
    set size(value: number);
    resetSize(): void;
    get sizeInput(): number | undefined;
    private _snapshotId?;
    get snapshotId(): string;
    set snapshotId(value: string);
    resetSnapshotId(): void;
    get snapshotIdInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _volumeType?;
    get volumeType(): string;
    set volumeType(value: string);
    get volumeTypeInput(): string | undefined;
    get wwn(): string;
    private _timeouts;
    get timeouts(): EvsVolumeV3TimeoutsOutputReference;
    putTimeouts(value: EvsVolumeV3Timeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): EvsVolumeV3Timeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
