import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface FwPolicyV2Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/fw_policy_v2#audited FwPolicyV2#audited}
    */
    readonly audited?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/fw_policy_v2#description FwPolicyV2#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/fw_policy_v2#name FwPolicyV2#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/fw_policy_v2#region FwPolicyV2#region}
    */
    readonly region?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/fw_policy_v2#rules FwPolicyV2#rules}
    */
    readonly rules?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/fw_policy_v2#shared FwPolicyV2#shared}
    */
    readonly shared?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/fw_policy_v2#tenant_id FwPolicyV2#tenant_id}
    */
    readonly tenantId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/fw_policy_v2#value_specs FwPolicyV2#value_specs}
    */
    readonly valueSpecs?: {
        [key: string]: string;
    };
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/fw_policy_v2#timeouts FwPolicyV2#timeouts}
    */
    readonly timeouts?: FwPolicyV2Timeouts;
}
export interface FwPolicyV2Timeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/fw_policy_v2#create FwPolicyV2#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/fw_policy_v2#delete FwPolicyV2#delete}
    */
    readonly delete?: string;
}
export declare function fwPolicyV2TimeoutsToTerraform(struct?: FwPolicyV2TimeoutsOutputReference | FwPolicyV2Timeouts | cdktf.IResolvable): any;
export declare class FwPolicyV2TimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): FwPolicyV2Timeouts | undefined;
    set internalValue(value: FwPolicyV2Timeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/fw_policy_v2 opentelekomcloud_fw_policy_v2}
*/
export declare class FwPolicyV2 extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/fw_policy_v2 opentelekomcloud_fw_policy_v2} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options FwPolicyV2Config = {}
    */
    constructor(scope: Construct, id: string, config?: FwPolicyV2Config);
    private _audited?;
    get audited(): boolean | cdktf.IResolvable;
    set audited(value: boolean | cdktf.IResolvable);
    resetAudited(): void;
    get auditedInput(): boolean | cdktf.IResolvable | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _rules?;
    get rules(): string[];
    set rules(value: string[]);
    resetRules(): void;
    get rulesInput(): string[] | undefined;
    private _shared?;
    get shared(): boolean | cdktf.IResolvable;
    set shared(value: boolean | cdktf.IResolvable);
    resetShared(): void;
    get sharedInput(): boolean | cdktf.IResolvable | undefined;
    private _tenantId?;
    get tenantId(): string;
    set tenantId(value: string);
    resetTenantId(): void;
    get tenantIdInput(): string | undefined;
    private _valueSpecs?;
    get valueSpecs(): {
        [key: string]: string;
    };
    set valueSpecs(value: {
        [key: string]: string;
    });
    resetValueSpecs(): void;
    get valueSpecsInput(): {
        [key: string]: string;
    } | undefined;
    private _timeouts;
    get timeouts(): FwPolicyV2TimeoutsOutputReference;
    putTimeouts(value: FwPolicyV2Timeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): FwPolicyV2Timeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
