import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface IdentityProtocolV3Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_protocol_v3#mapping_id IdentityProtocolV3#mapping_id}
    */
    readonly mappingId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_protocol_v3#protocol IdentityProtocolV3#protocol}
    */
    readonly protocol: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_protocol_v3#provider_id IdentityProtocolV3#provider_id}
    */
    readonly providerId: string;
    /**
    * metadata block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_protocol_v3#metadata IdentityProtocolV3#metadata}
    */
    readonly metadata?: IdentityProtocolV3Metadata;
}
export interface IdentityProtocolV3Metadata {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_protocol_v3#domain_id IdentityProtocolV3#domain_id}
    */
    readonly domainId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_protocol_v3#metadata IdentityProtocolV3#metadata}
    */
    readonly metadata: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_protocol_v3#xaccount_type IdentityProtocolV3#xaccount_type}
    */
    readonly xaccountType?: string;
}
export declare function identityProtocolV3MetadataToTerraform(struct?: IdentityProtocolV3MetadataOutputReference | IdentityProtocolV3Metadata): any;
export declare class IdentityProtocolV3MetadataOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): IdentityProtocolV3Metadata | undefined;
    set internalValue(value: IdentityProtocolV3Metadata | undefined);
    private _domainId?;
    get domainId(): string;
    set domainId(value: string);
    get domainIdInput(): string | undefined;
    private _metadata?;
    get metadata(): string;
    set metadata(value: string);
    get metadataInput(): string | undefined;
    private _xaccountType?;
    get xaccountType(): string;
    set xaccountType(value: string);
    resetXaccountType(): void;
    get xaccountTypeInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_protocol_v3 opentelekomcloud_identity_protocol_v3}
*/
export declare class IdentityProtocolV3 extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_protocol_v3 opentelekomcloud_identity_protocol_v3} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options IdentityProtocolV3Config
    */
    constructor(scope: Construct, id: string, config: IdentityProtocolV3Config);
    get id(): string;
    links(key: string): string | cdktf.IResolvable;
    private _mappingId?;
    get mappingId(): string;
    set mappingId(value: string);
    get mappingIdInput(): string | undefined;
    private _protocol?;
    get protocol(): string;
    set protocol(value: string);
    get protocolInput(): string | undefined;
    private _providerId?;
    get providerId(): string;
    set providerId(value: string);
    get providerIdInput(): string | undefined;
    private _metadata;
    get metadata(): IdentityProtocolV3MetadataOutputReference;
    putMetadata(value: IdentityProtocolV3Metadata): void;
    resetMetadata(): void;
    get metadataInput(): IdentityProtocolV3Metadata | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
