import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface IdentityRoleV3Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_role_v3#description IdentityRoleV3#description}
    */
    readonly description: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_role_v3#display_layer IdentityRoleV3#display_layer}
    */
    readonly displayLayer: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_role_v3#display_name IdentityRoleV3#display_name}
    */
    readonly displayName: string;
    /**
    * statement block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_role_v3#statement IdentityRoleV3#statement}
    */
    readonly statement: IdentityRoleV3Statement[] | cdktf.IResolvable;
}
export interface IdentityRoleV3Statement {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_role_v3#action IdentityRoleV3#action}
    */
    readonly action: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_role_v3#effect IdentityRoleV3#effect}
    */
    readonly effect: string;
}
export declare function identityRoleV3StatementToTerraform(struct?: IdentityRoleV3Statement | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_role_v3 opentelekomcloud_identity_role_v3}
*/
export declare class IdentityRoleV3 extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_role_v3 opentelekomcloud_identity_role_v3} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options IdentityRoleV3Config
    */
    constructor(scope: Construct, id: string, config: IdentityRoleV3Config);
    get catalog(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    get descriptionInput(): string | undefined;
    private _displayLayer?;
    get displayLayer(): string;
    set displayLayer(value: string);
    get displayLayerInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    get domainId(): string;
    get id(): string;
    get name(): string;
    private _statement?;
    get statement(): IdentityRoleV3Statement[] | cdktf.IResolvable;
    set statement(value: IdentityRoleV3Statement[] | cdktf.IResolvable);
    get statementInput(): cdktf.IResolvable | IdentityRoleV3Statement[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
