import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ImagesImageV2Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/images_image_v2#container_format ImagesImageV2#container_format}
    */
    readonly containerFormat: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/images_image_v2#disk_format ImagesImageV2#disk_format}
    */
    readonly diskFormat: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/images_image_v2#image_cache_path ImagesImageV2#image_cache_path}
    */
    readonly imageCachePath?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/images_image_v2#image_source_url ImagesImageV2#image_source_url}
    */
    readonly imageSourceUrl?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/images_image_v2#local_file_path ImagesImageV2#local_file_path}
    */
    readonly localFilePath?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/images_image_v2#min_disk_gb ImagesImageV2#min_disk_gb}
    */
    readonly minDiskGb?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/images_image_v2#min_ram_mb ImagesImageV2#min_ram_mb}
    */
    readonly minRamMb?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/images_image_v2#name ImagesImageV2#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/images_image_v2#protected ImagesImageV2#protected}
    */
    readonly protected?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/images_image_v2#region ImagesImageV2#region}
    */
    readonly region?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/images_image_v2#tags ImagesImageV2#tags}
    */
    readonly tags?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/images_image_v2#visibility ImagesImageV2#visibility}
    */
    readonly visibility?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/images_image_v2#timeouts ImagesImageV2#timeouts}
    */
    readonly timeouts?: ImagesImageV2Timeouts;
}
export interface ImagesImageV2Timeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/images_image_v2#create ImagesImageV2#create}
    */
    readonly create?: string;
}
export declare function imagesImageV2TimeoutsToTerraform(struct?: ImagesImageV2TimeoutsOutputReference | ImagesImageV2Timeouts | cdktf.IResolvable): any;
export declare class ImagesImageV2TimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): ImagesImageV2Timeouts | undefined;
    set internalValue(value: ImagesImageV2Timeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/images_image_v2 opentelekomcloud_images_image_v2}
*/
export declare class ImagesImageV2 extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/images_image_v2 opentelekomcloud_images_image_v2} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ImagesImageV2Config
    */
    constructor(scope: Construct, id: string, config: ImagesImageV2Config);
    get checksum(): string;
    private _containerFormat?;
    get containerFormat(): string;
    set containerFormat(value: string);
    get containerFormatInput(): string | undefined;
    get createdAt(): string;
    private _diskFormat?;
    get diskFormat(): string;
    set diskFormat(value: string);
    get diskFormatInput(): string | undefined;
    get file(): string;
    get id(): string;
    private _imageCachePath?;
    get imageCachePath(): string;
    set imageCachePath(value: string);
    resetImageCachePath(): void;
    get imageCachePathInput(): string | undefined;
    private _imageSourceUrl?;
    get imageSourceUrl(): string;
    set imageSourceUrl(value: string);
    resetImageSourceUrl(): void;
    get imageSourceUrlInput(): string | undefined;
    private _localFilePath?;
    get localFilePath(): string;
    set localFilePath(value: string);
    resetLocalFilePath(): void;
    get localFilePathInput(): string | undefined;
    metadata(key: string): string | cdktf.IResolvable;
    private _minDiskGb?;
    get minDiskGb(): number;
    set minDiskGb(value: number);
    resetMinDiskGb(): void;
    get minDiskGbInput(): number | undefined;
    private _minRamMb?;
    get minRamMb(): number;
    set minRamMb(value: number);
    resetMinRamMb(): void;
    get minRamMbInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get owner(): string;
    private _protected?;
    get protected(): boolean | cdktf.IResolvable;
    set protected(value: boolean | cdktf.IResolvable);
    resetProtected(): void;
    get protectedInput(): boolean | cdktf.IResolvable | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    get schema(): string;
    get sizeBytes(): number;
    get status(): string;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    get updateAt(): string;
    private _visibility?;
    get visibility(): string;
    set visibility(value: string);
    resetVisibility(): void;
    get visibilityInput(): string | undefined;
    private _timeouts;
    get timeouts(): ImagesImageV2TimeoutsOutputReference;
    putTimeouts(value: ImagesImageV2Timeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): ImagesImageV2Timeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
