import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ImsImageV2Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ims_image_v2#cmk_id ImsImageV2#cmk_id}
    */
    readonly cmkId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ims_image_v2#description ImsImageV2#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ims_image_v2#image_url ImsImageV2#image_url}
    */
    readonly imageUrl?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ims_image_v2#instance_id ImsImageV2#instance_id}
    */
    readonly instanceId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ims_image_v2#is_config ImsImageV2#is_config}
    */
    readonly isConfig?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ims_image_v2#max_ram ImsImageV2#max_ram}
    */
    readonly maxRam?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ims_image_v2#min_disk ImsImageV2#min_disk}
    */
    readonly minDisk?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ims_image_v2#min_ram ImsImageV2#min_ram}
    */
    readonly minRam?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ims_image_v2#name ImsImageV2#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ims_image_v2#os_version ImsImageV2#os_version}
    */
    readonly osVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ims_image_v2#tags ImsImageV2#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ims_image_v2#type ImsImageV2#type}
    */
    readonly type?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ims_image_v2#timeouts ImsImageV2#timeouts}
    */
    readonly timeouts?: ImsImageV2Timeouts;
}
export interface ImsImageV2Timeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ims_image_v2#create ImsImageV2#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ims_image_v2#delete ImsImageV2#delete}
    */
    readonly delete?: string;
}
export declare function imsImageV2TimeoutsToTerraform(struct?: ImsImageV2TimeoutsOutputReference | ImsImageV2Timeouts | cdktf.IResolvable): any;
export declare class ImsImageV2TimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): ImsImageV2Timeouts | undefined;
    set internalValue(value: ImsImageV2Timeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ims_image_v2 opentelekomcloud_ims_image_v2}
*/
export declare class ImsImageV2 extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ims_image_v2 opentelekomcloud_ims_image_v2} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ImsImageV2Config
    */
    constructor(scope: Construct, id: string, config: ImsImageV2Config);
    private _cmkId?;
    get cmkId(): string;
    set cmkId(value: string);
    resetCmkId(): void;
    get cmkIdInput(): string | undefined;
    get dataOrigin(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get diskFormat(): string;
    get file(): string;
    get id(): string;
    get imageSize(): string;
    private _imageUrl?;
    get imageUrl(): string;
    set imageUrl(value: string);
    resetImageUrl(): void;
    get imageUrlInput(): string | undefined;
    private _instanceId?;
    get instanceId(): string;
    set instanceId(value: string);
    resetInstanceId(): void;
    get instanceIdInput(): string | undefined;
    private _isConfig?;
    get isConfig(): boolean | cdktf.IResolvable;
    set isConfig(value: boolean | cdktf.IResolvable);
    resetIsConfig(): void;
    get isConfigInput(): boolean | cdktf.IResolvable | undefined;
    private _maxRam?;
    get maxRam(): number;
    set maxRam(value: number);
    resetMaxRam(): void;
    get maxRamInput(): number | undefined;
    private _minDisk?;
    get minDisk(): number;
    set minDisk(value: number);
    resetMinDisk(): void;
    get minDiskInput(): number | undefined;
    private _minRam?;
    get minRam(): number;
    set minRam(value: number);
    resetMinRam(): void;
    get minRamInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _osVersion?;
    get osVersion(): string;
    set osVersion(value: string);
    resetOsVersion(): void;
    get osVersionInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    get visibility(): string;
    private _timeouts;
    get timeouts(): ImsImageV2TimeoutsOutputReference;
    putTimeouts(value: ImsImageV2Timeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): ImsImageV2Timeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
