import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface LbL7PolicyV2Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_l7policy_v2#action LbL7PolicyV2#action}
    */
    readonly action: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_l7policy_v2#admin_state_up LbL7PolicyV2#admin_state_up}
    */
    readonly adminStateUp?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_l7policy_v2#description LbL7PolicyV2#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_l7policy_v2#listener_id LbL7PolicyV2#listener_id}
    */
    readonly listenerId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_l7policy_v2#name LbL7PolicyV2#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_l7policy_v2#position LbL7PolicyV2#position}
    */
    readonly position?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_l7policy_v2#redirect_listener_id LbL7PolicyV2#redirect_listener_id}
    */
    readonly redirectListenerId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_l7policy_v2#redirect_pool_id LbL7PolicyV2#redirect_pool_id}
    */
    readonly redirectPoolId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_l7policy_v2#region LbL7PolicyV2#region}
    */
    readonly region?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_l7policy_v2#tenant_id LbL7PolicyV2#tenant_id}
    */
    readonly tenantId?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_l7policy_v2#timeouts LbL7PolicyV2#timeouts}
    */
    readonly timeouts?: LbL7PolicyV2Timeouts;
}
export interface LbL7PolicyV2Timeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_l7policy_v2#create LbL7PolicyV2#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_l7policy_v2#delete LbL7PolicyV2#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_l7policy_v2#update LbL7PolicyV2#update}
    */
    readonly update?: string;
}
export declare function lbL7PolicyV2TimeoutsToTerraform(struct?: LbL7PolicyV2TimeoutsOutputReference | LbL7PolicyV2Timeouts | cdktf.IResolvable): any;
export declare class LbL7PolicyV2TimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): LbL7PolicyV2Timeouts | undefined;
    set internalValue(value: LbL7PolicyV2Timeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_l7policy_v2 opentelekomcloud_lb_l7policy_v2}
*/
export declare class LbL7PolicyV2 extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_l7policy_v2 opentelekomcloud_lb_l7policy_v2} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options LbL7PolicyV2Config
    */
    constructor(scope: Construct, id: string, config: LbL7PolicyV2Config);
    private _action?;
    get action(): string;
    set action(value: string);
    get actionInput(): string | undefined;
    private _adminStateUp?;
    get adminStateUp(): boolean | cdktf.IResolvable;
    set adminStateUp(value: boolean | cdktf.IResolvable);
    resetAdminStateUp(): void;
    get adminStateUpInput(): boolean | cdktf.IResolvable | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    private _listenerId?;
    get listenerId(): string;
    set listenerId(value: string);
    get listenerIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _position?;
    get position(): number;
    set position(value: number);
    resetPosition(): void;
    get positionInput(): number | undefined;
    private _redirectListenerId?;
    get redirectListenerId(): string;
    set redirectListenerId(value: string);
    resetRedirectListenerId(): void;
    get redirectListenerIdInput(): string | undefined;
    private _redirectPoolId?;
    get redirectPoolId(): string;
    set redirectPoolId(value: string);
    resetRedirectPoolId(): void;
    get redirectPoolIdInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _tenantId?;
    get tenantId(): string;
    set tenantId(value: string);
    resetTenantId(): void;
    get tenantIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): LbL7PolicyV2TimeoutsOutputReference;
    putTimeouts(value: LbL7PolicyV2Timeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): LbL7PolicyV2Timeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
