import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface LbListenerV2Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_listener_v2#admin_state_up LbListenerV2#admin_state_up}
    */
    readonly adminStateUp?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_listener_v2#client_ca_tls_container_ref LbListenerV2#client_ca_tls_container_ref}
    */
    readonly clientCaTlsContainerRef?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_listener_v2#default_pool_id LbListenerV2#default_pool_id}
    */
    readonly defaultPoolId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_listener_v2#default_tls_container_ref LbListenerV2#default_tls_container_ref}
    */
    readonly defaultTlsContainerRef?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_listener_v2#description LbListenerV2#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_listener_v2#http2_enable LbListenerV2#http2_enable}
    */
    readonly http2Enable?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_listener_v2#loadbalancer_id LbListenerV2#loadbalancer_id}
    */
    readonly loadbalancerId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_listener_v2#name LbListenerV2#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_listener_v2#protocol LbListenerV2#protocol}
    */
    readonly protocol: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_listener_v2#protocol_port LbListenerV2#protocol_port}
    */
    readonly protocolPort: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_listener_v2#region LbListenerV2#region}
    */
    readonly region?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_listener_v2#sni_container_refs LbListenerV2#sni_container_refs}
    */
    readonly sniContainerRefs?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_listener_v2#tags LbListenerV2#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_listener_v2#tenant_id LbListenerV2#tenant_id}
    */
    readonly tenantId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_listener_v2#tls_ciphers_policy LbListenerV2#tls_ciphers_policy}
    */
    readonly tlsCiphersPolicy?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_listener_v2#timeouts LbListenerV2#timeouts}
    */
    readonly timeouts?: LbListenerV2Timeouts;
}
export interface LbListenerV2Timeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_listener_v2#create LbListenerV2#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_listener_v2#delete LbListenerV2#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_listener_v2#update LbListenerV2#update}
    */
    readonly update?: string;
}
export declare function lbListenerV2TimeoutsToTerraform(struct?: LbListenerV2TimeoutsOutputReference | LbListenerV2Timeouts | cdktf.IResolvable): any;
export declare class LbListenerV2TimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): LbListenerV2Timeouts | undefined;
    set internalValue(value: LbListenerV2Timeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_listener_v2 opentelekomcloud_lb_listener_v2}
*/
export declare class LbListenerV2 extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_listener_v2 opentelekomcloud_lb_listener_v2} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options LbListenerV2Config
    */
    constructor(scope: Construct, id: string, config: LbListenerV2Config);
    private _adminStateUp?;
    get adminStateUp(): boolean | cdktf.IResolvable;
    set adminStateUp(value: boolean | cdktf.IResolvable);
    resetAdminStateUp(): void;
    get adminStateUpInput(): boolean | cdktf.IResolvable | undefined;
    private _clientCaTlsContainerRef?;
    get clientCaTlsContainerRef(): string;
    set clientCaTlsContainerRef(value: string);
    resetClientCaTlsContainerRef(): void;
    get clientCaTlsContainerRefInput(): string | undefined;
    private _defaultPoolId?;
    get defaultPoolId(): string;
    set defaultPoolId(value: string);
    resetDefaultPoolId(): void;
    get defaultPoolIdInput(): string | undefined;
    private _defaultTlsContainerRef?;
    get defaultTlsContainerRef(): string;
    set defaultTlsContainerRef(value: string);
    resetDefaultTlsContainerRef(): void;
    get defaultTlsContainerRefInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _http2Enable?;
    get http2Enable(): boolean | cdktf.IResolvable;
    set http2Enable(value: boolean | cdktf.IResolvable);
    resetHttp2Enable(): void;
    get http2EnableInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _loadbalancerId?;
    get loadbalancerId(): string;
    set loadbalancerId(value: string);
    get loadbalancerIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _protocol?;
    get protocol(): string;
    set protocol(value: string);
    get protocolInput(): string | undefined;
    private _protocolPort?;
    get protocolPort(): number;
    set protocolPort(value: number);
    get protocolPortInput(): number | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _sniContainerRefs?;
    get sniContainerRefs(): string[];
    set sniContainerRefs(value: string[]);
    resetSniContainerRefs(): void;
    get sniContainerRefsInput(): string[] | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _tenantId?;
    get tenantId(): string;
    set tenantId(value: string);
    resetTenantId(): void;
    get tenantIdInput(): string | undefined;
    private _tlsCiphersPolicy?;
    get tlsCiphersPolicy(): string;
    set tlsCiphersPolicy(value: string);
    resetTlsCiphersPolicy(): void;
    get tlsCiphersPolicyInput(): string | undefined;
    private _timeouts;
    get timeouts(): LbListenerV2TimeoutsOutputReference;
    putTimeouts(value: LbListenerV2Timeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): LbListenerV2Timeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
