import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface LbListenerV3Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_listener_v3#admin_state_up LbListenerV3#admin_state_up}
    */
    readonly adminStateUp?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_listener_v3#client_ca_tls_container_ref LbListenerV3#client_ca_tls_container_ref}
    */
    readonly clientCaTlsContainerRef?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_listener_v3#client_timeout LbListenerV3#client_timeout}
    */
    readonly clientTimeout?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_listener_v3#default_pool_id LbListenerV3#default_pool_id}
    */
    readonly defaultPoolId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_listener_v3#default_tls_container_ref LbListenerV3#default_tls_container_ref}
    */
    readonly defaultTlsContainerRef?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_listener_v3#description LbListenerV3#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_listener_v3#http2_enable LbListenerV3#http2_enable}
    */
    readonly http2Enable?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_listener_v3#keep_alive_timeout LbListenerV3#keep_alive_timeout}
    */
    readonly keepAliveTimeout?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_listener_v3#loadbalancer_id LbListenerV3#loadbalancer_id}
    */
    readonly loadbalancerId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_listener_v3#member_retry_enable LbListenerV3#member_retry_enable}
    */
    readonly memberRetryEnable?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_listener_v3#member_timeout LbListenerV3#member_timeout}
    */
    readonly memberTimeout?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_listener_v3#name LbListenerV3#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_listener_v3#protocol LbListenerV3#protocol}
    */
    readonly protocol: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_listener_v3#protocol_port LbListenerV3#protocol_port}
    */
    readonly protocolPort: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_listener_v3#sni_container_refs LbListenerV3#sni_container_refs}
    */
    readonly sniContainerRefs?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_listener_v3#tags LbListenerV3#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_listener_v3#tls_ciphers_policy LbListenerV3#tls_ciphers_policy}
    */
    readonly tlsCiphersPolicy?: string;
    /**
    * insert_headers block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_listener_v3#insert_headers LbListenerV3#insert_headers}
    */
    readonly insertHeaders?: LbListenerV3InsertHeaders;
}
export interface LbListenerV3InsertHeaders {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_listener_v3#forward_elb_ip LbListenerV3#forward_elb_ip}
    */
    readonly forwardElbIp?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_listener_v3#forwarded_for_port LbListenerV3#forwarded_for_port}
    */
    readonly forwardedForPort?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_listener_v3#forwarded_host LbListenerV3#forwarded_host}
    */
    readonly forwardedHost?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_listener_v3#forwarded_port LbListenerV3#forwarded_port}
    */
    readonly forwardedPort?: boolean | cdktf.IResolvable;
}
export declare function lbListenerV3InsertHeadersToTerraform(struct?: LbListenerV3InsertHeadersOutputReference | LbListenerV3InsertHeaders): any;
export declare class LbListenerV3InsertHeadersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): LbListenerV3InsertHeaders | undefined;
    set internalValue(value: LbListenerV3InsertHeaders | undefined);
    private _forwardElbIp?;
    get forwardElbIp(): boolean | cdktf.IResolvable;
    set forwardElbIp(value: boolean | cdktf.IResolvable);
    resetForwardElbIp(): void;
    get forwardElbIpInput(): boolean | cdktf.IResolvable | undefined;
    private _forwardedForPort?;
    get forwardedForPort(): boolean | cdktf.IResolvable;
    set forwardedForPort(value: boolean | cdktf.IResolvable);
    resetForwardedForPort(): void;
    get forwardedForPortInput(): boolean | cdktf.IResolvable | undefined;
    private _forwardedHost?;
    get forwardedHost(): boolean | cdktf.IResolvable;
    set forwardedHost(value: boolean | cdktf.IResolvable);
    resetForwardedHost(): void;
    get forwardedHostInput(): boolean | cdktf.IResolvable | undefined;
    private _forwardedPort?;
    get forwardedPort(): boolean | cdktf.IResolvable;
    set forwardedPort(value: boolean | cdktf.IResolvable);
    resetForwardedPort(): void;
    get forwardedPortInput(): boolean | cdktf.IResolvable | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_listener_v3 opentelekomcloud_lb_listener_v3}
*/
export declare class LbListenerV3 extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_listener_v3 opentelekomcloud_lb_listener_v3} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options LbListenerV3Config
    */
    constructor(scope: Construct, id: string, config: LbListenerV3Config);
    private _adminStateUp?;
    get adminStateUp(): boolean | cdktf.IResolvable;
    set adminStateUp(value: boolean | cdktf.IResolvable);
    resetAdminStateUp(): void;
    get adminStateUpInput(): boolean | cdktf.IResolvable | undefined;
    private _clientCaTlsContainerRef?;
    get clientCaTlsContainerRef(): string;
    set clientCaTlsContainerRef(value: string);
    resetClientCaTlsContainerRef(): void;
    get clientCaTlsContainerRefInput(): string | undefined;
    private _clientTimeout?;
    get clientTimeout(): number;
    set clientTimeout(value: number);
    resetClientTimeout(): void;
    get clientTimeoutInput(): number | undefined;
    get createdAt(): string;
    private _defaultPoolId?;
    get defaultPoolId(): string;
    set defaultPoolId(value: string);
    resetDefaultPoolId(): void;
    get defaultPoolIdInput(): string | undefined;
    private _defaultTlsContainerRef?;
    get defaultTlsContainerRef(): string;
    set defaultTlsContainerRef(value: string);
    resetDefaultTlsContainerRef(): void;
    get defaultTlsContainerRefInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _http2Enable?;
    get http2Enable(): boolean | cdktf.IResolvable;
    set http2Enable(value: boolean | cdktf.IResolvable);
    resetHttp2Enable(): void;
    get http2EnableInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _keepAliveTimeout?;
    get keepAliveTimeout(): number;
    set keepAliveTimeout(value: number);
    resetKeepAliveTimeout(): void;
    get keepAliveTimeoutInput(): number | undefined;
    private _loadbalancerId?;
    get loadbalancerId(): string;
    set loadbalancerId(value: string);
    get loadbalancerIdInput(): string | undefined;
    private _memberRetryEnable?;
    get memberRetryEnable(): boolean | cdktf.IResolvable;
    set memberRetryEnable(value: boolean | cdktf.IResolvable);
    resetMemberRetryEnable(): void;
    get memberRetryEnableInput(): boolean | cdktf.IResolvable | undefined;
    private _memberTimeout?;
    get memberTimeout(): number;
    set memberTimeout(value: number);
    resetMemberTimeout(): void;
    get memberTimeoutInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _protocol?;
    get protocol(): string;
    set protocol(value: string);
    get protocolInput(): string | undefined;
    private _protocolPort?;
    get protocolPort(): number;
    set protocolPort(value: number);
    get protocolPortInput(): number | undefined;
    private _sniContainerRefs?;
    get sniContainerRefs(): string[];
    set sniContainerRefs(value: string[]);
    resetSniContainerRefs(): void;
    get sniContainerRefsInput(): string[] | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _tlsCiphersPolicy?;
    get tlsCiphersPolicy(): string;
    set tlsCiphersPolicy(value: string);
    resetTlsCiphersPolicy(): void;
    get tlsCiphersPolicyInput(): string | undefined;
    get updatedAt(): string;
    private _insertHeaders;
    get insertHeaders(): LbListenerV3InsertHeadersOutputReference;
    putInsertHeaders(value: LbListenerV3InsertHeaders): void;
    resetInsertHeaders(): void;
    get insertHeadersInput(): LbListenerV3InsertHeaders | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
