import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface LbMonitorV3Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_monitor_v3#admin_state_up LbMonitorV3#admin_state_up}
    */
    readonly adminStateUp?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_monitor_v3#delay LbMonitorV3#delay}
    */
    readonly delay: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_monitor_v3#domain_name LbMonitorV3#domain_name}
    */
    readonly domainName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_monitor_v3#expected_codes LbMonitorV3#expected_codes}
    */
    readonly expectedCodes?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_monitor_v3#http_method LbMonitorV3#http_method}
    */
    readonly httpMethod?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_monitor_v3#max_retries LbMonitorV3#max_retries}
    */
    readonly maxRetries: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_monitor_v3#max_retries_down LbMonitorV3#max_retries_down}
    */
    readonly maxRetriesDown?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_monitor_v3#monitor_port LbMonitorV3#monitor_port}
    */
    readonly monitorPort?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_monitor_v3#name LbMonitorV3#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_monitor_v3#pool_id LbMonitorV3#pool_id}
    */
    readonly poolId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_monitor_v3#project_id LbMonitorV3#project_id}
    */
    readonly projectId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_monitor_v3#timeout LbMonitorV3#timeout}
    */
    readonly timeout: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_monitor_v3#type LbMonitorV3#type}
    */
    readonly type: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_monitor_v3#url_path LbMonitorV3#url_path}
    */
    readonly urlPath?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_monitor_v3 opentelekomcloud_lb_monitor_v3}
*/
export declare class LbMonitorV3 extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_monitor_v3 opentelekomcloud_lb_monitor_v3} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options LbMonitorV3Config
    */
    constructor(scope: Construct, id: string, config: LbMonitorV3Config);
    private _adminStateUp?;
    get adminStateUp(): boolean | cdktf.IResolvable;
    set adminStateUp(value: boolean | cdktf.IResolvable);
    resetAdminStateUp(): void;
    get adminStateUpInput(): boolean | cdktf.IResolvable | undefined;
    private _delay?;
    get delay(): number;
    set delay(value: number);
    get delayInput(): number | undefined;
    private _domainName?;
    get domainName(): string;
    set domainName(value: string);
    resetDomainName(): void;
    get domainNameInput(): string | undefined;
    private _expectedCodes?;
    get expectedCodes(): string;
    set expectedCodes(value: string);
    resetExpectedCodes(): void;
    get expectedCodesInput(): string | undefined;
    private _httpMethod?;
    get httpMethod(): string;
    set httpMethod(value: string);
    resetHttpMethod(): void;
    get httpMethodInput(): string | undefined;
    get id(): string;
    private _maxRetries?;
    get maxRetries(): number;
    set maxRetries(value: number);
    get maxRetriesInput(): number | undefined;
    private _maxRetriesDown?;
    get maxRetriesDown(): number;
    set maxRetriesDown(value: number);
    resetMaxRetriesDown(): void;
    get maxRetriesDownInput(): number | undefined;
    private _monitorPort?;
    get monitorPort(): number;
    set monitorPort(value: number);
    resetMonitorPort(): void;
    get monitorPortInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _poolId?;
    get poolId(): string;
    set poolId(value: string);
    get poolIdInput(): string | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    resetProjectId(): void;
    get projectIdInput(): string | undefined;
    private _timeout?;
    get timeout(): number;
    set timeout(value: number);
    get timeoutInput(): number | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _urlPath?;
    get urlPath(): string;
    set urlPath(value: string);
    resetUrlPath(): void;
    get urlPathInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
