import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface LbPoolV2Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_pool_v2#admin_state_up LbPoolV2#admin_state_up}
    */
    readonly adminStateUp?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_pool_v2#description LbPoolV2#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_pool_v2#lb_method LbPoolV2#lb_method}
    */
    readonly lbMethod: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_pool_v2#listener_id LbPoolV2#listener_id}
    */
    readonly listenerId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_pool_v2#loadbalancer_id LbPoolV2#loadbalancer_id}
    */
    readonly loadbalancerId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_pool_v2#name LbPoolV2#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_pool_v2#protocol LbPoolV2#protocol}
    */
    readonly protocol: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_pool_v2#region LbPoolV2#region}
    */
    readonly region?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_pool_v2#tenant_id LbPoolV2#tenant_id}
    */
    readonly tenantId?: string;
    /**
    * persistence block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_pool_v2#persistence LbPoolV2#persistence}
    */
    readonly persistence?: LbPoolV2Persistence[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_pool_v2#timeouts LbPoolV2#timeouts}
    */
    readonly timeouts?: LbPoolV2Timeouts;
}
export interface LbPoolV2Persistence {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_pool_v2#cookie_name LbPoolV2#cookie_name}
    */
    readonly cookieName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_pool_v2#type LbPoolV2#type}
    */
    readonly type?: string;
}
export declare function lbPoolV2PersistenceToTerraform(struct?: LbPoolV2Persistence | cdktf.IResolvable): any;
export interface LbPoolV2Timeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_pool_v2#create LbPoolV2#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_pool_v2#delete LbPoolV2#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_pool_v2#update LbPoolV2#update}
    */
    readonly update?: string;
}
export declare function lbPoolV2TimeoutsToTerraform(struct?: LbPoolV2TimeoutsOutputReference | LbPoolV2Timeouts | cdktf.IResolvable): any;
export declare class LbPoolV2TimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): LbPoolV2Timeouts | undefined;
    set internalValue(value: LbPoolV2Timeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_pool_v2 opentelekomcloud_lb_pool_v2}
*/
export declare class LbPoolV2 extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_pool_v2 opentelekomcloud_lb_pool_v2} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options LbPoolV2Config
    */
    constructor(scope: Construct, id: string, config: LbPoolV2Config);
    private _adminStateUp?;
    get adminStateUp(): boolean | cdktf.IResolvable;
    set adminStateUp(value: boolean | cdktf.IResolvable);
    resetAdminStateUp(): void;
    get adminStateUpInput(): boolean | cdktf.IResolvable | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    private _lbMethod?;
    get lbMethod(): string;
    set lbMethod(value: string);
    get lbMethodInput(): string | undefined;
    private _listenerId?;
    get listenerId(): string;
    set listenerId(value: string);
    resetListenerId(): void;
    get listenerIdInput(): string | undefined;
    private _loadbalancerId?;
    get loadbalancerId(): string;
    set loadbalancerId(value: string);
    resetLoadbalancerId(): void;
    get loadbalancerIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _protocol?;
    get protocol(): string;
    set protocol(value: string);
    get protocolInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _tenantId?;
    get tenantId(): string;
    set tenantId(value: string);
    resetTenantId(): void;
    get tenantIdInput(): string | undefined;
    private _persistence?;
    get persistence(): LbPoolV2Persistence[] | cdktf.IResolvable;
    set persistence(value: LbPoolV2Persistence[] | cdktf.IResolvable);
    resetPersistence(): void;
    get persistenceInput(): cdktf.IResolvable | LbPoolV2Persistence[] | undefined;
    private _timeouts;
    get timeouts(): LbPoolV2TimeoutsOutputReference;
    putTimeouts(value: LbPoolV2Timeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): LbPoolV2Timeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
