import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface LbWhitelistV2Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_whitelist_v2#enable_whitelist LbWhitelistV2#enable_whitelist}
    */
    readonly enableWhitelist?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_whitelist_v2#listener_id LbWhitelistV2#listener_id}
    */
    readonly listenerId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_whitelist_v2#tenant_id LbWhitelistV2#tenant_id}
    */
    readonly tenantId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_whitelist_v2#whitelist LbWhitelistV2#whitelist}
    */
    readonly whitelist?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_whitelist_v2#timeouts LbWhitelistV2#timeouts}
    */
    readonly timeouts?: LbWhitelistV2Timeouts;
}
export interface LbWhitelistV2Timeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_whitelist_v2#create LbWhitelistV2#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_whitelist_v2#delete LbWhitelistV2#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_whitelist_v2#update LbWhitelistV2#update}
    */
    readonly update?: string;
}
export declare function lbWhitelistV2TimeoutsToTerraform(struct?: LbWhitelistV2TimeoutsOutputReference | LbWhitelistV2Timeouts | cdktf.IResolvable): any;
export declare class LbWhitelistV2TimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): LbWhitelistV2Timeouts | undefined;
    set internalValue(value: LbWhitelistV2Timeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_whitelist_v2 opentelekomcloud_lb_whitelist_v2}
*/
export declare class LbWhitelistV2 extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_whitelist_v2 opentelekomcloud_lb_whitelist_v2} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options LbWhitelistV2Config
    */
    constructor(scope: Construct, id: string, config: LbWhitelistV2Config);
    private _enableWhitelist?;
    get enableWhitelist(): boolean | cdktf.IResolvable;
    set enableWhitelist(value: boolean | cdktf.IResolvable);
    resetEnableWhitelist(): void;
    get enableWhitelistInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _listenerId?;
    get listenerId(): string;
    set listenerId(value: string);
    get listenerIdInput(): string | undefined;
    private _tenantId?;
    get tenantId(): string;
    set tenantId(value: string);
    resetTenantId(): void;
    get tenantIdInput(): string | undefined;
    private _whitelist?;
    get whitelist(): string;
    set whitelist(value: string);
    resetWhitelist(): void;
    get whitelistInput(): string | undefined;
    private _timeouts;
    get timeouts(): LbWhitelistV2TimeoutsOutputReference;
    putTimeouts(value: LbWhitelistV2Timeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): LbWhitelistV2Timeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
