import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MrsClusterV1Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#available_zone_id MrsClusterV1#available_zone_id}
    */
    readonly availableZoneId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#billing_type MrsClusterV1#billing_type}
    */
    readonly billingType: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#cluster_admin_secret MrsClusterV1#cluster_admin_secret}
    */
    readonly clusterAdminSecret?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#cluster_name MrsClusterV1#cluster_name}
    */
    readonly clusterName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#cluster_type MrsClusterV1#cluster_type}
    */
    readonly clusterType?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#cluster_version MrsClusterV1#cluster_version}
    */
    readonly clusterVersion: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#core_data_volume_count MrsClusterV1#core_data_volume_count}
    */
    readonly coreDataVolumeCount?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#core_data_volume_size MrsClusterV1#core_data_volume_size}
    */
    readonly coreDataVolumeSize?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#core_data_volume_type MrsClusterV1#core_data_volume_type}
    */
    readonly coreDataVolumeType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#core_node_num MrsClusterV1#core_node_num}
    */
    readonly coreNodeNum: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#core_node_size MrsClusterV1#core_node_size}
    */
    readonly coreNodeSize: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#log_collection MrsClusterV1#log_collection}
    */
    readonly logCollection?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#master_data_volume_count MrsClusterV1#master_data_volume_count}
    */
    readonly masterDataVolumeCount?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#master_data_volume_size MrsClusterV1#master_data_volume_size}
    */
    readonly masterDataVolumeSize?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#master_data_volume_type MrsClusterV1#master_data_volume_type}
    */
    readonly masterDataVolumeType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#master_node_num MrsClusterV1#master_node_num}
    */
    readonly masterNodeNum: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#master_node_size MrsClusterV1#master_node_size}
    */
    readonly masterNodeSize: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#node_public_cert_name MrsClusterV1#node_public_cert_name}
    */
    readonly nodePublicCertName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#region MrsClusterV1#region}
    */
    readonly region?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#safe_mode MrsClusterV1#safe_mode}
    */
    readonly safeMode: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#subnet_id MrsClusterV1#subnet_id}
    */
    readonly subnetId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#tags MrsClusterV1#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#volume_size MrsClusterV1#volume_size}
    */
    readonly volumeSize?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#volume_type MrsClusterV1#volume_type}
    */
    readonly volumeType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#vpc_id MrsClusterV1#vpc_id}
    */
    readonly vpcId: string;
    /**
    * add_jobs block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#add_jobs MrsClusterV1#add_jobs}
    */
    readonly addJobs?: MrsClusterV1AddJobs[] | cdktf.IResolvable;
    /**
    * bootstrap_scripts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#bootstrap_scripts MrsClusterV1#bootstrap_scripts}
    */
    readonly bootstrapScripts?: MrsClusterV1BootstrapScripts[] | cdktf.IResolvable;
    /**
    * component_list block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#component_list MrsClusterV1#component_list}
    */
    readonly componentList: MrsClusterV1ComponentList[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#timeouts MrsClusterV1#timeouts}
    */
    readonly timeouts?: MrsClusterV1Timeouts;
}
export interface MrsClusterV1AddJobs {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#arguments MrsClusterV1#arguments}
    */
    readonly arguments?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#file_action MrsClusterV1#file_action}
    */
    readonly fileAction?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#hive_script_path MrsClusterV1#hive_script_path}
    */
    readonly hiveScriptPath?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#hql MrsClusterV1#hql}
    */
    readonly hql?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#input MrsClusterV1#input}
    */
    readonly input?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#jar_path MrsClusterV1#jar_path}
    */
    readonly jarPath: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#job_log MrsClusterV1#job_log}
    */
    readonly jobLog?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#job_name MrsClusterV1#job_name}
    */
    readonly jobName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#job_type MrsClusterV1#job_type}
    */
    readonly jobType: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#output MrsClusterV1#output}
    */
    readonly output?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#shutdown_cluster MrsClusterV1#shutdown_cluster}
    */
    readonly shutdownCluster?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#submit_job_once_cluster_run MrsClusterV1#submit_job_once_cluster_run}
    */
    readonly submitJobOnceClusterRun: boolean | cdktf.IResolvable;
}
export declare function mrsClusterV1AddJobsToTerraform(struct?: MrsClusterV1AddJobs | cdktf.IResolvable): any;
export interface MrsClusterV1BootstrapScripts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#active_master MrsClusterV1#active_master}
    */
    readonly activeMaster?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#before_component_start MrsClusterV1#before_component_start}
    */
    readonly beforeComponentStart?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#fail_action MrsClusterV1#fail_action}
    */
    readonly failAction: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#name MrsClusterV1#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#nodes MrsClusterV1#nodes}
    */
    readonly nodes: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#parameters MrsClusterV1#parameters}
    */
    readonly parameters?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#uri MrsClusterV1#uri}
    */
    readonly uri: string;
}
export declare function mrsClusterV1BootstrapScriptsToTerraform(struct?: MrsClusterV1BootstrapScripts | cdktf.IResolvable): any;
export interface MrsClusterV1ComponentList {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#component_name MrsClusterV1#component_name}
    */
    readonly componentName: string;
}
export declare function mrsClusterV1ComponentListToTerraform(struct?: MrsClusterV1ComponentList | cdktf.IResolvable): any;
export interface MrsClusterV1Timeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#create MrsClusterV1#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1#delete MrsClusterV1#delete}
    */
    readonly delete?: string;
}
export declare function mrsClusterV1TimeoutsToTerraform(struct?: MrsClusterV1TimeoutsOutputReference | MrsClusterV1Timeouts | cdktf.IResolvable): any;
export declare class MrsClusterV1TimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): MrsClusterV1Timeouts | undefined;
    set internalValue(value: MrsClusterV1Timeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1 opentelekomcloud_mrs_cluster_v1}
*/
export declare class MrsClusterV1 extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1 opentelekomcloud_mrs_cluster_v1} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MrsClusterV1Config
    */
    constructor(scope: Construct, id: string, config: MrsClusterV1Config);
    private _availableZoneId?;
    get availableZoneId(): string;
    set availableZoneId(value: string);
    get availableZoneIdInput(): string | undefined;
    get availableZoneName(): string;
    private _billingType?;
    get billingType(): number;
    set billingType(value: number);
    get billingTypeInput(): number | undefined;
    get chargingStartTime(): string;
    private _clusterAdminSecret?;
    get clusterAdminSecret(): string;
    set clusterAdminSecret(value: string);
    resetClusterAdminSecret(): void;
    get clusterAdminSecretInput(): string | undefined;
    get clusterId(): string;
    private _clusterName?;
    get clusterName(): string;
    set clusterName(value: string);
    get clusterNameInput(): string | undefined;
    get clusterState(): string;
    private _clusterType?;
    get clusterType(): number;
    set clusterType(value: number);
    resetClusterType(): void;
    get clusterTypeInput(): number | undefined;
    private _clusterVersion?;
    get clusterVersion(): string;
    set clusterVersion(value: string);
    get clusterVersionInput(): string | undefined;
    private _coreDataVolumeCount?;
    get coreDataVolumeCount(): number;
    set coreDataVolumeCount(value: number);
    resetCoreDataVolumeCount(): void;
    get coreDataVolumeCountInput(): number | undefined;
    private _coreDataVolumeSize?;
    get coreDataVolumeSize(): number;
    set coreDataVolumeSize(value: number);
    resetCoreDataVolumeSize(): void;
    get coreDataVolumeSizeInput(): number | undefined;
    private _coreDataVolumeType?;
    get coreDataVolumeType(): string;
    set coreDataVolumeType(value: string);
    resetCoreDataVolumeType(): void;
    get coreDataVolumeTypeInput(): string | undefined;
    private _coreNodeNum?;
    get coreNodeNum(): number;
    set coreNodeNum(value: number);
    get coreNodeNumInput(): number | undefined;
    get coreNodeProductId(): string;
    private _coreNodeSize?;
    get coreNodeSize(): string;
    set coreNodeSize(value: string);
    get coreNodeSizeInput(): string | undefined;
    get coreNodeSpecId(): string;
    get createAt(): string;
    get deploymentId(): string;
    get duration(): string;
    get errorInfo(): string;
    get externalAlternateIp(): string;
    get externalIp(): string;
    get fee(): string;
    get hadoopVersion(): string;
    get id(): string;
    get instanceId(): string;
    get internalIp(): string;
    private _logCollection?;
    get logCollection(): number;
    set logCollection(value: number);
    resetLogCollection(): void;
    get logCollectionInput(): number | undefined;
    private _masterDataVolumeCount?;
    get masterDataVolumeCount(): number;
    set masterDataVolumeCount(value: number);
    resetMasterDataVolumeCount(): void;
    get masterDataVolumeCountInput(): number | undefined;
    private _masterDataVolumeSize?;
    get masterDataVolumeSize(): number;
    set masterDataVolumeSize(value: number);
    resetMasterDataVolumeSize(): void;
    get masterDataVolumeSizeInput(): number | undefined;
    private _masterDataVolumeType?;
    get masterDataVolumeType(): string;
    set masterDataVolumeType(value: string);
    resetMasterDataVolumeType(): void;
    get masterDataVolumeTypeInput(): string | undefined;
    get masterNodeIp(): string;
    private _masterNodeNum?;
    get masterNodeNum(): number;
    set masterNodeNum(value: number);
    get masterNodeNumInput(): number | undefined;
    get masterNodeProductId(): string;
    private _masterNodeSize?;
    get masterNodeSize(): string;
    set masterNodeSize(value: string);
    get masterNodeSizeInput(): string | undefined;
    get masterNodeSpecId(): string;
    private _nodePublicCertName?;
    get nodePublicCertName(): string;
    set nodePublicCertName(value: string);
    get nodePublicCertNameInput(): string | undefined;
    get orderId(): string;
    get privateIpFirst(): string;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    get remark(): string;
    private _safeMode?;
    get safeMode(): number;
    set safeMode(value: number);
    get safeModeInput(): number | undefined;
    get securityGroupsId(): string;
    get slaveSecurityGroupsId(): string;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    get subnetIdInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    get tenantId(): string;
    get updateAt(): string;
    get vnc(): string;
    private _volumeSize?;
    get volumeSize(): number;
    set volumeSize(value: number);
    resetVolumeSize(): void;
    get volumeSizeInput(): number | undefined;
    private _volumeType?;
    get volumeType(): string;
    set volumeType(value: string);
    resetVolumeType(): void;
    get volumeTypeInput(): string | undefined;
    private _vpcId?;
    get vpcId(): string;
    set vpcId(value: string);
    get vpcIdInput(): string | undefined;
    private _addJobs?;
    get addJobs(): MrsClusterV1AddJobs[] | cdktf.IResolvable;
    set addJobs(value: MrsClusterV1AddJobs[] | cdktf.IResolvable);
    resetAddJobs(): void;
    get addJobsInput(): cdktf.IResolvable | MrsClusterV1AddJobs[] | undefined;
    private _bootstrapScripts?;
    get bootstrapScripts(): MrsClusterV1BootstrapScripts[] | cdktf.IResolvable;
    set bootstrapScripts(value: MrsClusterV1BootstrapScripts[] | cdktf.IResolvable);
    resetBootstrapScripts(): void;
    get bootstrapScriptsInput(): cdktf.IResolvable | MrsClusterV1BootstrapScripts[] | undefined;
    private _componentList?;
    get componentList(): MrsClusterV1ComponentList[] | cdktf.IResolvable;
    set componentList(value: MrsClusterV1ComponentList[] | cdktf.IResolvable);
    get componentListInput(): cdktf.IResolvable | MrsClusterV1ComponentList[] | undefined;
    private _timeouts;
    get timeouts(): MrsClusterV1TimeoutsOutputReference;
    putTimeouts(value: MrsClusterV1Timeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): MrsClusterV1Timeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
